/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.distribution;

import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;

@DefaultFactoryFor(classes={KeyPartitioner.class})
public class KeyPartitionerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Inject
    GroupManager groupManager;

    public Object construct(String componentName) {
        if (!this.configuration.clustering().cacheMode().isClustered() && !this.configuration.persistence().usingSegmentedStore()) {
            return SingleSegmentKeyPartitioner.getInstance();
        }
        HashConfiguration hashConfiguration = this.configuration.clustering().hash();
        KeyPartitioner partitioner = hashConfiguration.keyPartitioner();
        partitioner.init(hashConfiguration);
        this.basicComponentRegistry.wireDependencies((Object)partitioner, false);
        return this.groupManager != null ? new GroupingPartitioner(partitioner, this.groupManager) : partitioner;
    }
}

