/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;

public class MicroProfileHealthReporter {
    public static final String DOWN = "DOWN";
    public static final String UP = "UP";
    private final boolean defaultServerProceduresDisabled;
    private Map<HealthCheck, ClassLoader> healthChecks = new HashMap<HealthCheck, ClassLoader>();
    private Map<HealthCheck, ClassLoader> livenessChecks = new HashMap<HealthCheck, ClassLoader>();
    private Map<HealthCheck, ClassLoader> readinessChecks = new HashMap<HealthCheck, ClassLoader>();
    private Map<HealthCheck, ClassLoader> serverReadinessChecks = new HashMap<HealthCheck, ClassLoader>();
    private final HealthCheck emptyDeploymentLivenessCheck;
    private final HealthCheck emptyDeploymentReadinessCheck;

    public MicroProfileHealthReporter(String emptyLivenessChecksStatus, String emptyReadinessChecksStatus, boolean defaultServerProceduresDisabled) {
        this.emptyDeploymentLivenessCheck = new EmptyDeploymentCheckStatus("empty-liveness-checks", emptyLivenessChecksStatus);
        this.emptyDeploymentReadinessCheck = new EmptyDeploymentCheckStatus("empty-readiness-checks", emptyReadinessChecksStatus);
        this.defaultServerProceduresDisabled = defaultServerProceduresDisabled;
    }

    public SmallRyeHealth getHealth() {
        HashMap<HealthCheck, ClassLoader> deploymentChecks = new HashMap<HealthCheck, ClassLoader>();
        deploymentChecks.putAll(this.healthChecks);
        deploymentChecks.putAll(this.livenessChecks);
        deploymentChecks.putAll(this.readinessChecks);
        HashMap<HealthCheck, ClassLoader> serverChecks = new HashMap<HealthCheck, ClassLoader>();
        serverChecks.putAll(this.serverReadinessChecks);
        if (deploymentChecks.size() == 0 && !this.defaultServerProceduresDisabled) {
            serverChecks.put(this.emptyDeploymentLivenessCheck, Thread.currentThread().getContextClassLoader());
            serverChecks.put(this.emptyDeploymentReadinessCheck, Thread.currentThread().getContextClassLoader());
        }
        return this.getHealth(serverChecks, deploymentChecks);
    }

    public SmallRyeHealth getLiveness() {
        Map<HealthCheck, ClassLoader> serverChecks = this.livenessChecks.size() == 0 && !this.defaultServerProceduresDisabled ? Collections.singletonMap(this.emptyDeploymentLivenessCheck, Thread.currentThread().getContextClassLoader()) : Collections.emptyMap();
        return this.getHealth(serverChecks, this.livenessChecks);
    }

    public SmallRyeHealth getReadiness() {
        HashMap<HealthCheck, ClassLoader> serverChecks = new HashMap<HealthCheck, ClassLoader>();
        serverChecks.putAll(this.serverReadinessChecks);
        if (this.readinessChecks.size() == 0 && !this.defaultServerProceduresDisabled) {
            serverChecks.put(this.emptyDeploymentReadinessCheck, Thread.currentThread().getContextClassLoader());
        }
        return this.getHealth(serverChecks, this.readinessChecks);
    }

    private final SmallRyeHealth getHealth(Map<HealthCheck, ClassLoader> serverChecks, Map<HealthCheck, ClassLoader> deploymentChecks) {
        JsonArrayBuilder results = Json.createArrayBuilder();
        HealthCheckResponse.State status = HealthCheckResponse.State.UP;
        status = this.processChecks(serverChecks, results, status);
        status = this.processChecks(deploymentChecks, results, status);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonArray checkResults = results.build();
        builder.add("status", status.toString());
        builder.add("checks", (JsonValue)checkResults);
        return new SmallRyeHealth(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse.State processChecks(Map<HealthCheck, ClassLoader> checks, JsonArrayBuilder results, HealthCheckResponse.State status) {
        if (checks != null) {
            for (Map.Entry<HealthCheck, ClassLoader> entry : checks.entrySet()) {
                ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(entry.getValue());
                    status = this.fillCheck(entry.getKey(), results, status);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldTCCL);
                }
            }
        }
        return status;
    }

    private HealthCheckResponse.State fillCheck(HealthCheck check, JsonArrayBuilder results, HealthCheckResponse.State globalOutcome) {
        String status;
        JsonObject each = this.jsonObject(check);
        results.add((JsonValue)each);
        if (globalOutcome == HealthCheckResponse.State.UP && (status = each.getString("status")).equals(DOWN)) {
            return HealthCheckResponse.State.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheck check) {
        try {
            return this.jsonObject(check.call());
        }
        catch (RuntimeException e) {
            MicroProfileHealthLogger.LOGGER.error("Error processing Health Checks", e);
            HealthCheckResponseBuilder response = HealthCheckResponse.named((String)check.getClass().getName()).down();
            return this.jsonObject(response.build());
        }
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("status", response.getState().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = Json.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            builder.add("data", (JsonValue)data.build());
        });
        return builder.build();
    }

    public void addHealthCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.healthChecks.put(check, moduleClassLoader);
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.healthChecks.remove(check);
    }

    public void addReadinessCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.readinessChecks.put(check, moduleClassLoader);
        }
    }

    public void addServerReadinessCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.serverReadinessChecks.put(check, moduleClassLoader);
        }
    }

    public void removeReadinessCheck(HealthCheck check) {
        this.readinessChecks.remove(check);
    }

    public void addLivenessCheck(HealthCheck check, ClassLoader moduleClassLoader) {
        if (check != null) {
            this.livenessChecks.put(check, moduleClassLoader);
        }
    }

    public void removeLivenessCheck(HealthCheck check) {
        this.livenessChecks.remove(check);
    }

    private static class EmptyDeploymentCheckStatus
    implements HealthCheck {
        private final String name;
        private final String status;

        EmptyDeploymentCheckStatus(String name, String status) {
            this.name = name;
            this.status = status;
        }

        public HealthCheckResponse call() {
            return HealthCheckResponse.named((String)this.name).state(this.status.equals(MicroProfileHealthReporter.UP)).build();
        }
    }
}

