/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class FieldProtoStreamMarshaller<T>
implements ProtoStreamMarshaller<T> {
    private final Field<T> field;

    public FieldProtoStreamMarshaller(Field<T> field) {
        this.field = field;
    }

    @Override
    public String getTypeName() {
        return this.field.getTypeName();
    }

    public Class<? extends T> getJavaClass() {
        return this.field.getJavaClass();
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        if (WireFormat.getTagFieldNumber((int)reader.readTag()) != this.field.getIndex()) {
            throw new StreamCorruptedException();
        }
        Object result = this.field.readFrom(context, reader);
        if (reader.readTag() != 0) {
            throw new StreamCorruptedException();
        }
        return (T)result;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T object) throws IOException {
        this.field.writeTo(context, writer, object);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T value) {
        OptionalInt size = this.field.size(context, value);
        return size.isPresent() ? OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(this.field.getIndex() << 3 | 0)) : OptionalInt.empty();
    }
}

