/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class ForkChannelFactoryServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<ChannelFactory>,
Consumer<ChannelFactory> {
    private final PathAddress address;
    private volatile List<SupplierDependency<ProtocolConfiguration<? extends Protocol>>> protocols;
    private volatile SupplierDependency<JChannel> parentChannel;
    private volatile SupplierDependency<ChannelFactory> parentFactory;

    public ForkChannelFactoryServiceConfigurator(Capability capability, PathAddress address) {
        super(capability, address);
        this.address = address;
    }

    @Override
    public ChannelFactory get() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (Supplier supplier : this.protocols) {
            protocols.add((ProtocolConfiguration<? extends Protocol>)supplier.get());
        }
        return new ForkChannelFactory((JChannel)this.parentChannel.get(), (ChannelFactory)this.parentFactory.get(), protocols);
    }

    @Override
    public void accept(ChannelFactory factory) {
        ProtocolStack stack = ((JChannel)this.parentChannel.get()).getProtocolStack();
        FORK fork = (FORK)stack.findProtocol(FORK.class);
        fork.remove(this.address.getLastElement().getValue());
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.parentChannel, this.parentFactory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PlaceholderResource resource = context.getCurrentAddress().equals(this.address) ? context.readResourceFromRoot(this.address, false) : PlaceholderResource.INSTANCE;
        Set entries = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        this.protocols = new ArrayList<SupplierDependency<ProtocolConfiguration<? extends Protocol>>>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            this.protocols.add((SupplierDependency<ProtocolConfiguration<? extends Protocol>>)new ServiceSupplierDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement())));
        }
        String channelName = this.address.getParent().getLastElement().getValue();
        this.parentChannel = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL.getServiceName(context, channelName));
        this.parentFactory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channelName));
        return this;
    }
}

