/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.jaxrs;

import java.io.IOException;
import javax.annotation.Priority;
import javax.transaction.SystemException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransactionContext;

@Provider
@Priority(value=4920)
public class ImportWildflyClientGlobalTransactionFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            LocalTransactionContext.getCurrent().importProviderTransaction();
        }
        catch (SystemException se) {
            throw RTSLogger.ROOT_LOGGER.failueOnImportingGlobalTransactionFromWildflyClient(se);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        try {
            if (ContextTransactionManager.getInstance() != null && ContextTransactionManager.getInstance().getStatus() != 6) {
                ContextTransactionManager.getInstance().suspend();
            }
        }
        catch (SystemException se) {
            RTSLogger.ROOT_LOGGER.cannotGetTransactionStatus(responseContext, se);
        }
    }
}

