/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.Tombstone;

public class TombstoneUpdate<T>
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent {
    private static final UUID ZERO = new UUID(0L, 0L);
    private final long timestamp;
    private final T value;
    private transient InfinispanDataRegion region;

    public TombstoneUpdate(long timestamp, T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TombstoneUpdate{");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        Object storedValue = view.find().orElse(null);
        if (this.value == null) {
            if (storedValue != null && !(storedValue instanceof Tombstone)) {
                view.set((Object)new Tombstone(ZERO, this.timestamp), new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
            }
        } else if (storedValue instanceof Tombstone) {
            Tombstone tombstone = storedValue;
            if (tombstone.getLastTimestamp() < this.timestamp) {
                view.set(this.value, new MetaParam.Writable[0]);
            }
        } else if (storedValue == null) {
            if (this.region.getLastRegionInvalidation() < this.timestamp) {
                view.set(this.value, new MetaParam.Writable[0]);
            }
        } else {
            view.set(storedValue, new MetaParam.Writable[]{(MetaParam.Writable)view.findMetaParam(MetaParam.MetaLifespan.class).get()});
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }

    public static class Externalizer
    implements AdvancedExternalizer<TombstoneUpdate> {
        public Set<Class<? extends TombstoneUpdate>> getTypeClasses() {
            return Collections.singleton(TombstoneUpdate.class);
        }

        public Integer getId() {
            return 1203;
        }

        public void writeObject(ObjectOutput output, TombstoneUpdate object) throws IOException {
            output.writeObject(object.getValue());
            output.writeLong(object.getTimestamp());
        }

        public TombstoneUpdate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            long timestamp = input.readLong();
            return new TombstoneUpdate<Object>(timestamp, value);
        }
    }
}

