/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.ws.WebServiceException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.config.DisabledOperationException;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public class WSLogger_$logger
extends DelegatingBasicLogger
implements WSLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WSLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public WSLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotLoadDeploymentAspectsDefinitionFile(String resourcePath) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotLoadDeploymentAspectsDefinitionFile$str(), (Object)resourcePath);
    }

    protected String cannotLoadDeploymentAspectsDefinitionFile$str() {
        return "WFLYWS0001: Cannot load WS deployment aspects from %s";
    }

    @Override
    public final RuntimeException cannotLoadDeploymentAspectsDefinitionFile(Throwable cause, String resourcePath) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotLoadDeploymentAspectsDefinitionFile$str(), resourcePath), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void activatingWebservicesExtension() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingWebservicesExtension$str(), new Object[0]);
    }

    protected String activatingWebservicesExtension$str() {
        return "WFLYWS0002: Activating WebServices Extension";
    }

    @Override
    public final void starting(Object object) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.starting$str(), object);
    }

    protected String starting$str() {
        return "WFLYWS0003: Starting %s";
    }

    @Override
    public final void stopping(Object object) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stopping$str(), object);
    }

    protected String stopping$str() {
        return "WFLYWS0004: Stopping %s";
    }

    @Override
    public final void configServiceCreationFailed() {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.configServiceCreationFailed$str(), new Object[0]);
    }

    protected String configServiceCreationFailed$str() {
        return "WFLYWS0005: Error while creating configuration service";
    }

    @Override
    public final void configServiceDestroyFailed() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.configServiceDestroyFailed$str(), new Object[0]);
    }

    protected String configServiceDestroyFailed$str() {
        return "WFLYWS0006: Error while destroying configuration service";
    }

    @Override
    public final void cannotReadWsdl(String wsdlLocation) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotReadWsdl$str(), (Object)wsdlLocation);
    }

    protected String cannotReadWsdl$str() {
        return "WFLYWS0007: Could not read WSDL from: %s";
    }

    @Override
    public final void mutuallyExclusiveAnnotations(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mutuallyExclusiveAnnotations$str(), (Object)className);
    }

    protected String mutuallyExclusiveAnnotations$str() {
        return "WFLYWS0008: [JAXWS 2.2 spec, section 7.7] The @WebService and @WebServiceProvider annotations are mutually exclusive - %s won't be considered as a webservice endpoint, since it doesn't meet that requirement";
    }

    @Override
    public final void finalEndpointClassDetected(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.finalEndpointClassDetected$str(), (Object)className);
    }

    protected String finalEndpointClassDetected$str() {
        return "WFLYWS0009: WebService endpoint class cannot be final - %s won't be considered as a webservice endpoint";
    }

    @Override
    public final void ignoringPortComponentRef(Object o) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringPortComponentRef$str(), o);
    }

    protected String ignoringPortComponentRef$str() {
        return "WFLYWS0010: Ignoring <port-component-ref> without <service-endpoint-interface> and <port-qname>: %s";
    }

    @Override
    public final void cannotRegisterRecordProcessor() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotRegisterRecordProcessor$str(), new Object[0]);
    }

    protected String cannotRegisterRecordProcessor$str() {
        return "WFLYWS0011: Cannot register record processor in JMX server";
    }

    @Override
    public final void cannotUnregisterRecordProcessor() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotUnregisterRecordProcessor$str(), new Object[0]);
    }

    protected String cannotUnregisterRecordProcessor$str() {
        return "WFLYWS0012: Cannot unregister record processor from JMX server";
    }

    @Override
    public final void mBeanServerNotAvailable(Object bean) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.mBeanServerNotAvailable$str(), bean);
    }

    protected String mBeanServerNotAvailable$str() {
        return "WFLYWS0013: MBeanServer not available, skipping registration/unregistration of %s";
    }

    @Override
    public final void multipleEndpointsWithDifferentDeclaredSecurityRoles() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleEndpointsWithDifferentDeclaredSecurityRoles$str(), new Object[0]);
    }

    protected String multipleEndpointsWithDifferentDeclaredSecurityRoles$str() {
        return "WFLYWS0014: Multiple Enterprise Beans 3 endpoints in the same deployment with different declared security roles; be aware this might be a security risk if you're not controlling allowed roles (@RolesAllowed) on each ws endpoint method.";
    }

    @Override
    public final void cannotRegisterEndpoint(Object endpoint) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotRegisterEndpoint$str(), endpoint);
    }

    protected String cannotRegisterEndpoint$str() {
        return "WFLYWS0015: Cannot register endpoint: %s in JMX server";
    }

    @Override
    public final void cannotUnregisterEndpoint(Object endpoint) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotUnregisterEndpoint$str(), endpoint);
    }

    protected String cannotUnregisterEndpoint$str() {
        return "WFLYWS0016: Cannot unregister endpoint: %s from JMX server";
    }

    @Override
    public final void invalidHandlerChainFile(String fileName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidHandlerChainFile$str(), (Object)fileName);
    }

    protected String invalidHandlerChainFile$str() {
        return "WFLYWS0017: Invalid handler chain file: %s";
    }

    @Override
    public final void webMethodMustNotBeStaticOrFinal(Method staticWebMethod) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.webMethodMustNotBeStaticOrFinal$str(), (Object)staticWebMethod);
    }

    protected String webMethodMustNotBeStaticOrFinal$str() {
        return "WFLYWS0018: Web service method %s must not be static or final. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".";
    }

    @Override
    public final void webMethodMustBePublic(Method staticWebMethod) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.webMethodMustBePublic$str(), (Object)staticWebMethod);
    }

    protected String webMethodMustBePublic$str() {
        return "WFLYWS0019: Web service method %s must be public. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".";
    }

    @Override
    public final void webServiceMethodNotFound(Class<?> endpointClass, Method potentialWebMethod) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.webServiceMethodNotFound$str(), endpointClass, (Object)potentialWebMethod);
    }

    protected String webServiceMethodNotFound$str() {
        return "WFLYWS0020: Web service implementation class %s does not contain method %s";
    }

    @Override
    public final void accessibleWebServiceMethodNotFound(Class<?> endpointClass, Method potentialWebMethod, SecurityException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.accessibleWebServiceMethodNotFound$str(), endpointClass, (Object)potentialWebMethod);
    }

    protected String accessibleWebServiceMethodNotFound$str() {
        return "WFLYWS0021: Web service implementation class %s does not contain an accessible method %s";
    }

    @Override
    public final void finalizeMethodNotAllowed(Class<?> seiClass) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.finalizeMethodNotAllowed$str(), seiClass);
    }

    protected String finalizeMethodNotAllowed$str() {
        return "WFLYWS0022: Web service implementation class %s may not declare a finalize() method. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".";
    }

    protected String nullEndpointName$str() {
        return "WFLYWS0023: Null endpoint name";
    }

    @Override
    public final NullPointerException nullEndpointName() {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.nullEndpointName$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullEndpointClass$str() {
        return "WFLYWS0024: Null endpoint class";
    }

    @Override
    public final NullPointerException nullEndpointClass() {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.nullEndpointClass$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classLoaderResolutionFailed$str() {
        return "WFLYWS0025: Cannot resolve module or classloader for deployment %s";
    }

    @Override
    public final IllegalStateException classLoaderResolutionFailed(Object o) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.classLoaderResolutionFailed$str(), o));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingHandlerChainConfigFile$str() {
        return "WFLYWS0026: Handler chain config file %s not found in %s";
    }

    @Override
    public final WebServiceException missingHandlerChainConfigFile(String filePath, ResourceRoot resourceRoot) {
        WebServiceException result = new WebServiceException(String.format(this.getLoggingLocale(), this.missingHandlerChainConfigFile$str(), filePath, resourceRoot));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedElement$str() {
        return "WFLYWS0027: Unexpected element: %s";
    }

    @Override
    public final IllegalStateException unexpectedElement(String elementName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedElement$str(), elementName));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEndTag$str() {
        return "WFLYWS0028: Unexpected end tag: %s";
    }

    @Override
    public final IllegalStateException unexpectedEndTag(String tagName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedEndTag$str(), tagName));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEndOfDocument$str() {
        return "WFLYWS0029: Reached end of xml document unexpectedly";
    }

    @Override
    public final IllegalStateException unexpectedEndOfDocument() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedEndOfDocument$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingDeploymentAspectClassAttribute$str() {
        return "WFLYWS0030: Could not find class attribute for deployment aspect";
    }

    @Override
    public final IllegalStateException missingDeploymentAspectClassAttribute() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingDeploymentAspectClassAttribute$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateDeploymentAspect$str() {
        return "WFLYWS0031: Could not create a deployment aspect of class: %s";
    }

    @Override
    public final IllegalStateException cannotInstantiateDeploymentAspect(Throwable cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInstantiateDeploymentAspect$str(), className), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPropertyNameAttribute$str() {
        return "WFLYWS0032: Could not find property name attribute for deployment aspect: %s";
    }

    @Override
    public final IllegalStateException missingPropertyNameAttribute(DeploymentAspect deploymentAspect) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingPropertyNameAttribute$str(), deploymentAspect));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPropertyClassAttribute$str() {
        return "WFLYWS0033: Could not find property class attribute for deployment aspect: %s";
    }

    @Override
    public final IllegalStateException missingPropertyClassAttribute(DeploymentAspect deploymentAspect) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingPropertyClassAttribute$str(), deploymentAspect));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedPropertyClass$str() {
        return "WFLYWS0034: Unsupported property class: %s";
    }

    @Override
    public final IllegalArgumentException unsupportedPropertyClass(String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedPropertyClass$str(), className));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateList$str() {
        return "WFLYWS0035: Could not create list of type: %s";
    }

    @Override
    public final IllegalStateException cannotInstantiateList(Throwable cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInstantiateList$str(), className), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateMap$str() {
        return "WFLYWS0036: Could not create map of type: %s";
    }

    @Override
    public final IllegalStateException cannotInstantiateMap(Throwable cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInstantiateMap$str(), className), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMetricsAvailable$str() {
        return "WFLYWS0037: No metrics available";
    }

    @Override
    public final String noMetricsAvailable() {
        return String.format(this.getLoggingLocale(), this.noMetricsAvailable$str(), new Object[0]);
    }

    protected String cannotFindComponentView$str() {
        return "WFLYWS0038: Cannot find component view: %s";
    }

    @Override
    public final IllegalStateException cannotFindComponentView(ServiceName viewName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotFindComponentView$str(), viewName));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingChild$str() {
        return "WFLYWS0039: Child '%s' not found for VirtualFile: %s";
    }

    @Override
    public final IOException missingChild(String child, VirtualFile file) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.missingChild$str(), child, file));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String createContextPhaseFailed$str() {
        return "WFLYWS0040: Failed to create context";
    }

    @Override
    public final Exception createContextPhaseFailed(Throwable cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.createContextPhaseFailed$str(), new Object[0]), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String startContextPhaseFailed$str() {
        return "WFLYWS0041: Failed to start context";
    }

    @Override
    public final Exception startContextPhaseFailed(Throwable cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.startContextPhaseFailed$str(), new Object[0]), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stopContextPhaseFailed$str() {
        return "WFLYWS0042: Failed to stop context";
    }

    @Override
    public final Exception stopContextPhaseFailed(Throwable cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.stopContextPhaseFailed$str(), new Object[0]), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String destroyContextPhaseFailed$str() {
        return "WFLYWS0043: Failed to destroy context";
    }

    @Override
    public final Exception destroyContextPhaseFailed(Throwable cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.destroyContextPhaseFailed$str(), new Object[0]), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateServletDelegate$str() {
        return "WFLYWS0044: Cannot create servlet delegate: %s";
    }

    @Override
    public final IllegalStateException cannotInstantiateServletDelegate(Throwable cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInstantiateServletDelegate$str(), className), cause);
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingDeploymentProperty$str() {
        return "WFLYWS0045: Cannot obtain deployment property: %s";
    }

    @Override
    public final IllegalStateException missingDeploymentProperty(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingDeploymentProperty$str(), propertyName));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleSecurityDomainsDetected$str() {
        return "WFLYWS0046: Multiple security domains not supported. First domain: '%s' second domain: '%s'";
    }

    @Override
    public final IllegalStateException multipleSecurityDomainsDetected(String firstDomain, String secondDomain) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.multipleSecurityDomainsDetected$str(), firstDomain, secondDomain));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sameUrlPatternRequested$str() {
        return "WFLYWS0047: Web Service endpoint %s with URL pattern %s is already registered. Web service endpoint %s is requesting the same URL pattern.";
    }

    @Override
    public final IllegalArgumentException sameUrlPatternRequested(String firstClass, String urlPattern, String secondClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.sameUrlPatternRequested$str(), firstClass, urlPattern, secondClass));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidServiceRefSetterMethodName$str() {
        return "WFLYWS0048: @WebServiceRef injection target is invalid.  Only setter methods are allowed: %s";
    }

    @Override
    public final DeploymentUnitProcessingException invalidServiceRefSetterMethodName(Object o) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidServiceRefSetterMethodName$str(), o));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredServiceRefName$str() {
        return "WFLYWS0049: @WebServiceRef attribute 'name' is required for class level annotations.";
    }

    @Override
    public final DeploymentUnitProcessingException requiredServiceRefName() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.requiredServiceRefName$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredServiceRefType$str() {
        return "WFLYWS0050: @WebServiceRef attribute 'type' is required for class level annotations.";
    }

    @Override
    public final DeploymentUnitProcessingException requiredServiceRefType() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.requiredServiceRefType$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingConfig$str() {
        return "WFLYWS0051: Config %s doesn't exist";
    }

    @Override
    public final OperationFailedException missingConfig(String configName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.missingConfig$str(), configName));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wrongHandlerChainType$str() {
        return "WFLYWS0052: Unsupported handler chain type: %s. Supported types are either %s or %s";
    }

    @Override
    public final StartException wrongHandlerChainType(String unknownChainType, String knownChainType1, String knownChainType2) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.wrongHandlerChainType$str(), unknownChainType, knownChainType1, knownChainType2));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingHandlerChain$str() {
        return "WFLYWS0054: Config %s: %s handler chain with id %s doesn't exist";
    }

    @Override
    public final OperationFailedException missingHandlerChain(String configName, String handlerChainType, String handlerChainId) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.missingHandlerChain$str(), configName, handlerChainType, handlerChainId));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGetURLForDescriptor$str() {
        return "WFLYWS0057: Unable to get URL for: %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotGetURLForDescriptor(Throwable cause, String resourcePath) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotGetURLForDescriptor$str(), resourcePath), cause);
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String jaxRpcNotSupported$str() {
        return "WFLYWS0058: Jakarta XML RPC not supported";
    }

    @Override
    public final DeploymentUnitProcessingException jaxRpcNotSupported() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.jaxRpcNotSupported$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidLibraryInDeployment$str() {
        return "WFLYWS0059: %s library (%s) detected in ws endpoint deployment; either provide a proper deployment replacing embedded libraries with container module dependencies or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Jakarta EE and any JBossWS specific functionality to be disabled.";
    }

    @Override
    public final DeploymentUnitProcessingException invalidLibraryInDeployment(String libraryName, String jar) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidLibraryInDeployment$str(), libraryName, jar));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String endpointClassNotFound$str() {
        return "WFLYWS0060: Web service endpoint class %s not found";
    }

    @Override
    public final DeploymentUnitProcessingException endpointClassNotFound(String endpointClassName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.endpointClassNotFound$str(), endpointClassName));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String declaredEndpointInterfaceClassNotFound$str() {
        return "WFLYWS0061: The endpointInterface %s declared in the @WebService annotation on web service implementation bean %s was not found.";
    }

    @Override
    public final DeploymentUnitProcessingException declaredEndpointInterfaceClassNotFound(String endpointInterface, Class<?> endpointClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.declaredEndpointInterfaceClassNotFound$str(), endpointInterface, endpointClass));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String jwsWebServiceClassVerificationFailed$str() {
        return "WFLYWS0062: Class verification of Java Web Service implementation class %s failed.";
    }

    @Override
    public final DeploymentUnitProcessingException jwsWebServiceClassVerificationFailed(Class<?> seiClass) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.jwsWebServiceClassVerificationFailed$str(), seiClass));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotUpdateServerConfigBecauseOfReloadRequired$str() {
        return "WFLYWS0063: Could not update WS server configuration because of pending former model update(s) requiring reload.";
    }

    @Override
    public final DisabledOperationException couldNotUpdateServerConfigBecauseOfReloadRequired() {
        DisabledOperationException result = new DisabledOperationException(String.format(this.getLoggingLocale(), this.couldNotUpdateServerConfigBecauseOfReloadRequired$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotUpdateServerConfigBecauseOfExistingWSDeployment$str() {
        return "WFLYWS0064: Could not update WS server configuration because of existing WS deployment on the server.";
    }

    @Override
    public final DisabledOperationException couldNotUpdateServerConfigBecauseOfExistingWSDeployment() {
        DisabledOperationException result = new DisabledOperationException(String.format(this.getLoggingLocale(), this.couldNotUpdateServerConfigBecauseOfExistingWSDeployment$str(), new Object[0]));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void missingModuleDependency(String annotation, String clazz, String module) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingModuleDependency$str(), (Object)annotation, (Object)clazz, (Object)module);
    }

    protected String missingModuleDependency$str() {
        return "WFLYWS0065: Annotation '@%s' found on class '%s'. Perhaps you forgot to add a '%s' module dependency to your deployment?";
    }

    protected String invalidWSServlet$str() {
        return "WFLYWS0066: Servlet class %s declared in web.xml; either provide a proper deployment relying on JBossWS or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Jakarta EE and any JBossWS specific functionality to be disabled.";
    }

    @Override
    public final WSFException invalidWSServlet(String servletClass) {
        WSFException result = new WSFException(String.format(this.getLoggingLocale(), this.invalidWSServlet$str(), servletClass));
        WSLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void couldNotActivateSubsystem(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.couldNotActivateSubsystem$str(), new Object[0]);
    }

    protected String couldNotActivateSubsystem$str() {
        return "WFLYWS0067: Could not activate the webservices subsystem.";
    }

    @Override
    public final void failedAuthorization(String username) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedAuthorization$str(), (Object)username);
    }

    protected String failedAuthorization$str() {
        return "WFLYWS0070: Authorization failed for user: %s";
    }

    @Override
    public final void failedAuthentication(String username) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedAuthentication$str(), (Object)username);
    }

    protected String failedAuthentication$str() {
        return "WFLYWS0071: Failed to authenticate username %s:, incorrect username/password";
    }

    @Override
    public final void failedAuthenticationWithException(Throwable cause, String username, String message) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.failedAuthenticationWithException$str(), (Object)username, (Object)message);
    }

    protected String failedAuthenticationWithException$str() {
        return "WFLYWS0072: Error occured when authenticate username %s. Exception message: %s";
    }

    protected String endpointAlreadyStopped$str() {
        return "WFLYWS0073: The target endpoint %s is undeploying or stopped";
    }

    @Override
    public final IllegalStateException endpointAlreadyStopped(String endpointName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.endpointAlreadyStopped$str(), endpointName));
        WSLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warningLibraryInDeployment(String libraryName, String jar) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warningLibraryInDeployment$str(), (Object)libraryName, (Object)jar);
    }

    protected String warningLibraryInDeployment$str() {
        return "WFLYWS0068: A potentially problematic %s library (%s) detected in ws endpoint deployment; Check if this library can be replaced with container module";
    }
}

