/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics.deployment;

import java.util.List;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.microprofile.metrics.deployment.DeploymentMetricService;

public class DeploymentMetricProcessor
implements DeploymentUnitProcessor {
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private final String prefix;
    private Resource rootResource;
    private ManagementResourceRegistration managementResourceRegistration;

    public DeploymentMetricProcessor(boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
        this.prefix = prefix;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        this.rootResource = (Resource)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        this.managementResourceRegistration = (ManagementResourceRegistration)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        DeploymentMetricService.install(phaseContext.getServiceTarget(), phaseContext.getDeploymentUnit(), this.rootResource, this.managementResourceRegistration, this.exposeAnySubsystem, this.exposedSubsystems, this.prefix);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

