/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class DefaultResponseExceptionMapper
implements ResponseExceptionMapper {
    public Throwable toThrowable(Response response) {
        try {
            response.bufferEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new WebApplicationException("Unknown error, status code " + response.getStatus(), response);
    }

    public boolean handles(int status, MultivaluedMap headers) {
        Config config = ConfigProvider.getConfig();
        boolean originalBehavior = config.getOptionalValue("resteasy.original.webapplicationexception.behavior", Boolean.TYPE).orElse(false);
        boolean serverSide = ResteasyDeployment.onServer();
        return status >= (originalBehavior || !serverSide ? 400 : 300);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

