/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.TopicPartitionInfo;
import java.util.ArrayList;
import java.util.Map;

public class TopicDescriptionConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, TopicDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "internal": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setInternal((Boolean)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "partitions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<TopicPartitionInfo> list = new ArrayList<TopicPartitionInfo>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new TopicPartitionInfo((JsonObject)item));
                        }
                    });
                    obj.setPartitions(list);
                }
            }
        }
    }

    public static void toJson(TopicDescription obj, JsonObject json) {
        TopicDescriptionConverter.toJson(obj, json.getMap());
    }

    public static void toJson(TopicDescription obj, Map<String, Object> json) {
        json.put("internal", obj.isInternal());
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getPartitions() != null) {
            JsonArray array = new JsonArray();
            obj.getPartitions().forEach(item -> array.add((Object)item.toJson()));
            json.put("partitions", array);
        }
    }
}

