/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnCancellationCall;
import io.smallrye.mutiny.operators.multi.MultiOnCancellationInvoke;
import java.util.function.Supplier;

public class MultiOnCancel<T> {
    private final Multi<T> upstream;

    public MultiOnCancel(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(Runnable action) {
        Runnable runnable = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onMultiCreation(new MultiOnCancellationInvoke<T>(this.upstream, runnable));
    }

    public Multi<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(new MultiOnCancellationCall<T>(this.upstream, actual));
    }

    @Deprecated
    public Multi<T> invokeUni(Supplier<Uni<?>> supplier) {
        return this.call(supplier);
    }
}

