/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiFlatten;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiIgnoreOp;
import io.smallrye.mutiny.operators.multi.MultiMapOp;
import io.smallrye.mutiny.operators.multi.MultiOnItemInvoke;
import io.smallrye.mutiny.operators.multi.MultiScanOp;
import io.smallrye.mutiny.operators.multi.MultiScanWithSeedOp;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiOnItem<T> {
    private final Multi<T> upstream;

    public MultiOnItem(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @Deprecated
    public <R> Multi<R> apply(Function<? super T, ? extends R> mapper) {
        return this.transform(mapper);
    }

    public <R> Multi<R> transform(Function<? super T, ? extends R> mapper) {
        Function<? super T, ? extends R> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onMultiCreation(new MultiMapOp<T, R>(this.upstream, actual));
    }

    public Multi<T> invoke(Consumer<? super T> callback) {
        Consumer<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onMultiCreation(new MultiOnItemInvoke<T>(this.upstream, actual));
    }

    public Multi<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super T ignored) -> actual.run());
    }

    public Multi<T> call(Function<? super T, Uni<?>> action) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.transformToUni(i -> {
            Uni uni = (Uni)actual.apply(i);
            if (uni == null) {
                throw new NullPointerException("The `action` produced a `null` Uni");
            }
            return uni.onItemOrFailure().transformToUni((? super T ignored, Throwable failure) -> {
                if (failure != null) {
                    return Uni.createFrom().failure((Throwable)failure);
                }
                return Uni.createFrom().item(i);
            });
        }).concatenate();
    }

    public Multi<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super T ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public Multi<T> invokeUni(Function<? super T, Uni<?>> action) {
        return this.call(action);
    }

    public <O> Multi<O> disjoint() {
        return this.upstream.onItem().transformToMultiAndConcatenate(x -> {
            if (x instanceof Iterable) {
                return Multi.createFrom().iterable((Iterable)x);
            }
            if (x instanceof Multi) {
                return (Multi)x;
            }
            if (x instanceof Publisher) {
                return Multi.createFrom().publisher((Publisher)x);
            }
            if (x.getClass().isArray()) {
                Object[] item = (Object[])x;
                return Multi.createFrom().items(item);
            }
            return Multi.createFrom().failure(new IllegalArgumentException("Invalid parameter - cannot disjoint instance of " + x.getClass().getName()));
        });
    }

    @Deprecated
    public <O> MultiFlatten<T, O> produceMulti(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.transformToMulti(mapper);
    }

    public <O> MultiFlatten<T, O> transformToMulti(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        Function<? super T, ? extends Publisher<? extends O>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return new MultiFlatten(this.upstream, actual, 1, false);
    }

    public <O> Multi<O> transformToMultiAndConcatenate(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.transformToMulti(mapper).concatenate();
    }

    public <O> Multi<O> transformToMultiAndMerge(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.transformToMulti(mapper).merge();
    }

    @Deprecated
    public <O> MultiFlatten<T, O> producePublisher(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.transformToMulti(mapper);
    }

    public <O> Multi<O> transformToIterable(Function<? super T, ? extends Iterable<O>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.transformToMultiAndConcatenate(x -> {
            Iterable iterable = (Iterable)actual.apply(x);
            if (iterable == null) {
                return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
            }
            return Multi.createFrom().iterable(iterable);
        });
    }

    @Deprecated
    public <O> MultiFlatten<T, O> produceIterable(Function<? super T, ? extends Iterable<? extends O>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.transformToMulti(x -> {
            Iterable iterable = (Iterable)actual.apply(x);
            if (iterable == null) {
                return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
            }
            return Multi.createFrom().iterable(iterable);
        });
    }

    public <O> MultiFlatten<T, O> transformToUni(Function<? super T, Uni<? extends O>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        Function<Object, Publisher> wrapper = res -> ((Uni)actual.apply(res)).toMulti();
        return new MultiFlatten(this.upstream, wrapper, 1, false);
    }

    public <O> Multi<O> transformToUniAndConcatenate(Function<? super T, Uni<? extends O>> mapper) {
        return this.transformToUni(mapper).concatenate();
    }

    public <O> Multi<O> transformToUniAndMerge(Function<? super T, Uni<? extends O>> mapper) {
        return this.transformToUni(mapper).merge();
    }

    @Deprecated
    public <O> MultiFlatten<T, O> produceUni(Function<? super T, Uni<? extends O>> mapper) {
        return this.transformToUni(mapper);
    }

    @Deprecated
    public <O> MultiFlatten<T, O> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends O>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        Function<Object, Publisher> wrapper = res -> Multi.createFrom().emitter(emitter -> {
            CompletionStage stage;
            try {
                stage = (CompletionStage)actual.apply(res);
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (stage == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            emitter.onTermination(() -> stage.toCompletableFuture().cancel(false));
            stage.whenComplete((r, f) -> {
                if (f != null) {
                    emitter.fail((Throwable)f);
                } else if (r != null) {
                    emitter.emit(r);
                    emitter.complete();
                } else {
                    emitter.fail(new NullPointerException("The completion stage redeemed `null`"));
                }
            });
        }, BackPressureStrategy.LATEST);
        return new MultiFlatten(this.upstream, wrapper, 1, false);
    }

    public Multi<Void> ignore() {
        return Infrastructure.onMultiCreation(new MultiIgnoreOp<T>(this.upstream));
    }

    public Uni<Void> ignoreAsUni() {
        return this.ignore().toUni();
    }

    public <O> Multi<O> castTo(Class<O> target) {
        ParameterValidation.nonNull(target, "target");
        return this.transform(target::cast);
    }

    public <S> Multi<S> scan(Supplier<S> initialStateProducer, BiFunction<S, ? super T, S> accumulator) {
        Supplier<S> actualSupplier = Infrastructure.decorate(ParameterValidation.nonNull(initialStateProducer, "initialStateProducer"));
        BiFunction<S, ? super T, S> actualAccumulator = Infrastructure.decorate(ParameterValidation.nonNull(accumulator, "accumulator"));
        return Infrastructure.onMultiCreation(new MultiScanWithSeedOp<T, S>(this.upstream, actualSupplier, actualAccumulator));
    }

    public Multi<T> scan(BinaryOperator<T> accumulator) {
        BinaryOperator<T> actual = Infrastructure.decorate(ParameterValidation.nonNull(accumulator, "accumulator"));
        return Infrastructure.onMultiCreation(new MultiScanOp<T>(this.upstream, actual));
    }

    public Multi<T> failWith(Function<? super T, ? extends Throwable> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onMultiCreation(this.transformToUniAndConcatenate(t -> {
            Throwable failure = Objects.requireNonNull((Throwable)actual.apply(t), "The mapper returned `null`");
            return Uni.createFrom().failure(failure);
        }));
    }

    public Multi<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(this.transformToUniAndConcatenate(ignored -> {
            Throwable failure = Objects.requireNonNull((Throwable)actual.get(), "The supplier returned `null`");
            return Uni.createFrom().failure(failure);
        }));
    }
}

