/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.config.SyslogFacilityValue;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseReader;

public final class ConfigFileReaderSupport {
    public static final char COMMENT_CHAR = '#';
    public static final String COMPRESSION_PROP = "Compression";
    public static final String DEFAULT_COMPRESSION = CompressionConfigValue.NO.getName();
    public static final String MAX_SESSIONS_CONFIG_PROP = "MaxSessions";
    public static final int DEFAULT_MAX_SESSIONS = 10;
    public static final String PASSWORD_AUTH_CONFIG_PROP = "PasswordAuthentication";
    public static final String DEFAULT_PASSWORD_AUTH = "no";
    public static final boolean DEFAULT_PASSWORD_AUTH_VALUE = ConfigFileReaderSupport.parseBooleanValue("no");
    public static final String LISTEN_ADDRESS_CONFIG_PROP = "ListenAddress";
    public static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String KEEP_ALIVE_CONFIG_PROP = "TCPKeepAlive";
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final String USE_DNS_CONFIG_PROP = "UseDNS";
    public static final boolean DEFAULT_USE_DNS = true;
    public static final String PUBKEY_AUTH_CONFIG_PROP = "PubkeyAuthentication";
    public static final String DEFAULT_PUBKEY_AUTH = "yes";
    public static final boolean DEFAULT_PUBKEY_AUTH_VALUE = ConfigFileReaderSupport.parseBooleanValue("yes");
    public static final String AUTH_KEYS_FILE_CONFIG_PROP = "AuthorizedKeysFile";
    public static final String MAX_AUTH_TRIES_CONFIG_PROP = "MaxAuthTries";
    public static final int DEFAULT_MAX_AUTH_TRIES = 6;
    public static final String MAX_STARTUPS_CONFIG_PROP = "MaxStartups";
    public static final int DEFAULT_MAX_STARTUPS = 10;
    public static final String LOGIN_GRACE_TIME_CONFIG_PROP = "LoginGraceTime";
    public static final long DEFAULT_LOGIN_GRACE_TIME = TimeUnit.SECONDS.toMillis(120L);
    public static final String KEY_REGENERATE_INTERVAL_CONFIG_PROP = "KeyRegenerationInterval";
    public static final long DEFAULT_REKEY_TIME_LIMIT = TimeUnit.HOURS.toMillis(1L);
    public static final String CIPHERS_CONFIG_PROP = "Ciphers";
    public static final String DEFAULT_CIPHERS = "aes128-ctr,aes192-ctr,aes256-ctr,arcfour256,arcfour128,aes128-cbc,3des-cbc,blowfish-cbc,cast128-cbc,aes192-cbc,aes256-cbc,arcfour";
    public static final String MACS_CONFIG_PROP = "MACs";
    public static final String DEFAULT_MACS = "hmac-md5,hmac-sha1,umac-64@openssh.com,hmac-ripemd160,hmac-sha1-96,hmac-md5-96,hmac-sha2-256,hmac-sha2-256-96,hmac-sha2-512,hmac-sha2-512-96";
    public static final String KEX_ALGORITHMS_CONFIG_PROP = "KexAlgorithms";
    public static final String DEFAULT_KEX_ALGORITHMS = "ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1,diffie-hellman-group18-sha512,diffie-hellman-group17-sha512,diffie-hellman-group16-sha512,diffie-hellman-group15-sha512,diffie-hellman-group14-sha256,diffie-hellman-group14-sha1,diffie-hellman-group1-sha1";
    public static final String HOST_KEY_ALGORITHMS_CONFIG_PROP = "HostKeyAlgorithms";
    public static final String DEFAULT_HOST_KEY_ALGORITHMS = "ssh-rsa,ssh-dss";
    public static final String LOG_LEVEL_CONFIG_PROP = "LogLevel";
    public static final LogLevelValue DEFAULT_LOG_LEVEL = LogLevelValue.INFO;
    public static final String SYSLOG_FACILITY_CONFIG_PROP = "SyslogFacility";
    public static final SyslogFacilityValue DEFAULT_SYSLOG_FACILITY = SyslogFacilityValue.AUTH;
    public static final String SUBSYSTEM_CONFIG_PROP = "Subsystem";

    private ConfigFileReaderSupport() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Properties readConfigFile(Path path, OpenOption ... options) throws IOException {
        try (InputStream input = Files.newInputStream(path, options);){
            Properties properties = ConfigFileReaderSupport.readConfigFile(input, true);
            return properties;
        }
    }

    public static Properties readConfigFile(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            Properties properties = ConfigFileReaderSupport.readConfigFile(input, true);
            return properties;
        }
    }

    public static Properties readConfigFile(InputStream input, boolean okToClose) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(NoCloseInputStream.resolveInputStream(input, okToClose), StandardCharsets.UTF_8);){
            Properties properties = ConfigFileReaderSupport.readConfigFile(reader, true);
            return properties;
        }
    }

    public static Properties readConfigFile(Reader reader, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(reader, okToClose));){
            Properties properties = ConfigFileReaderSupport.readConfigFile(buf);
            return properties;
        }
    }

    public static Properties readConfigFile(BufferedReader rdr) throws IOException {
        Properties props = new Properties();
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            int pos;
            if (!GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) && (pos = line.indexOf(35)) != 0) {
                if (pos > 0) {
                    line = line.substring(0, pos);
                    line = line.trim();
                }
                if ((pos = line.indexOf(32)) < 0) {
                    pos = line.indexOf(61);
                }
                if (pos < 0) {
                    throw new StreamCorruptedException("No delimiter at line " + lineNumber + ": " + line);
                }
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1).trim();
                String prev = props.getProperty(key);
                if (!GenericUtils.isEmpty(prev)) {
                    value = prev + "," + value;
                }
                props.setProperty(key, value);
            }
            line = rdr.readLine();
            ++lineNumber;
        }
        return props;
    }

    public static boolean parseBooleanValue(String v) {
        if (GenericUtils.isEmpty(v)) {
            return false;
        }
        return PropertyResolverUtils.TRUE_VALUES.contains(v);
    }

    public static String yesNoValueOf(boolean flag) {
        return flag ? DEFAULT_PUBKEY_AUTH : DEFAULT_PASSWORD_AUTH;
    }
}

