/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.file;

import io.smallrye.config.common.MapBackedConfigSource;
import io.smallrye.config.source.file.FileSystemLogging;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystemConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = 654034634846856045L;
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

    public FileSystemConfigSource(File dir) {
        this(dir, 100);
    }

    public FileSystemConfigSource(String dir) {
        this(new File(dir), 100);
    }

    public FileSystemConfigSource(File dir, int ordinal) {
        super("FileSystemConfigSource[dir=" + dir.getAbsolutePath() + "]", FileSystemConfigSource.scan(dir), ordinal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> scan(File directory) {
        if (directory == null) return Collections.emptyMap();
        if (!directory.isDirectory()) return Collections.emptyMap();
        try (Stream<Path> stream = Files.walk(directory.toPath(), 1, new FileVisitOption[0]);){
            Map<String, String> map = stream.filter(p -> p.toFile().isFile()).collect(Collectors.toMap(it -> it.getFileName().toString(), FileSystemConfigSource::readContent));
            return map;
        }
        catch (Exception e) {
            FileSystemLogging.log.failedToReadFileContent(directory.getAbsolutePath(), e.getLocalizedMessage());
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readContent(Path file) {
        try (Stream<String> stream = Files.lines(file);){
            String string = stream.collect(Collectors.joining());
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        Map properties = this.getProperties();
        String value = (String)properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = PATTERN.matcher(name).replaceAll("_");
        value = (String)properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return (String)properties.get(sanitizedName.toUpperCase());
    }
}

