package org.ovirt.engine.extensions.aaa.builtin.kerberosldap;

/**
 * The filter generated by the search mechanism contains the $PRINCIPAL_NAME entry to perform search by UPN. The filter
 * takes the part after the equation sign (as the $PRINCIPAL_NAME part of the filter looks like
 * ($PRINCIPAL_NAME=user@domain) and splits to user and domain. It composes back the filter, so the part of
 * $PRINCIPAL_NAME will not look like ($PRINCIPAL_NAME=user) This is relevant for RHDS and OpenLdap
 */
public class UpnSplitterLdapFilterSearchEnginePreProcessor implements LdapFilterSearchEnginePreProcessor {

    @Override
    public String preProcess(String filter) {
        int principalNameIdx = filter.indexOf(SearchLangageLDAPTokens.$PRINCIPAL_NAME.toString());
        if (principalNameIdx != -1) {
            int equalsIdx = filter.indexOf('=', principalNameIdx);
            int closingParen = filter.indexOf(')', equalsIdx);
            String user = filter.substring(equalsIdx + 1, closingParen);
            if (user.indexOf('@') != -1) { // Indeed a principal name format
                String[] parts = user.split("@");
                user = parts[0];
            }
            filter = filter.substring(0, equalsIdx + 1) + user + filter.substring(closingParen);

        }
        return filter;
    }

}
