-- the ID of the unknown OS is 0

UPDATE vm_icons SET data_url = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACsAAAArCAYAAADhXXHAAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH4gcNDBco7j7B7AAABKdJREFUWMPtmM1PVFcYh5/3zp1RYEBmcAZEVGTQqiiKmlCcRRWbLoxddNUmXTTpn+DCpEmbsG2atH9Fu6hNlSZaEhsXVqNt4wdaUGEYBQYkzFfng5mB+3G6AI1aBhntaDTzbu7NOe8597lvfvd3zj1QiUogpST39fVpwWDwo2g0dmxqZqYRxS2FDGpKu53NJkb6+vrM1w577ty5NU6n82PgC2BHNBa7MjU90/NMmgFqFJFrKBlC7GFlmn+dPHly5pXBDgwM7HU4HOcB36O2IrDFIgkMg7omSoZAG9Y069qJEyfypcLqz0twOBxNT4K+QHiAIEhQCYCNpcT45tvv7ijFbRS3NGRQ0+yLz3sB/TV9K04UnQKdCJ8qFAZ0A3+uNEh7k9xg1bA1NTX4/f7iE2kagUAb69bVlQ121TLQdR3DMNC05d9vd8cuxicmaWxsRNMcuFxOTMNEc2hEo7FXW1mXy4XL5cK27eVtRTRSqRQjI6O0btlMx65dVFdX0x4I0Na2FV3X2b59G2vXrsHhcJS3skopLMsq+qBsNoPf58O2bdLpDIZhkC8UGJ+YwOvx8M72bSil2N/VhW3bTE1PMzkZKU9l5+fnsW0by7KW7R8L30fXdWrcNYyFw2Tn5nA4HBTyBQzDJBaPIyLcGxlhbm6uZNCSKltVVUUmk1kxZ/rhw8f3Dx6MP75PJJMAxGJxNBHy+UJ5ZSAi6PrL2bJlWViAYZrlhS0UCjidzhVz2ra2cqinB1stymVkZJQbNwcBqK6q4uDBA7jdbuLxOEPDd8hms+WBTaVSiMiKPny0t5cfT/1EKp1GRHj/aC97dndw++8hjhx+j9FQiInJCOsbGtBEymddfr8fv99f1A02b9rE3Xv3SKXTj93j4u+X6OratygjTcMwTAqFApGpKdLP0f8Lwz6p12LVraurJZVK/cdBXE4XwBL4Xj48fozm5g3lXRSSySSWZRVdFAzDWFbTSikA0uk0P5/u5/LlK/R0d7Nz547ywCqlcLvdZLPZojKYjUbZ1NLyVFtz8wZmo7NPtSWSSW4ODuL3+crnBtFodMX+SGSKnu5uDvW8y9hYGI/Hw/6ufZz9dQCA3iOHMU0TXdfxeOo5/9uF8sGuJs70/8Kezj10du4mGo1x+kw/+cLiAnD16h/U1tWSy+XIZLLl9dnVhGGaXL9+Y9m+XD5PLp9/qfnfzs13BbYCW4GtwFZg337Y13XWlVcQAsYEQk6na/xAV+c/Lw1bXV19Y2Fh4WvTND8DmkoAmlcwpaGGFTJU53ZPb21vW9jS0qL7fL5apVRARAJKqU+AjYCKx+OXROR7TdNO1dfXJ0uGDQaDs4lE4qxpmplIJDKZSCSOi0jzoz05EBYIKwh76z3R1kDrwuaNG3Wv11unlGpfAvpcRHzPbsiVUjYwCVxgsdIh27ZnTdNcvzT3038sJfwptNq2/QOQy+Vy/TZotTU1jUsValdKBYB1ywx9BDSqlAqJSGjpOur1esdEZH7VxwGlCE0ppScSiS+Br5b5OJdOuBkSkbBSKmzbdtiyrLtNTU1z/4fQ5UUGxePxD4AOEQnZtj3a0NAQFpEFKvGGxr+2AgqbGgdGVwAAAABJRU5ErkJggg=='
WHERE id = (SELECT small_icon_id FROM vm_icon_defaults WHERE os_id = 0);

UPDATE vm_icons SET data_url = 'data:image/png;base64,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'
WHERE id = (SELECT large_icon_id FROM vm_icon_defaults WHERE os_id = 0);
