# Up to two digits, to fit in the iso label
%global rel 3

%global spice_nsis_version 0.171
%global source_base spice-nsis-%{spice_nsis_version}

Name:		ovirt-guest-tools-iso
Version:	4.3
Release:	%{rel}%{?release_suffix}%{?dist}
Summary:	oVirt Windows Guest Tools
License:	GPLv2 and GPLv2+ and ASL 2.0 and Zlib and MIT and Python and Platform SDK Redistributable EULA and Microsoft DDK Redistributable EULA
Source0:	https://resources.ovirt.org/pub/ovirt-master-snapshot/src/ovirt-wgt/%{source_base}.tar.bz2
URL:		https://www.ovirt.org/develop/release-management/features/integration/windows-guest-tools/
BuildArch:	noarch


BuildRequires:	genisoimage
BuildRequires:	rsync
BuildRequires:	mingw32-nsis >= 3.01

# Drop these when virtio-win includes the drivers not inside an iso.
# See comment in Makefile.
BuildRequires:	p7zip
BuildRequires:	p7zip-plugins
BuildRequires:	hardlink

# From http://www.spice-space.org/download/windows/vdagent/vdagent-win-0.9.0/
BuildRequires:	mingw32-spice-vdagent >= 0.9.0
BuildRequires:	mingw64-spice-vdagent >= 0.9.0

# From http://resources.ovirt.org/pub
BuildRequires:	ovirt-guest-agent-windows
BuildRequires:	vcredist-x86
BuildRequires:	nsis-simple-service-plugin >= 1.30-2

# From https://docs.fedoraproject.org/en-US/quick-docs/creating-windows-virtual-machines-using-virtio-drivers/index.html#installing-virtio-win-repo
BuildRequires:	virtio-win >= 0.1.171

Obsoletes:	ovirt-guest-tools

%description
Windows Guest tools ISO for oVirt Virtualization Manager.

%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	MODE=OVIRT \\\
	DISPLAYED_VERSION='%{version}-%{release}' \\\
	ISO_LABEL='oVirt-WGT-%{version}-%{rel}'

%prep
%setup -n %{source_base} -q

%build
make %{make_common_opts}

%install
make %{make_common_opts} install DESTDIR="%{buildroot}"

%files
%{_datadir}/%{name}

%changelog
* Wed Mar 06 2019 - Sandro Bonazzola <sbonazzo@redhat.com> - 4.3-3
- Rebase on virtio-win 0.171

* Tue Mar 05 2019 - Gal Zaidman <gzaidman@redhat.com> - 4.3-2
- Update to ovirt-guest-agent-1.0.16

* Fri Jan 18 2019 - Sandro Bonazzola <sbonazzo@redhat.com> - 4.3-1
- Added smbus driver (BZ#1578782)
- Added qemufwcfg driver (BZ#1578775)

* Fri Nov 23 2018 - Yedidyah Bar David <didi@redhat.com> - 4.3-0
- Bumping version to 4.3

* Tue Oct 09 2018 - Sandro Bonazzola <sbonazzo@redhat.com> - 4.2-4
- Update to virtio-win 0.1.160
- add linux qemu-guest-agent packages

* Thu Aug 09 2018 - Sandro Bonazzola <sbonazzo@redhat.com> - 4.2-3
- Update to virtio-win 0.141
- Do not install .pdb debug files on the target system
- Properly quote path to service binaries (BZ#1609779)

* Wed Dec 06 2017 - Yedidyah Bar David <didi@redhat.com> - 4.2-1
- packaging: Handle release suffix
- automation: export also tarball
- packaging: make dist: Fix symlinks
- automation: add standard ci support
- Add support to the installer for Microsoft Windows Server 2016
- Add support for Microsoft Windows Server 2016
- Re-introduce WinVer.nsh
- Fix driver path for win2k*
- packaging: bump version to 4.2
- Merge branch 'virtio-rng' into 'master'
- Install virtio-rng driver
- Update to latest virtio-win/vdagent releases
- Add Windows 10 support
- Add Display Version as a postfix to the Display Name.
- Correct path to QEMU GA MSI files
- ovirt: Add service removal
- ovirt: Add missing removal of hooks base directory
- ovirt: Remove all files install by the ovirt-guest-agent
- OVirtGuestService.exe is a File not a Directory to remove

* Tue Jan 24 2017 Yedidyah Bar David <didi@redhat.com> - 4.2-0
- Bumping version to 4.2

* Tue Jun 21 2016 Yedidyah Bar David <didi@redhat.com> - 4.1-0
- Bumping version to 4.1

* Wed Feb 10 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0-0
- Bumping version to 4.0

* Wed Nov 11 2015 Yedidyah Bar David <didi@redhat.com> 3.6-3
- merged into upstream git repo spice-nsis
- separated Makefile out of the spec file

* Tue Oct 20 2015 Yedidyah Bar David <didi@redhat.com> 3.6-2
- Updated oVirt Guest Agent (1.0.11)
- dropped "artifacts" from all paths

* Mon Nov 24 2014 Lev Veyde <lveyde@redhat.com> 3.5-7
- Updated oVirt Guest Agent (1.0.10.3)

* Wed Oct 22 2014 Lev Veyde <lveyde@redhat.com> 3.5-6
- Volume label was changed to include oVirt prefix
- ISO metada was added

* Wed Oct 08 2014 Lev Veyde <lveyde@redhat.com> 3.5-5
- Initial RPM based version of oVirt Guest Tools
- Includes latest oVirt Guest Agent 1.0.10.2
- Includes Spice Agent 0.7.2
- Includes Spice QXL 0.1-21
- Includes VirtIO-Win 0.1-81
