#
# ovirt-hosted-engine-ha -- ovirt hosted engine high availability
# Copyright (C) 2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

"""Constants."""

PACKAGE_NAME = 'ovirt-hosted-engine-ha'
PROGRAM_NAME = 'broker'
PACKAGE_VERSION = '2.3.0'
FULL_PROG_NAME = '{0} {1} {2}'.format(
                 PACKAGE_NAME, PROGRAM_NAME, PACKAGE_VERSION)

# See http://www.gnu.org/software/automake/manual/html_node/Scripts.html
LOG_CONF_FILE = '/etc/ovirt-hosted-engine-ha/broker-log.conf'
LOG_FILE = '/var/log/ovirt-hosted-engine-ha/broker.log'

NOTIFY_CONF_FILE = '/var/lib/ovirt-hosted-engine-ha/broker.conf'
NOTIFY_CONF_FILE_ARCHIVE_FNAME = 'broker.conf'
NOTIFY_TEMPLATES = '/etc/ovirt-hosted-engine-ha/notifications'

HOSTED_ENGINE_BINARY = '/usr/sbin/hosted-engine'

MAX_DOMAIN_MONITOR_WAIT_SECS = 240
STORAGE_DELAY = 10

MD_IMAGE = 'hosted-engine.metadata'
LOCKSPACE_NAME = 'hosted-engine'
LOCKSPACE_IMAGE = 'hosted-engine.lockspace'
WAIT_FOR_STORAGE_RETRY = 5
WAIT_FOR_STORAGE_DELAY = 5
