%global python_version 2

%if 0%{?rhel} == 7 && %{python_version} == 2
%global python python
%else
%global python python%{python_version}
%endif

Name:      ovirt-imageio-common
Version:   1.6.3
Release:   0%{?release_suffix}%{?dist}
Summary:   oVirt imageio common library

Group:     Development/Libraries
License:   GPLv2+
Url:       https://gerrit.ovirt.org/ovirt-imageio
Source0:   http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz

# NOTE: keep in sync with automation/check.packages
Requires:  %{python}
Requires:  %{python}-six

%if %{python_version} == 2
Requires:  %{python}-subprocess32
%endif

%if 0%{?rhel} == 7
# qemu-img is old and crippled on rhel 7.
Requires: qemu-img-rhev
%else
Requires: qemu-img
%endif

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: %{python}-devel

%description
Common library for use in oVirt image transfer daemon and proxy.

%prep
%setup -q

%build
%{python} setup.py build

%install
%{python} setup.py install -O1 --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%license COPYING
