%global    logdir /var/log/ovirt-imageio-daemon

Name:      ovirt-imageio-daemon
Version:   0.5.0
Release:   0%{?release_suffix}%{?dist}
Summary:   oVirt imageio daemon

Group:     Applications/System
License:   GNU GPLv2+
Url:       https://gerrit.ovirt.org/ovirt-imageio
Source0:   http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz
BuildArch: noarch

# NOTE: keep in sync with automation/check.packages
Requires:  ovirt-imageio-common
Requires:  python
Requires:  python-six
Requires:  systemd-python

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: python-devel
BuildRequires: systemd

%description
Daemon to manage image data transfer on oVirt virtualization hosts.

%prep
%setup -q

%build
python setup.py build

%install
python setup.py install -O1 --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES
install -D -m 0755 --directory %{buildroot}%{logdir}
# Create a dummy log file to make rpm happy during build
touch %{buildroot}%{logdir}/daemon.log
install -D -m 0755 --directory %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/logger.conf %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/ovirt-imageio-daemon.service %{buildroot}%{_unitdir}/ovirt-imageio-daemon.service

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%license COPYING
%doc README
%{_unitdir}/ovirt-imageio-daemon.service
%dir %{_sysconfdir}/%{name}
%config %{_sysconfdir}/%{name}/logger.conf
# The log directory should belong to the daemon so it can create log files.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-ATTR-DIRECTIVE
%dir %attr(755, vdsm, kvm) %{logdir}
# The log files belongs to the package, so they will be removed with the package.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-GHOST-DIRECTIVE
%ghost %{logdir}/daemon.log*

# For more information about the systemd macros, see:
# https://fedoraproject.org/wiki/Packaging:Scriptlets#New_Packages

%post
# After installation, synchronize service state with preset files.
%systemd_post ovirt-imageio-daemon.service

%preun
# Before uninstalling, stop and disable the service.
%systemd_preun ovirt-imageio-daemon.service

%postun
# After upgrading, restart the service.
%systemd_postun_with_restart ovirt-imageio-daemon.service
