Name:      ovirt-imageio
Version:   2.0.7
Release:   0%{?dist}
Summary:   oVirt imageio

License:   GPLv2+
Url:       https://gerrit.ovirt.org/%{name}
Source0:   http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz

%global user ovirtimg
%global group ovirtimg
%global srcname ovirt_imageio
%global logdir %{_localstatedir}/log/%{name}

%description
Image data transfer on oVirt virtualization hosts.

%prep
%setup -q

%build
%py3_build

%install
%py3_install
install -D -m 0755 --directory %{buildroot}%{logdir}
# Create a dummy log file to make rpm happy during build
touch %{buildroot}%{logdir}/daemon.log
install -D -m 0755 --directory %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/daemon.conf.sample %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/%{name}.service %{buildroot}%{_unitdir}/%{name}.service

%clean
rm -rf $RPM_BUILD_ROOT


%package common
Summary:   oVirt imageio common resources

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: gcc
BuildRequires: python3-devel

# NOTE: keep in sync with automation/check.packages
Requires:  python3
Requires:  python3-six

%description common
Common resources used by oVirt imageio server and client

%files common
%license COPYING
%{python3_sitearch}/%{srcname}
%{python3_sitearch}/%{srcname}-*.egg-info
%exclude %{python3_sitearch}/%{srcname}/client


%package client
Summary:   oVirt imageio client library

# NOTE: keep in sync with automation/check.packages
Requires:  %{name}-common = %{version}-%{release}
Requires:  qemu-img

%description client
Python client library for accessing imageio server on oVirt hosts.

%files client
%{python3_sitearch}/%{srcname}/client


%package daemon
Summary:   oVirt imageio daemon

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: systemd

# NOTE: keep in sync with automation/check.packages
Requires:  %{name}-common = %{version}-%{release}
Requires:  python3-systemd

%description daemon
Daemon providing image transfer service on oVirt hosts.

%files daemon
%{_bindir}/%{name}
%{_unitdir}/%{name}.service
%dir %{_sysconfdir}/%{name}
%{_sysconfdir}/%{name}/daemon.conf.sample
# The log directory should belong to the daemon so it can create log files.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-ATTR-DIRECTIVE
%dir %attr(755, %{user}, %{group}) %{logdir}
# The log files belongs to the package, so they will be removed with the package.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-GHOST-DIRECTIVE
%ghost %attr(644, %{user}, %{group}) %{logdir}/daemon.log*

# For more information about the systemd macros, see:
# https://fedoraproject.org/wiki/Packaging:Scriptlets#New_Packages
# For info on ordering of the scriplets, see:
# https://docs.fedoraproject.org/en-US/packaging-guidelines/Scriptlets/#ordering

%pre daemon
# Create a user and group if needed
if ! /usr/bin/getent passwd %{user} >/dev/null; then
    /usr/sbin/useradd --system \
        --user-group \
        --shell /sbin/nologin \
        --home-dir /run/%{name} \
        --comment "oVirt imageio" \
        %{user}
fi

%post daemon
# After installation, synchronize service state with preset files.
%systemd_post %{name}.service

%preun daemon
# Before uninstalling, stop and disable the service.
%systemd_preun %{name}.service

%postun daemon
# After upgrading, restart the service.
%systemd_postun_with_restart %{name}.service

%posttrans daemon
# At the end of the transaction, stop stale ovirt-imageio-daemon service.
# Needed only when upgrading from ovirt-imageio-daemon < 2.
if systemctl is-active ovirt-imageio-daemon.service >/dev/null; then
    echo "Stopping ovirt-imageio-daemon.service";
    systemctl stop ovirt-imageio-daemon.service
fi

%changelog

* Thu Jun 4 2020 Nir Soffer <nsoffer@redhat.com> 2.0.7-0
- Support showing parsed configuration #BZ1835719
- Improve performance when using small requests #BZ1836858
- Use proxy_url if transfer_url is not accessible #BZ1839400

* Wed May 13 2020 Nir Soffer <nsoffer@redhat.com> 2.0.6-0
- Introduce ovirt-imageio-client package
- Support drop-in confiugration #BZ1826679, #BZ1738729, #BZ1761960
- Make private modules private #BZ1818170
- Log detailed transfer stats #BZ1740489
- Support platform trusted CA

* Mon Apr 20 2020 Nir Soffer <nsoffer@redhat.com> 2.0.5-0
- Support closing connections for web clients

* Fri Apr 17 2020 Nir Soffer <nsoffer@redhat.com> 2.0.4-0
- Support starting as root
