/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNCharsetInputStream;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNTranslator {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static CodingErrorAction onMalformedInputAction = CodingErrorAction.REPORT;
    private static CodingErrorAction onUnmappableCharacterAction = CodingErrorAction.REPORT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String translateString(String str, byte[] eol, Map<String, byte[]> keywords, boolean repair, boolean expand) throws SVNException {
        ByteArrayOutputStream bufferOS = new ByteArrayOutputStream();
        OutputStream resultOS = null;
        try {
            try {
                resultOS = SVNTranslator.getTranslatingOutputStream(bufferOS, null, eol, repair, keywords, expand);
                resultOS.write(str.getBytes());
            }
            catch (IOException e) {
                SVNTranslator.translationError(null, e);
                Object var9_8 = null;
                SVNFileUtil.closeFile(resultOS);
                return new String(bufferOS.toByteArray());
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            SVNFileUtil.closeFile(resultOS);
            throw throwable;
        }
        SVNFileUtil.closeFile(resultOS);
        return new String(bufferOS.toByteArray());
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, srcPath, dstPath, false, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), customEOLStyle, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, customEOLStyle, false, expand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean safelyEncode, boolean expand) throws SVNException {
        block6: {
            ISVNOptions options = adminArea.getWCAccess().getOptions();
            SVNVersionedProperties props = adminArea.getProperties(name);
            String keywords = props.getStringPropertyValue("svn:keywords");
            String mimeType = props.getStringPropertyValue("svn:mime-type");
            String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, adminArea.getFile(name).getPath(), options);
            String eolStyle = null;
            eolStyle = customEOLStyle != null ? customEOLStyle : props.getStringPropertyValue("svn:eol-style");
            boolean special = props.getPropertyValue("svn:special") != null;
            Map<String, byte[]> keywordsMap = null;
            if (keywords != null) {
                if (expand) {
                    SVNEntry entry = adminArea.getVersionedEntry(name, true);
                    String url = entry.getURL();
                    String author = entry.getAuthor();
                    String date = entry.getCommittedDate();
                    String rev = Long.toString(entry.getCommittedRevision());
                    keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
                } else {
                    keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
                }
            }
            byte[] eols = !expand ? SVNTranslator.getBaseEOL(eolStyle) : SVNTranslator.getEOL(eolStyle, options);
            if (expand && charset != null && safelyEncode) {
                File tmp = SVNAdminUtil.createTmpFile(adminArea, name, ".tmp", true);
                try {
                    SVNTranslator.translate(src, tmp, charset, eols, keywordsMap, special, false);
                    SVNTranslator.translate(tmp, dst, charset, eols, keywordsMap, special, true);
                    Object var22_21 = null;
                }
                catch (Throwable throwable) {
                    Object var22_22 = null;
                    SVNFileUtil.deleteFile(tmp);
                    throw throwable;
                }
                SVNFileUtil.deleteFile(tmp);
                {
                    break block6;
                }
            }
            SVNTranslator.translate(src, dst, charset, eols, keywordsMap, special, expand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void translate(File src, File dst, String charset, byte[] eol, Map<String, byte[]> keywords, boolean special, boolean expand) throws SVNException {
        if (src == null || dst == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS), SVNLogType.DEFAULT);
            return;
        }
        if (src.equals(dst)) {
            return;
        }
        if (special) {
            if (SVNFileType.getType(dst) != SVNFileType.NONE) {
                dst.delete();
            }
            if (!SVNFileUtil.symlinksSupported()) {
                SVNFileUtil.copyFile(src, dst, true);
                return;
            }
            if (expand) {
                SVNFileUtil.createSymlink(dst, src);
                return;
            }
            SVNFileUtil.detranslateSymlink(src, dst);
            return;
        }
        if ((charset == null || SVNProperty.isUTF8(charset)) && eol == null && (keywords == null || keywords.isEmpty())) {
            SVNFileUtil.copyFile(src, dst, false, false);
            return;
        }
        OutputStream os = SVNFileUtil.openFileForWriting(dst);
        OutputStream tos = SVNTranslator.getTranslatingOutputStream(os, charset, eol, true, keywords, expand);
        InputStream is = SVNFileUtil.openFileForReading(src, SVNLogType.WC);
        try {
            try {
                SVNTranslator.copy(is, tos);
            }
            catch (IOException e) {
                SVNTranslator.translationError(dst, e);
                Object var12_11 = null;
                SVNFileUtil.closeFile(tos);
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            SVNFileUtil.closeFile(tos);
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            throw throwable;
        }
        SVNFileUtil.closeFile(tos);
        SVNFileUtil.closeFile(os);
        SVNFileUtil.closeFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream getTranslatedStream(SVNAdminArea adminArea, String name, boolean translateToNormalForm, boolean repairEOL) throws SVNException {
        ISVNOptions options = adminArea.getWCAccess().getOptions();
        SVNVersionedProperties props = adminArea.getProperties(name);
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, adminArea.getFile(name).getPath(), options);
        String eolStyle = props.getStringPropertyValue("svn:eol-style");
        String keywords = props.getStringPropertyValue("svn:keywords");
        boolean special = props.getPropertyValue("svn:special") != null;
        File src = adminArea.getFile(name);
        if (special) {
            String linkPath;
            if (!SVNFileUtil.symlinksSupported()) {
                return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
            }
            if (SVNFileType.getType(src) != SVNFileType.SYMLINK) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if ((linkPath = SVNFileUtil.getSymlinkName(src)) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                try {
                    os.write("link ".getBytes("UTF-8"));
                    os.write(linkPath.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                    Object var17_17 = null;
                    SVNFileUtil.closeFile(os);
                    return new ByteArrayInputStream(os.toByteArray());
                }
                Object var17_16 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        boolean translationRequired = special || keywords != null || eolStyle != null || charset != null;
        if (!translationRequired) return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
        byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
        if (!translateToNormalForm) {
            SVNEntry entry = adminArea.getVersionedEntry(name, false);
            String url = entry.getURL();
            String author = entry.getAuthor();
            String date = entry.getCommittedDate();
            String rev = Long.toString(entry.getCommittedRevision());
            Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
            return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, true, keywordsMap, true);
        }
        if (eolStyle != null && eol == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
        boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || repairEOL;
        return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, repair, keywordsMap, false);
    }

    public static File getTranslatedFile(SVNAdminArea dir, String name, File src, boolean forceEOLRepair, boolean useGlobalTmp, boolean forceCopy, boolean toNormalFormat) throws SVNException {
        ISVNOptions options = dir.getWCAccess().getOptions();
        SVNVersionedProperties props = dir.getProperties(name);
        String mimeType = props.getStringPropertyValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), mimeType, dir.getFile(name).getPath(), options);
        String eolStyle = props.getStringPropertyValue("svn:eol-style");
        String keywords = props.getStringPropertyValue("svn:keywords");
        boolean special = props.getPropertyValue("svn:special") != null;
        boolean needsTranslation = charset != null || eolStyle != null || keywords != null || special;
        File result = null;
        if (!needsTranslation && !forceCopy) {
            result = src;
        } else {
            result = useGlobalTmp ? SVNFileUtil.createTempFile("svndiff", ".tmp") : SVNAdminUtil.createTmpFile(dir, name, ".tmp", true);
            if (toNormalFormat) {
                SVNTranslator.translateToNormalForm(src, result, charset, eolStyle, forceEOLRepair, keywords, special);
            } else {
                SVNEntry entry = dir.getVersionedEntry(name, false);
                String url = entry.getURL();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
                SVNTranslator.copyAndTranslate(src, result, charset, SVNTranslator.getEOL(eolStyle, options), keywordsMap, special, true, true);
            }
        }
        return result;
    }

    public static File maybeUpdateTargetEOLs(SVNAdminArea dir, File target, SVNProperties propDiff) throws SVNException {
        String eolStyle = null;
        if (propDiff != null && propDiff.containsName("svn:eol-style") && propDiff.getStringValue("svn:eol-style") != null) {
            eolStyle = propDiff.getStringValue("svn:eol-style");
            ISVNOptions options = dir.getWCAccess().getOptions();
            byte[] eol = SVNTranslator.getEOL(eolStyle, options);
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.copyAndTranslate(target, tmpFile, null, eol, null, false, false, true);
            return tmpFile;
        }
        return target;
    }

    public static File detranslateWorkingCopy(SVNAdminArea dir, String name, SVNProperties propDiff, boolean force) throws SVNException {
        boolean isRemoteBinary;
        SVNVersionedProperties props = dir.getProperties(name);
        boolean isLocalBinary = SVNProperty.isBinaryMimeType(props.getStringPropertyValue("svn:mime-type"));
        String mimeType = null;
        String charsetProp = null;
        String eolStyle = null;
        String keywords = null;
        boolean isSpecial = false;
        boolean isRemoteHasBinary = propDiff != null && propDiff.containsName("svn:mime-type");
        boolean isRemoteBinaryRemoved = isRemoteHasBinary && !SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        boolean bl = isRemoteBinary = isRemoteHasBinary && SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        if (!isLocalBinary && isRemoteBinary) {
            isSpecial = props.getPropertyValue("svn:special") != null;
            keywords = props.getStringPropertyValue("svn:keywords");
            charsetProp = props.getStringPropertyValue("svnkit:charset");
            mimeType = props.getStringPropertyValue("svn:mime-type");
        } else if (!isLocalBinary || isRemoteBinaryRemoved) {
            boolean bl2 = isSpecial = props.getPropertyValue("svn:special") != null;
            if (!isSpecial) {
                if (propDiff != null && propDiff.getStringValue("svn:eol-style") != null) {
                    eolStyle = propDiff.getStringValue("svn:eol-style");
                } else if (!isLocalBinary) {
                    eolStyle = props.getStringPropertyValue("svn:eol-style");
                }
                if (propDiff != null && propDiff.getStringValue("svnkit:charset") != null) {
                    charsetProp = propDiff.getStringValue("svnkit:charset");
                    mimeType = propDiff.getStringValue("svn:mime-type");
                } else if (!isLocalBinary) {
                    charsetProp = props.getStringPropertyValue("svnkit:charset");
                    mimeType = props.getStringPropertyValue("svn:mime-type");
                }
                if (!isLocalBinary) {
                    keywords = props.getStringPropertyValue("svn:keywords");
                }
            }
        }
        File detranslatedFile = null;
        ISVNOptions options = dir.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, dir.getFile(name).getPath(), options);
        if (force || charset != null || keywords != null || eolStyle != null || isSpecial) {
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.translateToNormalForm(dir.getFile(name), tmpFile, charset, eolStyle, true, keywords, isSpecial);
            detranslatedFile = tmpFile;
        } else {
            detranslatedFile = dir.getFile(name);
        }
        return detranslatedFile;
    }

    private static void translateToNormalForm(File source, File destination, String charset, String eolStyle, boolean alwaysRepairEOLs, String keywords, boolean isSpecial) throws SVNException {
        byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
        if (eolStyle != null && eol == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
        boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || alwaysRepairEOLs;
        SVNTranslator.copyAndTranslate(source, destination, charset, eol, keywordsMap, isSpecial, false, repair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyAndTranslate(File source, File destination, String charset, byte[] eol, Map<String, byte[]> keywords, boolean special, boolean expand, boolean repair) throws SVNException {
        block36: {
            boolean isSpecialPath = false;
            if (SVNFileUtil.symlinksSupported()) {
                SVNFileType type = SVNFileType.getType(source);
                boolean bl = isSpecialPath = type == SVNFileType.SYMLINK;
            }
            if (special || isSpecialPath) {
                if (destination.exists()) {
                    destination.delete();
                }
                if (!SVNFileUtil.symlinksSupported()) {
                    SVNFileUtil.copyFile(source, destination, true);
                } else if (expand) {
                    if (isSpecialPath) {
                        SVNFileUtil.createSymlink(destination, SVNFileUtil.getSymlinkName(source));
                    } else {
                        SVNFileUtil.createSymlink(destination, source);
                    }
                } else {
                    SVNFileUtil.detranslateSymlink(source, destination);
                }
                return;
            }
            if ((charset == null || SVNProperty.isUTF8(charset)) && eol == null && (keywords == null || keywords.isEmpty())) {
                SVNFileUtil.copyFile(source, destination, false);
                return;
            }
            OutputStream dst = null;
            InputStream src = null;
            OutputStream translatingStream = null;
            dst = SVNFileUtil.openFileForWriting(destination);
            src = SVNFileUtil.openFileForReading(source, SVNLogType.WC);
            translatingStream = SVNTranslator.getTranslatingOutputStream(dst, charset, eol, repair, keywords, expand);
            SVNTranslator.copy(src, translatingStream);
            Object var15_12 = null;
            try {
                IOException ioe222;
                if (dst != null) {
                    try {
                        dst.flush();
                    }
                    catch (IOException ioe222) {
                        SVNTranslator.checkWrappedException(ioe222, source);
                    }
                }
                if (translatingStream != null) {
                    try {
                        translatingStream.flush();
                    }
                    catch (IOException ioe222) {
                        SVNTranslator.checkWrappedException(ioe222, source);
                    }
                }
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                SVNFileUtil.closeFile(src);
                SVNFileUtil.closeFile(translatingStream);
                SVNFileUtil.closeFile(dst);
                throw throwable;
            }
            SVNFileUtil.closeFile(src);
            SVNFileUtil.closeFile(translatingStream);
            SVNFileUtil.closeFile(dst);
            {
                break block36;
            }
            {
                catch (IOExceptionWrapper ew) {
                    if (ew.getOriginalException().getErrorMessage().getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL, "File ''{0}'' has inconsistent newlines", (Object)source);
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    throw ew.getOriginalException();
                }
                catch (IOException e) {
                    SVNTranslator.translationError(destination, e);
                    Object var15_13 = null;
                    try {
                        IOException ioe222;
                        if (dst != null) {
                            try {
                                dst.flush();
                            }
                            catch (IOException ioe222) {
                                SVNTranslator.checkWrappedException(ioe222, source);
                            }
                        }
                        if (translatingStream != null) {
                            try {
                                translatingStream.flush();
                            }
                            catch (IOException ioe222) {
                                SVNTranslator.checkWrappedException(ioe222, source);
                            }
                        }
                        Object var18_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_21 = null;
                        SVNFileUtil.closeFile(src);
                        SVNFileUtil.closeFile(translatingStream);
                        SVNFileUtil.closeFile(dst);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(src);
                    SVNFileUtil.closeFile(translatingStream);
                    SVNFileUtil.closeFile(dst);
                    {
                        break block36;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                try {
                    IOException ioe222;
                    if (dst != null) {
                        try {
                            dst.flush();
                        }
                        catch (IOException ioe222) {
                            SVNTranslator.checkWrappedException(ioe222, source);
                        }
                    }
                    if (translatingStream != null) {
                        try {
                            translatingStream.flush();
                        }
                        catch (IOException ioe222) {
                            SVNTranslator.checkWrappedException(ioe222, source);
                        }
                    }
                    Object var18_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_23 = null;
                    SVNFileUtil.closeFile(src);
                    SVNFileUtil.closeFile(translatingStream);
                    SVNFileUtil.closeFile(dst);
                    throw throwable2;
                }
                SVNFileUtil.closeFile(src);
                SVNFileUtil.closeFile(translatingStream);
                SVNFileUtil.closeFile(dst);
                throw throwable;
            }
        }
    }

    private static void checkWrappedException(IOException ioe, File file) throws SVNException {
        if (ioe instanceof IOExceptionWrapper) {
            IOExceptionWrapper ew = (IOExceptionWrapper)ioe;
            if (ew.getOriginalException().getErrorMessage().getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL, "File ''{0}'' has inconsistent newlines", (Object)file);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            throw ew.getOriginalException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkNewLines(File file) {
        InputStream is;
        block15: {
            boolean bl;
            block14: {
                if (file == null) return true;
                if (!file.exists()) return true;
                if (file.isDirectory()) {
                    return true;
                }
                is = null;
                try {
                    try {
                        int r;
                        is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                        byte[] lastFoundEOL = null;
                        byte[] currentEOL = null;
                        while ((r = is.read()) >= 0) {
                            if (r == 10) {
                                currentEOL = SVNProperty.EOL_LF_BYTES;
                            } else if (r == 13) {
                                currentEOL = SVNProperty.EOL_CR_BYTES;
                                r = is.read();
                                if (r == 10) {
                                    currentEOL = SVNProperty.EOL_CRLF_BYTES;
                                }
                            }
                            if (lastFoundEOL == null) {
                                lastFoundEOL = currentEOL;
                                continue;
                            }
                            if (currentEOL == null || lastFoundEOL == currentEOL) continue;
                            bl = false;
                            Object var7_10 = null;
                            break block14;
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        boolean bl2 = false;
                        Object var7_12 = null;
                        SVNFileUtil.closeFile(is);
                        return bl2;
                    }
                    catch (SVNException e) {
                        boolean bl3 = false;
                        Object var7_13 = null;
                        SVNFileUtil.closeFile(is);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    SVNFileUtil.closeFile(is);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(is);
            return bl;
        }
        Object var7_11 = null;
        SVNFileUtil.closeFile(is);
        return true;
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        byte[] buffer = new byte[8192];
        int read;
        while ((read = src.read(buffer)) >= 0) {
            if (read == 0) continue;
            dst.write(buffer, 0, read);
        }
        return;
    }

    public static OutputStream getTranslatingOutputStream(OutputStream out, String charset, byte[] eol, boolean repair, Map<String, byte[]> keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        Charset cs = Charset.forName(charset);
        byte[] lf = SVNProperty.EOL_LF_BYTES;
        if (expand) {
            if (eol != null) {
                boolean encodingConvertsEOL;
                byte[] convertedEOL = SVNTranslator.convertEOL(lf, UTF8_CHARSET, cs);
                boolean bl = encodingConvertsEOL = !Arrays.equals(lf, convertedEOL);
                if (Arrays.equals(convertedEOL, eol) && encodingConvertsEOL) {
                    out = new SVNCharsetOutputStream(out, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                    if (keywords != null) {
                        out = new SVNTranslatorOutputStream(out, null, false, keywords, expand);
                    }
                    return out;
                }
            }
            out = new SVNCharsetOutputStream(out, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        if (eol != null) {
            boolean encodingConvertsEOL;
            byte[] convertedEOL = SVNTranslator.convertEOL(eol, cs, UTF8_CHARSET);
            boolean bl = encodingConvertsEOL = !Arrays.equals(eol, convertedEOL);
            if (Arrays.equals(convertedEOL, lf) && encodingConvertsEOL) {
                if (keywords != null) {
                    out = new SVNTranslatorOutputStream(out, null, false, keywords, expand);
                }
                return new SVNCharsetOutputStream(out, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
            }
        }
        out = new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        return new SVNCharsetOutputStream(out, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
    }

    public static InputStream getTranslatingInputStream(InputStream in, String charset, byte[] eol, boolean repair, Map<String, byte[]> keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
        }
        Charset cs = Charset.forName(charset);
        byte[] lf = SVNProperty.EOL_LF_BYTES;
        if (expand) {
            if (eol != null) {
                boolean encodingConvertsEOL;
                byte[] convertedEOL = SVNTranslator.convertEOL(lf, UTF8_CHARSET, cs);
                boolean bl = encodingConvertsEOL = !Arrays.equals(convertedEOL, lf);
                if (Arrays.equals(eol, convertedEOL) && encodingConvertsEOL) {
                    if (keywords != null) {
                        in = new SVNTranslatorInputStream(in, null, false, keywords, expand);
                    }
                    return new SVNCharsetInputStream(in, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                }
            }
            in = new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
            return new SVNCharsetInputStream(in, UTF8_CHARSET, cs, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
        }
        if (eol != null) {
            boolean charsetConvertsEOL;
            byte[] convertedEOL = SVNTranslator.convertEOL(eol, cs, UTF8_CHARSET);
            boolean bl = charsetConvertsEOL = !Arrays.equals(convertedEOL, eol);
            if (Arrays.equals(lf, convertedEOL) && charsetConvertsEOL) {
                in = new SVNCharsetInputStream(in, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
                if (keywords != null) {
                    in = new SVNTranslatorInputStream(in, null, false, keywords, expand);
                }
                return in;
            }
        }
        in = new SVNCharsetInputStream(in, cs, UTF8_CHARSET, SVNTranslator.getOnMalformedInputAction(), SVNTranslator.getOnUnmappableCharacterAction());
        return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
    }

    private static byte[] convertEOL(byte[] eol, Charset from, Charset to) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(eol);
        CharBuffer charBuffer = from.decode(byteBuffer);
        ByteBuffer resultBuffer = to.encode(charBuffer);
        byte[] result = new byte[resultBuffer.limit()];
        resultBuffer.get(result, 0, result.length);
        return result;
    }

    public static Map<String, byte[]> computeKeywords(String keywords, String u, String a, String d, String r, ISVNOptions options) {
        if (keywords == null) {
            return Collections.emptyMap();
        }
        boolean expand = u != null;
        byte[] date = null;
        byte[] idDate = null;
        byte[] url = null;
        byte[] rev = null;
        byte[] author = null;
        byte[] name = null;
        byte[] id = null;
        byte[] header = null;
        SVNDate jDate = d == null ? null : SVNDate.parseDate(d);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            StringTokenizer tokens = new StringTokenizer(keywords, " \t\n\b\r\f");
            while (tokens.hasMoreTokens()) {
                ByteArrayOutputStream bos;
                String token = tokens.nextToken();
                if ("LastChangedDate".equals(token) || "Date".equalsIgnoreCase(token)) {
                    date = expand && date == null ? SVNDate.formatHumanDate(jDate, options).getBytes("UTF-8") : date;
                    map.put("LastChangedDate", date);
                    map.put("Date", date);
                    continue;
                }
                if ("LastChangedRevision".equals(token) || "Revision".equals(token) || "Rev".equalsIgnoreCase(token)) {
                    rev = expand && rev == null ? r.getBytes("UTF-8") : rev;
                    map.put("LastChangedRevision", rev);
                    map.put("Revision", rev);
                    map.put("Rev", rev);
                    continue;
                }
                if ("LastChangedBy".equals(token) || "Author".equalsIgnoreCase(token)) {
                    author = expand && author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    map.put("LastChangedBy", author);
                    map.put("Author", author);
                    continue;
                }
                if ("HeadURL".equals(token) || "URL".equalsIgnoreCase(token)) {
                    url = expand && url == null ? u.getBytes("UTF-8") : url;
                    map.put("HeadURL", url);
                    map.put("URL", url);
                    continue;
                }
                if ("Id".equalsIgnoreCase(token)) {
                    if (expand && header == null) {
                        rev = rev == null ? r.getBytes("UTF-8") : rev;
                        idDate = idDate == null ? SVNDate.formatShortDate(jDate).getBytes("UTF-8") : idDate;
                        byte[] byArray = name = name == null ? SVNEncodingUtil.uriDecode(SVNPathUtil.tail(u)).getBytes("UTF-8") : name;
                        author = author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                        bos = new ByteArrayOutputStream();
                        bos.write(name);
                        bos.write(32);
                        bos.write(rev);
                        bos.write(32);
                        bos.write(idDate);
                        bos.write(32);
                        bos.write(author);
                        bos.close();
                        id = bos.toByteArray();
                    }
                    map.put("Id", expand ? id : null);
                    continue;
                }
                if (!"Header".equalsIgnoreCase(token)) continue;
                if (expand && header == null) {
                    rev = rev == null ? r.getBytes("UTF-8") : rev;
                    url = expand && url == null ? SVNEncodingUtil.uriDecode(u).getBytes("UTF-8") : url;
                    byte[] byArray = idDate = idDate == null ? SVNDate.formatShortDate(jDate).getBytes("UTF-8") : idDate;
                    author = author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    bos = new ByteArrayOutputStream();
                    bos.write(url);
                    bos.write(32);
                    bos.write(rev);
                    bos.write(32);
                    bos.write(idDate);
                    bos.write(32);
                    bos.write(author);
                    bos.close();
                    header = bos.toByteArray();
                }
                map.put("Header", expand ? header : null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return map;
    }

    public static byte[] getEOL(String eolStyle, ISVNOptions options) {
        if ("native".equals(eolStyle)) {
            return options.getNativeEOL();
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static byte[] getBaseEOL(String eolStyle) {
        if ("native".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static String getCharset(String charset, String mimeType, Object path, ISVNOptions options) throws SVNException {
        boolean isSupported;
        if (charset == null) {
            charset = SVNTranslator.getGlobalCharset(options, mimeType);
        }
        if ("native".equals(charset)) {
            charset = options.getNativeCharset();
        }
        if (charset == null) {
            return null;
        }
        try {
            isSupported = Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            isSupported = false;
        }
        if (!isSupported) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Charset ''{0}'' is not supported on this computer; change svnkit:charset property value or remove that property for file ''{1}''", charset, path), SVNLogType.DEFAULT);
        }
        return charset;
    }

    private static String getGlobalCharset(ISVNOptions options, String mimeType) {
        if (options instanceof DefaultSVNOptions && SVNProperty.isTextMimeType(mimeType)) {
            DefaultSVNOptions defaults = (DefaultSVNOptions)options;
            return defaults.getGlobalCharset();
        }
        return null;
    }

    public static void translationError(File path, IOException e) throws SVNException {
        IOExceptionWrapper wrapper;
        SVNException wrappedException;
        SVNErrorMessage error = path != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Failed to translate ''{0}''", new Object[]{path}) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Translation failed");
        Exception cause = e;
        if (e instanceof IOExceptionWrapper && (wrappedException = (wrapper = (IOExceptionWrapper)e).getOriginalException()) != null) {
            error.setChildErrorMessage(wrappedException.getErrorMessage());
            cause = wrappedException;
        }
        SVNErrorManager.error(error, cause, SVNLogType.DEFAULT);
    }

    public static synchronized CodingErrorAction getOnMalformedInputAction() {
        return onMalformedInputAction;
    }

    public static synchronized CodingErrorAction getOnUnmappableCharacterAction() {
        return onUnmappableCharacterAction;
    }

    public static synchronized void setEncoderActions(CodingErrorAction onMalformedInput, CodingErrorAction onUnmappableCharacter) {
        onMalformedInputAction = onMalformedInput;
        onUnmappableCharacterAction = onUnmappableCharacter;
    }
}

