# Contributing to the UnboundID LDAP SDK for Java

Thanks for taking the time to contribute!

## How can I contribute?

### Reporting bugs

#### Before submitting a bug report

It can be helpful to review the [documentation](https://docs.ldap.com/ldap-sdk/docs/index.html) and [examples](https://docs.ldap.com/ldap-sdk/docs/examples/index.html), including the [Javadocs](https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html). It's also a good idea to search the GitHub [issue tracker](https://github.com/pingidentity/ldapsdk/issues) or the SourceForge [discussion forum](https://sourceforge.net/p/ldap-sdk/discussion/1001257/) to see if your issue or one similar to it has already been reported.


#### How do I submit a bug report?

Bugs are tracked as [GitHub issues](https://guides.github.com/features/issues/). You can report a bug by submitting an issue in the project's [issue tracker](https://github.com/pingidentity/ldapsdk/issues). To help the maintainers understand and reproduce the problem, please try to provide information like the following:

* A clear and descriptive title.
* A description of what happened and a description of what you expected to happen.
* An example with the exact steps needed to reproduce the problem. If relevant, sample code is helpful.

Please understand that bug reports are reviewed and prioritized internally, and we may not be able to address all bug reports or provide an estimated time for resolution.

#### Suggesting enhancements

As with bugs, requests are tracked as [GitHub issues](https://guides.github.com/features/issues/). You can suggest an enhancement by submitting an issue in the project's [issue tracker](https://github.com/pingidentity/ldapsdk/issues).

Please understand that enhancement requests are reviewed and prioritized internally, and we may not be able to address all requests or provide an estimated time for resolution.

#### Alternate routes for submitting bugs and suggesting enhancements

If you have a support contract with Ping Identity, you can get assistance with the LDAP SDK in the same way that you get support for other Ping Identity products. Contact [ldapsdk-support@pingidentity.com](mailto:ldapsdk-support@pingidentity.com) for more information about obtaining a support contract for the LDAP SDK.

If you would rather not have your issue discussed in public, you can email bug reports or enhancement requests to [ldapsdk-support@pingidentity.com](mailto:ldapsdk-support@pingidentity.com).

### Contributing Code Changes

Ping Identity does not accept third-party code submissions.
