/*
 * Copyright 2014-2019 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2014-2019 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.listener.interceptor;



/**
 * This class provides an implementation of an in-memory operation interceptor
 * that does absolutely nothing.  It merely makes it possible to provide test
 * coverage for multiple interceptors and the default implementations of
 * interceptor methods.
 */
final class DoNothingOperationInterceptor
      extends InMemoryOperationInterceptor
{
  /**
   * Creates a new instance of this interceptor.
   */
  DoNothingOperationInterceptor()
  {
    // No implementation required.
  }
}
