/*
 * Copyright 2012-2019 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2012-2019 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.util;



import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;



/**
 * This class provides an SSL socket factory implementation that will always
 * throw an exception for every request.
 */
public final class ExceptionSSLSocketFactory
       extends SSLSocketFactory
{
  /**
   * Creates a new instance of this socket factory.
   */
  public ExceptionSSLSocketFactory()
  {
    // No implementation required.
  }



  /**
   * Creates a new socket to the specified server.
   *
   * @param  host  The host to which the connection should be established.
   * @param  port  The port to which the connection should be established.
   *
   * @return  The socket that was created.
   *
   * @throws  IOException  If a problem occurs while creating the socket.
   */
  @Override()
  public Socket createSocket(final String host, final int port)
         throws IOException
  {
    throw new IOException("ExceptionSocketFactory");
  }



  /**
   * Creates a new socket to the specified server.
   *
   * @param  host          The host to which the connection should be
   *                       established.
   * @param  port          The port to which the connection should be
   *                       established.
   * @param  localAddress  The local address to use for the connection.  This
   *                       will be ignored.
   * @param  localPort     The local port to use for the connection.  This will
   *                       be ignored.
   *
   * @return  The socket that was created.
   *
   * @throws  IOException  If a problem occurs while creating the socket.
   */
  @Override()
  public Socket createSocket(final String host, final int port,
                             final InetAddress localAddress,
                             final int localPort)
         throws IOException
  {
    throw new IOException("ExceptionSocketFactory");
  }



  /**
   * Creates a new socket to the specified server.
   *
   * @param  address  The address to which the connection should be established.
   * @param  port     The port to which the connection should be established.
   *
   * @return  The socket that was created.
   *
   * @throws  IOException  If a problem occurs while creating the socket.
   */
  @Override()
  public Socket createSocket(final InetAddress address, final int port)
         throws IOException
  {
    throw new IOException("ExceptionSocketFactory");
  }



  /**
   * Creates a new socket to the specified server.
   *
   * @param  address       The address to which the connection should be
   *                       established.
   * @param  port          The port to which the connection should be
   *                       established.
   * @param  localAddress  The local address to use for the connection.  This
   *                       will be ignored.
   * @param  localPort     The local port to use for the connection.  This will
   *                       be ignored.
   *
   * @return  The socket that was created.
   *
   * @throws  IOException  If a problem occurs while creating the socket.
   */
  @Override()
  public Socket createSocket(final InetAddress address, final int port,
                             final InetAddress localAddress,
                             final int localPort)
         throws IOException
  {
    throw new IOException("ExceptionSocketFactory");
  }



  /**
   * Creates a new SSL socket that wraps the provided socket.
   *
   * @param  s          The existing socket to be wrapped to create an SSL
   *                    socket.
   * @param  host       The host to which the connection is established.
   * @param  port       The port to which the connection is established.
   * @param  autoClose  Indicates whether the provided socket should be closed
   *                    when the created SSL socket is closed.
   *
   * @return  The SSL socket that was created.
   *
   * @throws  IOException  If a problem occurs while creating the socket.
   */
  @Override()
  public Socket createSocket(final Socket s, final String host, final int port,
                             final boolean autoClose)
         throws IOException
  {
    throw new IOException("ExceptionSocketFactory");
  }



  /**
   * Retrieves the set of cipher suites which are enabled by default.
   *
   * @return  The set of cipher suites which are enabled by default.
   */
  @Override()
  public String[] getDefaultCipherSuites()
  {
    return StaticUtils.NO_STRINGS;
  }



  /**
   * Retrieves the entire set of cipher suites that could be used.
   *
   * @return  The entire set of cipher suites that could be used.
   */
  @Override()
  public String[] getSupportedCipherSuites()
  {
    return StaticUtils.NO_STRINGS;
  }
}
