#
# Copyright 2012 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

import lsblk

from testrunner import VdsmTestCase as TestCaseBase

output = """\
KNAME="sda" FSTYPE="" UUID=""
KNAME="sda1" FSTYPE="ext4" UUID="12345678-0c05-1111-2222-1234567890d6"
KNAME="sda2" FSTYPE="swap" UUID="12345678-1111-2222-3333-12345678903c"
"""


class TestLsblk(TestCaseBase):

    def testParseLsBlk(self):
        blkDict = lsblk._parseLsBlk(output.splitlines())
        expected = {'sda': {'FSTYPE': '', 'KNAME': 'sda', 'UUID': ''},
                    'sda1': {'FSTYPE': 'ext4',
                             'KNAME': 'sda1',
                             'UUID': '12345678-0c05-1111-2222-1234567890d6'},
                    'sda2': {'FSTYPE': 'swap',
                             'KNAME': 'sda2',
                             'UUID': '12345678-1111-2222-3333-12345678903c'}}
        self.assertEqual(expected, blkDict)
