# Packages names
%global vdsm_name vdsm

# Required users and groups
%global vdsm_user vdsm
%global vdsm_group kvm
%global qemu_user qemu
%global qemu_group qemu
%global snlk_group sanlock
%global snlk_user sanlock
%global cdrom_group cdrom
# Not configurable because owned by ovirt-vmconsole package
%global vmcon_user ovirt-vmconsole
%global vmcon_group ovirt-vmconsole

# Features
%global with_ovirt_imageio 1
%global with_ovirt_vmconsole 1
%global with_gluster_mgmt 1
%global with_hooks 1
%global with_vhostmd 1
%global with_python3 0
%global with_containers 0

%ifarch ppc64le
%global with_openvswitch 0
%else
%global with_openvswitch 1
%endif

# Glusterfs package version
%global gluster_version 3.7.1

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%global enable_autotools 0}

# Required paths
%if 0%{?fedora}
%global _polkitdir %{_datadir}/polkit-1/rules.d
%else
%global _polkitdir %{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d
%endif

# Disable debuginfo package, since vdsm is a meta-package
%global debug_package %{nil}

Name:           %{vdsm_name}
Version:        4.19.45
Release:        1%{?dist}%{?extra_release}
Summary:        Virtual Desktop Server Manager

Group:          Applications/System
License:        GPLv2+
Url:            http://www.ovirt.org/develop/developer-guide/vdsm/vdsm/
Source0:        %{vdsm_name}-%{version}.tar.gz

%{!?_licensedir:%global license %%doc}

BuildRequires: openssl
BuildRequires: python
BuildRequires: python-cpopen
BuildRequires: python-six >= 1.9.0
BuildRequires: python-dateutil
BuildRequires: python2-devel
BuildRequires: PyYAML
BuildRequires: rpm-build
BuildRequires: systemd-units

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
%endif


# Numactl is not available on s390[x] and ARM
%ifnarch s390 s390x %{arm}
Requires: numactl
%endif

%ifarch x86_64
Requires: python-dmidecode
Requires: dmidecode
Requires: virt-v2v
%endif

Requires: chrony
Requires: cyrus-sasl-scram
Requires: dbus-python
Requires: ethtool
Requires: which
Requires: sudo >= 1.7.3
Requires: logrotate
Requires: xz
Requires: iproute >= 3.10.0
Requires: PyYAML
Requires: python-dateutil
Requires: python-netaddr
Requires: python-inotify
Requires: python-cpopen >= 1.5
Requires: python-ioprocess >= 0.16.1-1
Requires: python-pthreading >= 0.1.3-3
Requires: python-six >= 1.9.0
Requires: python-requests
Requires: rpm-python
Requires: nfs-utils
Requires: m2crypto
Requires: libnl3
Requires: abrt-cli
Requires: abrt-addon-vmcore
Requires: abrt-addon-ccpp
Requires: abrt-addon-python
Requires: curl
Requires: %{name}-xmlrpc = %{version}-%{release}
Requires: %{name}-jsonrpc = %{version}-%{release}
Requires: safelease >= 1.0-7
Requires: mom >= 0.5.8
Requires(pre): shadow-utils

Obsoletes: %{name}-infra < 4.19

%if 0%{?with_openvswitch}
Requires: openvswitch >= 2.0.0
%endif

%if 0%{?with_ovirt_imageio}
Requires: ovirt-imageio-common
Requires: ovirt-imageio-daemon
%endif

%if 0%{?with_ovirt_vmconsole}
Requires: ovirt-vmconsole >= 1.0.0-0
%endif

Requires: libvirt-client
Requires: libvirt-daemon-config-nwfilter
Requires: libvirt-lock-sanlock

%if 0%{?rhel}
Requires: libvirt-python >= 3.2.0-3.el7_4.1
Requires: libvirt-daemon-kvm >= 3.2.0-14.el7_4.7
# Require the latest version on Fedora 26 that contain the fixes as in RHEL
%else # fedora
Requires: libvirt-daemon-kvm >= 2.2.0-1
Requires: libvirt-python >= 2.2.0-1
%endif

# iscsi-intiator versions
%if 0%{?rhel}
Requires: iscsi-initiator-utils
%else # fedora
Requires: iscsi-initiator-utils >= 6.2.0.873-21
%endif

%if  0%{?rhel}
Requires: sanlock >= 3.5.0-1
%else
Requires: sanlock >= 3.4.0-1
%endif
Requires: sanlock-python

# device-mapper-multipath

%if 0%{?rhel}
Requires: device-mapper-multipath >= 0.4.9-84.el7
%endif #rhel

%if 0%{?fedora}
Requires: device-mapper-multipath >= 0.4.9-80
%endif

# augeas

%if 0%{?rhel}
Requires: python-augeas
%endif

%if 0%{?fedora}
Requires: python2-augeas
%endif

%if 0%{?rhel}
Requires: e2fsprogs
Requires: fence-agents-all
Requires: kernel >= 3.10.0-693.11.6.el7
Requires: lvm2 >= 7:2.02.145
Requires: python >= 2.7.5-18.el7_1.1
Requires: policycoreutils-python
Requires: selinux-policy-targeted >= 3.13.1-60.el7
Requires: systemd >= 219-11.el7
Requires: initscripts >= 9.49.30-1.el7_2.3
%else
Requires: fence-agents-all
Requires: kernel >= 4.1.6
# Subprocess and thread bug was found on python 2.7.2
Requires: python >= 2.7.3
Requires: initscripts >= 9.42.2-1
Requires: e2fsprogs >= 1.41.14
%if 0%{?fedora} >= 23
Requires: policycoreutils-python-utils
%endif # fedora 23
Requires: policycoreutils-python
Requires: sed >= 4.2.1-10
Requires: ed
Requires: lvm2 >= 2.02.145
Requires: selinux-policy-targeted >= 3.13-1
# In order to avoid a policycoreutils bug (rhbz 889698) when selinux is
# disabled we now require the version 2.1.13-55 (or newer) of Fedora.
Requires: policycoreutils >= 2.1.13-55
Requires: systemd >= 209
%endif

%if 0%{?rhel}
Requires: qemu-kvm-rhev >= 10:2.9.0-16.el7_4.13
%else # fedora
Requires: qemu-kvm >= 2:2.7.0-7
%endif

# GlusterFS client-side RPMs needed for Gluster SD
%ifnarch ppc64le
Requires: glusterfs-cli >= %{gluster_version}
Requires: glusterfs-fuse >= %{gluster_version}
%endif

Requires: psmisc >= 22.6-15
Requires: bridge-utils
Requires: sos
Requires: tree
Requires: dosfstools
Requires: genisoimage
Requires: libselinux-python
Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-hook-vmfex-dev = %{version}-%{release}
Requires: NetworkManager-config-server
Requires: lldpad

%if 0%{?rhel}
Requires: python-decorator
%endif

%if 0%{?fedora}
Requires: python2-decorator
%endif

Requires(post): /usr/sbin/saslpasswd2

%if 0%{?fedora}
Requires(post): hostname
%else
Requires(post): /bin/hostname
%endif

Conflicts: vdsm-hook-sriov

%description
The VDSM service is required by a Virtualization Manager to manage the
Linux hosts. VDSM manages and monitors the host's storage, memory and
networks as well as virtual machine creation, other host administration
tasks, statistics gathering, and log collection.

%package cli
Summary:        VDSM command line interface
BuildArch:      noarch
Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-xmlrpc = %{version}-%{release}

%description cli
Call VDSM commands from the command line. Used for testing and debugging.

%package xmlrpc
Summary:        VDSM xmlrpc API
BuildArch:      noarch
Requires: %{name}-python = %{version}-%{release}


%description xmlrpc
An XMLRPC interface for interacting with vdsmd. Primary control interface for
ovirt-engine and vdsClient.

%package client
Summary:        VDSM client
BuildArch:      noarch
Requires: %{name}-api = %{version}-%{release}
Requires: %{name}-yajsonrpc = %{version}-%{release}

%description client
Access vdsm API from the command line.

%package api
Summary:        VDSM API
BuildArch:      noarch

%description api
Contains api schema files

%package jsonrpc
Summary:        VDSM API Server
BuildArch:      noarch
Requires:       %{name}-python = %{version}-%{release}
Requires:       %{name}-api = %{version}-%{release}
Requires:       %{name}-yajsonrpc = %{version}-%{release}
Obsoletes:      %{name}-api < 4.16

%description jsonrpc
A Json-based RPC interface that serves as the protocol for libvdsm.

%package yajsonrpc
Summary:        JSON RPC server and client implementation
BuildArch:      noarch
Requires:       python >= 2.6

%description yajsonrpc
A JSON RPC server and client implementation.

%package python
Summary:        VDSM python libraries
Requires:       %{name}-api = %{version}-%{release}
BuildArch:      noarch
Requires:       python-cpopen >= 1.5
Requires:       m2crypto
Requires:       python-ioprocess >= 0.16.1-1

%description python
Shared libraries between the various VDSM packages.

%post python
# REQUIRED_FOR: Upgrade from 4.14 to 4.17
# HACK: Remove vdsm python lib __init__ file if installed on old location
# https://bugzilla.redhat.com/show_bug.cgi?id=1279167
if [ "$1" -ge 2 ]; then
    if [ -d "%{python2_sitearch}/%{vdsm_name}" ]; then
        logger -t '%{vdsm_name}' \
            'Disabling old vdsm package in %{python2_sitearch}/%{vdsm_name}.' \
            'Removing %{python2_sitearch}/%{vdsm_name}/init.py*'
        rm -f %{python2_sitearch}/%{vdsm_name}/__init__.py*
    fi
fi

%package tests
Summary:        VDSM Test Suite
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Requires:       dracut
Requires:       python-nose python-ipaddress

%description tests
A test suite for verifying the functionality of a running vdsm instance

%package hook-allocate_net
Summary:        random_network allocation hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-allocate_net
VDSM hook used to allocate networks for vms in a random fashion

%package hook-checkimages
Summary:        Qcow2 disk image format check hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-checkimages
VDSM hook used to perform consistency check on a qcow2 format disk image
using the QEMU disk image utility.

%package hook-checkips
Summary:        Check connectivity from the host to designated IPs
Requires:       %{name} = %{version}-%{release}

%description hook-checkips
VDSM hook used to check connectivity from the host network to designated IPs

%post hook-checkips
%systemd_post vdsm-checkips.service

%preun hook-checkips
%systemd_preun vdsm-checkips.service

%package hook-diskunmap
Summary:        Activate UNMAP for disk/lun devices
BuildArch:      noarch
Requires:       qemu-kvm >= 1.5

%description hook-diskunmap
VDSM hooks which allow to activate disk UNMAP.

%package hook-ethtool-options
Summary:        Allow setting custom ethtool options for vdsm controlled nics
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description hook-ethtool-options
VDSM hook used for applying custom network properties that define ethtool
options for vdsm network nics

%package hook-extra-ipv4-addrs
Summary:        Set extra ipv4 addresses for vdsm networks.

%description hook-extra-ipv4-addrs
This hook allows the user to set extra ipv4
addresses for vdsm networks.

%if 0%{?with_vhostmd}
%package hook-vhostmd
Summary:        VDSM hook set for interaction with vhostmd
BuildArch:      noarch
Requires:       vhostmd

%description hook-vhostmd
VDSM hook to use vhostmd per VM according to Virtualization Manager requests.
%endif

%package hook-faqemu
Summary:        Fake qemu process for VDSM quality assurance
BuildArch:      noarch
Requires:       %{name}

%description hook-faqemu
VDSM hook used for testing VDSM with multiple fake virtual machines without
running real guests.
To enable this hook on your host, set vars.fake_kvm_support=True in your
/etc/vdsm/vdsm.conf before adding the host to ovirt-Engine.

%package hook-localdisk
Summary:        Use a local image instead of a shared storage image
BuildArch:      noarch
Requires:       %{name} == %{version}

%description hook-localdisk
This hook add the ability to use fast local storage instead of shared
storage, while using shared storage for managing VM templates.
To enable this hook, the VM should have a custom property of 'localdisk=lvm'.
The system administrator will be responsible for creating the host "ovirt-local"
volume group and extending it with new devices if needed.
The VM must be pinned to host.

%package hook-macbind
Summary:        Bind a vNIC to a Bridge
BuildArch:      noarch
Requires:       %{name} >= 4.14

%description hook-macbind
VDSM hooks which allow to bind a vNIC to a Bridge, managed or not by engine.

%package hook-macspoof
Summary:        Disables MAC spoofing filtering
BuildArch:      noarch

%description hook-macspoof
VDSM hooks which allow to disable mac spoof filtering
either on all the of the VM's interfaces or on
specific vnics.

%package hook-noipspoof
Summary:        Enables strict anti-spoofing filtering
BuildArch:      noarch

%description hook-noipspoof
VDSM hook which allows to enable strict anti-spoofing filtering
on all of the the VM's interfaces.

%package hook-extnet
Summary:        Force a vNIC to connect to a specific libvirt network
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description hook-extnet
VDSM hook which allows to connect a vNIC to a libvirt network that is managed
outside of oVirt, such as an openvswitch network.

%package hook-fakevmstats
Summary:        Generate random VM statistics
BuildArch:      noarch
Requires:       %{name}

%description hook-fakevmstats
Hook intercepts VM's stats and randomizes various fields.
To enable this hook on your host, set vars.fake_vmstats_enable=true in your
/etc/vdsm/vdsm.conf.

%package hook-fakesriov
Summary:        Generate fake SR-IOV devices
Requires:       %{name}

%description hook-fakesriov
Hook intercepts reported host device by hostdevListByCaps and adds
1 fake sriov devices and 2 fake virtual function devices
To enable this hook on your host, set vars.fake_sriov_enable=true in your
/etc/vdsm/vdsm.conf.

%package hook-fileinject
Summary:        Allow uploading file to VMs disk
BuildArch:      noarch
Requires:       python-libguestfs

%description hook-fileinject
Hook is getting target file name and its content and
create that file in target machine.

%package hook-floppy
Summary:        Allow adding floppy to VM
BuildArch:      noarch

%description hook-floppy
Allow adding floppy to VM

%package hook-hostusb
Summary:        Allow attaching USB device from host
BuildArch:      noarch
Requires:       usbutils

%description hook-hostusb
Hook is getting vendor and product id of USB device
disconnect it from host and attach it to VM

%package hook-httpsisoboot
Summary:        Allow directly booting from an https available ISO
BuildArch:      noarch
%if 0%{?rhel}
Requires:       qemu-kvm-rhev >= 10:2.1.2-3
%endif

%description hook-httpsisoboot
Let the VM boot from an ISO image made available via an https URL without
the need to import the ISO into an ISO storage domain.
It doesn't support plain http.

%package hook-hugepages
Summary:        Huge pages enable user to handle VM with 2048KB page files.
BuildArch:      noarch

%description hook-hugepages
Hook is getting number of huge pages reserve them for the VM,
and enable user to handle VM with 2048KB page files.

%package hook-isolatedprivatevlan
Summary:        Isolated network environment for VMs
BuildArch:      noarch

%description hook-isolatedprivatevlan
limit VM traffic to a specific gateway by its mac address,
hook prevent VM from spoofing its mac or  ip address
by using <filterref filter='clean-traffic'/> libvirt filter
and by adding custom filter: isolatedprivatevlan-vdsm.xml

%package hook-nestedvt
Summary:        Nested Virtualization support for VDSM
BuildArch:      noarch

%description hook-nestedvt
If the nested virtualization is enabled in your kvm module
this hook will expose it to the guests.

%package hook-numa
Summary:        NUMA support for VDSM
BuildArch:      noarch

%description hook-numa
Hooks is getting number/rage of NUMA nodes and NUMA mode,
and update the VM xml.

%package hook-openstacknet
Summary:        OpenStack Network vNICs support for VDSM
BuildArch:      noarch

%description hook-openstacknet
Hook for OpenStack Network vNICs.

%package hook-pincpu
Summary:        Hook pin VM so specific CPUs
BuildArch:      noarch

%description hook-pincpu
pincpu is hook for VDSM.
pincpu enable to pin virtual machine to a specific CPUs.

%package hook-promisc
Summary:        Network interface promiscuous mode support for VDSM
BuildArch:      noarch

%description hook-promisc
VDSM promiscuous mode let user define a VM interface that will capture
all network traffic.

%package hook-qemucmdline
Summary:        QEMU cmdline hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-qemucmdline
Provides support for injecting QEMU cmdline via VDSM hook.
It exploits libvirt's qemu:commandline facility available in the
qemu xml namespace.

%package hook-qos
Summary:        QoS network in/out traffic support for VDSM
BuildArch:      noarch

%description hook-qos
Hook adds QoS in/out traffic to VMs interfaces

%package hook-scratchpad
Summary:        One time disk creation for VDSM
BuildArch:      noarch

%description hook-scratchpad
scratchpad hook for VDSM
Hook creates a disk for a VM onetime usage,
the disk will be erased when the VM destroyed.
VM cannot be migrated when using scratchpad hook

%package hook-smbios
Summary:        Adding custom smbios entries to libvirt domain via VDSM
BuildArch:      noarch

%description hook-smbios
Adding custom smbios entries to libvirt domain via VDSM
such as: vendor, version, date and release

%package hook-spiceoptions
Summary:        To configure spice options for vm
BuildArch:      noarch

%description hook-spiceoptions
This vdsm hook can be used to configure some of
the spice optimization attributes and values..

%package hook-vmfex
Summary:        vmfex support for VDSM
BuildArch:      noarch
Conflicts:      hook-vmfex-dev

%description hook-vmfex
Hook for vmfex.

%package hook-vmfex-dev
Summary:        VM-FEX vNIC support for VDSM
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Conflicts:      hook-vmfex

%description hook-vmfex-dev
Allows to use custom device properties to connect a guest vNIC to a host
VM-FEX Virtual Function (SR-IOV with macvtap mode).

%package hook-vmdisk
Summary:        External disk support for VDSM
BuildArch:      noarch

%description hook-vmdisk
Hook adds additional disk image for a VM (raw or qcow2)

%package hook-ipv6
Summary:        Set IPv6 configuration through custom network properties
BuildArch:      noarch
Requires:       %{name} >= 4.16.7

%description hook-ipv6
VDSM hook used for applying IPv6 configuration through custom network
properties

%package hook-fcoe
Summary:        Hook to enable FCoE support
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Requires:       fcoe-utils

%description hook-fcoe
VDSM hook used for configure specified NICs as FCoE interface through custom
network properties

%post hook-fcoe
%systemd_post lldpad.service
%systemd_post fcoe.service

%package hook-vfio-mdev
Summary:        Hook to enable mdev-capable devices.
BuildArch:      noarch

%description hook-vfio-mdev
Hook to use mdev-capable devices through custom properties.

%if 0%{?with_gluster_mgmt}
%package gluster
Summary:        Gluster Plugin for VDSM
BuildArch:      noarch
Requires: %{name} = %{version}-%{release}
Requires: glusterfs-server >= %{gluster_version}
Requires: glusterfs-api >= %{gluster_version}
Requires: glusterfs-geo-replication >= %{gluster_version}
Requires: python-magic
%if 0%{?fedora} >= 25
Requires: python-blivet1
%else
Requires: python-blivet
%endif
Requires: xfsprogs

%description gluster
Gluster plugin enables VDSM to serve Gluster functionalities.
%endif

%package containers
Summary: Container support for Vdsm
BuildArch: noarch
Requires: %{name} = %{version}-%{release}

%description containers
Enables VDSM to manage containers alongside virtual machines.

%prep
%setup -q

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif
%configure \
%if 0%{?with_hooks}
        --enable-hooks \
%endif
%if ! 0%{?with_gluster_mgmt}
        --disable-gluster-mgmt \
%endif
%if ! 0%{?with_python3}
        --disable-python3 \
%endif
        --with-smbios-manufacturer='oVirt' \
        --with-smbios-osname='oVirt Node' \
%if ! 0%{?with_ovirt_imageio}
        --disable-ovirt-imageio \
%endif
%if ! 0%{?with_openvswitch}
        --disable-openvswitch \
%endif
%if 0%{?with_ovirt_vmconsole}
        --with-ovirt-vmconsole-user=%{vmcon_user} \
        --with-ovirt-vmconsole-group=%{vmcon_group} \
%else
        --with-ovirt-vmconsole-user='vdsm' \
        --with-ovirt-vmconsole-group='kvm' \
%endif
%if 0%{?with_containers}
        --enable-containers \
%endif
        --with-data-center='/rhev/data-center'

make
# Setting software_version and software_revision in dsaversion.py
baserelease=`echo "%{release}" | sed 's/\([0-9]\+\(\.[0-9]\+\)\?\).*/\1/'`
baseversion=`echo "%{version}" | sed 's/\([0-9]\+\(\.[0-9]\+\)\?\).*/\1/'`
rawversion=%{version}-%{release}
sed -i -e 's/^software_version =.*/software_version = "'"${baseversion}"'"/' \
       -e 's/^raw_version_revision =.*/raw_version_revision = "'"${rawversion}"'"/' \
       -e 's/^software_revision =.*/software_revision = "'"${baserelease}"'"/' lib/vdsm/dsaversion.py

sed -i -e 's/@SSL_IMPLEMENTATION@/m2c/g' lib/vdsm/config.py

sed -i -e 's\@VDSMRPCPYLIBDIR@\%{python_sitelib}/%{vdsm_name}/rpc\g' lib/vdsm/constants.py

%install
make DESTDIR=%{buildroot} install

# Creating VDSM logs in this session to avoid rpmbuild
# complain during the build
install -dDm 0755 %{buildroot}/var/log/vdsm
touch %{buildroot}/var/log/vdsm/{mom.log,supervdsm.log,vdsm.log}

# Install the lvm rules
install -Dm 0644 vdsm/storage/vdsm-lvm.rules \
                 %{buildroot}%{_udevrulesdir}/12-vdsm-lvm.rules

install -Dm 0755 init/systemd/systemd-vdsmd %{buildroot}%{_libdir}/systemd/systemd-vdsmd
install -Dm 0644 init/systemd/85-vdsmd.preset %{buildroot}%{_presetdir}/85-vdsmd.preset

install -Dm 0644 init/systemd/vdsm-tmpfiles.d.conf \
                 %{buildroot}%{_tmpfilesdir}/%{vdsm_name}.conf
install -Dm 0644 init/systemd/unlimited-core.conf \
                 %{buildroot}%{_sysconfdir}/systemd/system/libvirtd.service.d/unlimited-core.conf

%if 0%{?with_hooks}
install -Dm 0644 vdsm_hooks/fcoe/85-vdsm-hook-fcoe.preset %{buildroot}%{_presetdir}
%endif

%if 0%{?rhel}
# This is not commonplace, but we want /var/log/core to be a world-writable
# dropbox for core dumps
install -dDm 1777 %{buildroot}%{_localstatedir}/log/core
%endif

# Install the polkit for libvirt
install -Dm 0644 vdsm/vdsm-libvirt-access.rules \
                 %{buildroot}%{_polkitdir}/10-vdsm-libvirt-access.rules

# Install the libvirt hook for cleaning up the XML
install -Dm 0755 vdsm/virt/libvirt-hook.sh \
                 %{buildroot}%{_sysconfdir}/libvirt/hooks/qemu

%pre
# Force standard locale behavior (English)
export LC_ALL=C

/usr/bin/getent passwd %{vdsm_user} >/dev/null || \
    /usr/sbin/useradd -r -u 36 -g %{vdsm_group} -d /var/lib/vdsm \
        -s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}
/usr/sbin/usermod -a -G %{qemu_group},%{snlk_group} %{vdsm_user}
/usr/sbin/usermod -a -G %{cdrom_group} %{qemu_user}

# We keep the previous rpm version number in a file for managing upgrade flow
# in vdsmd_init_script upgraded_version_check task
if [ "$1" -gt 1 ]; then
    rpm -q %{vdsm_name} > "%{_localstatedir}/lib/%{vdsm_name}/upgraded_version"
fi

%post
# After vdsm install we should create the logs files.
# In the install session we create it but since we use
# the ghost macro (in files session) the files are not included
touch /var/log/vdsm/{mom.log,supervdsm.log,vdsm.log}
chmod 0644 /var/log/vdsm/{mom.log,supervdsm.log,vdsm.log}
chown vdsm:kvm /var/log/vdsm/{mom.log,vdsm.log}
chown root:root /var/log/vdsm/supervdsm.log

# Have moved vdsm section in /etc/sysctl.conf to /etc/sysctl.d/vdsm.conf.
# So Remove them if it is played with /etc/sysctl.conf.
if grep -q "# VDSM section begin" /etc/sysctl.conf; then
    /bin/sed -i '/# VDSM section begin/,/# VDSM section end/d' \
        /etc/sysctl.conf
fi

# VDSM installs vdsm-modules-load.d.conf file - the following command will
# refresh vdsm kernel modules requirements to start on boot
/bin/systemctl restart systemd-modules-load.service >/dev/null 2>&1 || :

# The following triggers vdsmd.preset file and enables vdsm required services
%systemd_post vdsmd.service
%systemd_post supervdsmd.service
%systemd_post vdsm-network.service
%systemd_post vdsm-network-init.service
%systemd_post mom-vdsm.service
%systemd_post ksmtuned.service

# VDSM installs unit files - daemon-reload will refresh systemd
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
exit 0

%preun
if [ "$1" -eq 0 ]; then
        %{_bindir}/vdsm-tool remove-config
fi
%systemd_preun vdsmd.service
%systemd_preun vdsm-network.service
%systemd_preun vdsm-network-init.service
%systemd_preun supervdsmd.service
%systemd_preun mom-vdsm.service
%systemd_preun ksmtuned.service
exit 0

%postun
if [ "$1" -ge 1 ]; then
    supervdsmd_start_required='no'
    vdsmd_start_required='no'

    # Both vdsm and supervdsm should be managed here and must be restarted if
    # ran before (code might changed)
    if %{_bindir}/vdsm-tool service-status vdsmd >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool service-stop vdsmd >/dev/null 2>&1 || :
        vdsmd_start_required='yes'
    fi
    if %{_bindir}/vdsm-tool service-status supervdsmd >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool service-stop supervdsmd >/dev/null 2>&1 || :
        supervdsmd_start_required='yes'
    fi

    if ! %{_bindir}/vdsm-tool is-configured >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool configure --force >/dev/null 2>&1
    fi

    if [ "${supervdsmd_start_required}" = 'yes' ]; then
        %{_bindir}/vdsm-tool service-start supervdsmd >/dev/null 2>&1 || :
    fi
    if [ "${vdsmd_start_required}" = 'yes' ]; then
        %{_bindir}/vdsm-tool service-start vdsmd >/dev/null 2>&1 || :
    fi

    # re-create tmp files, as some of them where delivered by
    # vdsm-4.18*.rpm but not in future version, and thus
    # removed when it is uninstalled.
    systemd-tmpfiles --create %{vdsm_name}.conf
fi
exit 0

%files
%doc README.md
%doc lib/vdsm/vdsm.conf.sample
%doc README.logging
%license COPYING
%{_libdir}/systemd/systemd-vdsmd
%{_presetdir}/85-vdsmd.preset
%{_unitdir}/vdsmd.service
%{_unitdir}/vdsm-network.service
%{_unitdir}/vdsm-network-init.service
%{_unitdir}/supervdsmd.service
%{_unitdir}/mom-vdsm.service
%{_sysconfdir}/systemd/system/libvirtd.service.d/unlimited-core.conf

%dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) /var/log/vdsm/mom.log
%ghost %config %attr(0644, root, root) /var/log/vdsm/supervdsm.log
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) /var/log/vdsm/vdsm.log
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/hsm-tasks
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/mnt
%dir %{_libexecdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}/vdsm.conf.d
%dir %{_sysconfdir}/modprobe.d/
%dir %{_sysconfdir}/NetworkManager
%dir %{_sysconfdir}/NetworkManager/conf.d
%dir %{_sysconfdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}/mom.d
%dir %{_datadir}/%{vdsm_name}
%dir %{_datadir}/%{vdsm_name}/storage
%dir %{_datadir}/%{vdsm_name}/storage/imageRepository
%dir %{_datadir}/%{vdsm_name}/virt
%dir %{_datadir}/%{vdsm_name}/virt/vmdevices
%{_datadir}/%{vdsm_name}/alignmentScan.py*
%{_datadir}/%{vdsm_name}/clientIF.py*
%{_datadir}/%{vdsm_name}/daemonAdapter
%{_datadir}/%{vdsm_name}/API.py*
%{_datadir}/%{vdsm_name}/hooking.py*
%{_datadir}/%{vdsm_name}/mk_sysprep_floppy
%{_datadir}/%{vdsm_name}/sitecustomize.py*
%{_datadir}/%{vdsm_name}/supervdsmServer
%{_datadir}/%{vdsm_name}/vdsm
%{_datadir}/%{vdsm_name}/vdsm-restore-net-config
%{_datadir}/%{vdsm_name}/vdsm-store-net-config
%{_datadir}/%{vdsm_name}/virt/__init__.py*
%{_datadir}/%{vdsm_name}/virt/domain_descriptor.py*
%{_datadir}/%{vdsm_name}/virt/recovery.py*
%{_datadir}/%{vdsm_name}/virt/vmtune.py*
%{_datadir}/%{vdsm_name}/virt/vm.py*
%{_datadir}/%{vdsm_name}/virt/vm_migrate_hook.py*
%{_datadir}/%{vdsm_name}/virt/vmxml.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/__init__.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/common.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/core.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/graphics.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/hostdevice.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/hwclass.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/lease.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/network.py*
%{_datadir}/%{vdsm_name}/virt/vmdevices/storage.py*

%config(noreplace) %{_sysconfdir}/%{vdsm_name}/vdsm.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/svdsm.logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.d/*.policy
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/logrotate/vdsm
%config(noreplace) %{_sysconfdir}/sysctl.d/vdsm.conf
%config(noreplace) %{_sysconfdir}/modules-load.d/vdsm.conf
%{_tmpfilesdir}/%{vdsm_name}.conf
%{_sysconfdir}/dhcp/dhclient.d/sourceRoute.sh
%{_sysconfdir}/modprobe.d/vdsm-bonding-modprobe.conf
%{_sysconfdir}/NetworkManager/conf.d/vdsm.conf
%{_sysconfdir}/sudoers.d/50_vdsm
%{_sysconfdir}/cron.hourly/vdsm-logrotate
%{_sysconfdir}/libvirt/hooks/qemu
%{_libexecdir}/%{vdsm_name}/curl-img-wrap
%{_libexecdir}/%{vdsm_name}/fc-scan
%{_libexecdir}/%{vdsm_name}/ovirt_functions.sh
%{_libexecdir}/%{vdsm_name}/vdsm-gencerts.sh
%{_libexecdir}/%{vdsm_name}/vdsmd_init_common.sh
%{_libexecdir}/%{vdsm_name}/vm_migrate_hook.py*
%{_libexecdir}/%{vdsm_name}/kvm2ovirt
%{_libexecdir}/%{vdsm_name}/wait_for_ipv4s
%{_datadir}/%{vdsm_name}/storage/__init__.py*
%{_datadir}/%{vdsm_name}/storage/blockSD.py*
%{_datadir}/%{vdsm_name}/storage/blockVolume.py*
%{_datadir}/%{vdsm_name}/storage/dispatcher.py*
%{_datadir}/%{vdsm_name}/storage/monitor.py*
%{_datadir}/%{vdsm_name}/storage/fileSD.py*
%{_datadir}/%{vdsm_name}/storage/fileVolume.py*
%{_datadir}/%{vdsm_name}/storage/glusterSD.py*
%{_datadir}/%{vdsm_name}/storage/glusterVolume.py*
%{_datadir}/%{vdsm_name}/storage/hsm.py*
%{_datadir}/%{vdsm_name}/storage/image.py*
%{_datadir}/%{vdsm_name}/storage/localFsSD.py*
%{_datadir}/%{vdsm_name}/storage/lvm.env
%{_datadir}/%{vdsm_name}/storage/lvm.py*
%{_datadir}/%{vdsm_name}/storage/merge.py*
%{_datadir}/%{vdsm_name}/storage/multipath.py*
%{_datadir}/%{vdsm_name}/storage/nfsSD.py*
%{_datadir}/%{vdsm_name}/storage/resourceFactories.py*
%{_datadir}/%{vdsm_name}/storage/resourceManager.py*
%{_datadir}/%{vdsm_name}/storage/sdc.py*
%{_datadir}/%{vdsm_name}/storage/sd.py*
%{_datadir}/%{vdsm_name}/storage/sp.py*
%{_datadir}/%{vdsm_name}/storage/spbackends.py*
%{_datadir}/%{vdsm_name}/storage/storage_mailbox.py*
%{_datadir}/%{vdsm_name}/storage/storageServer.py*
%{_datadir}/%{vdsm_name}/storage/taskManager.py*
%{_datadir}/%{vdsm_name}/storage/task.py*
%{_datadir}/%{vdsm_name}/storage/volume.py*
%{_datadir}/%{vdsm_name}/storage/imageRepository/__init__.py*
%{_datadir}/%{vdsm_name}/storage/imageRepository/formatConverter.py*
%{_datadir}/%{vdsm_name}/storage/sdm/__init__.py*
%{_datadir}/%{vdsm_name}/storage/sdm/volume_artifacts.py*
%{_datadir}/%{vdsm_name}/storage/sdm/volume_info.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/__init__.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/amend_volume.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/base.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/copy_data.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/move_device.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/reduce_domain.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/create_volume.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/merge.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/sparsify_volume.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/set_volume_generation.py*
%{_datadir}/%{vdsm_name}/storage/sdm/api/update_volume.py*
%{_libexecdir}/%{vdsm_name}/spmprotect.sh
%{_libexecdir}/%{vdsm_name}/spmstop.sh
%dir %{_libexecdir}/%{vdsm_name}/hooks
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_prepare
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vdsm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vdsm_stop
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_network_setup_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_set_num_of_cpus
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_set_num_of_cpus
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_memory_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_memory_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_all_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_all_vm_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_get_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_get_stats
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_hostdev_list_by_caps
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_ifcfg_write
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_ifcfg_write

%{_datadir}/%{vdsm_name}/get-conf-item
%{_datadir}/%{vdsm_name}/set-conf-item
%{python_sitelib}/sos/plugins/vdsm.py*
%{_udevrulesdir}/12-vdsm-lvm.rules
/etc/security/limits.d/99-vdsm.conf
%{_mandir}/man8/vdsmd.8*
%if 0%{?rhel}
%dir %{_localstatedir}/log/core
%endif
%{_polkitdir}/10-vdsm-libvirt-access.rules

%defattr(-, %{vdsm_user}, %{qemu_group}, -)
%dir %{_localstatedir}/lib/libvirt/qemu/channels

%defattr(-, %{vdsm_user}, %{vdsm_group}, -)
%dir %{_sysconfdir}/pki/%{vdsm_name}
%dir %{_sysconfdir}/pki/%{vdsm_name}/keys
%dir %{_sysconfdir}/pki/%{vdsm_name}/certs
%dir %{_sysconfdir}/pki/%{vdsm_name}/libvirt-spice
%config(noreplace) %{_sysconfdir}/pki/%{vdsm_name}/keys/libvirt_password
%dir %{_localstatedir}/lib/%{vdsm_name}
%dir %{_localstatedir}/lib/%{vdsm_name}/netconfback
%dir %{_localstatedir}/lib/%{vdsm_name}/persistence
%dir %{_localstatedir}/lib/%{vdsm_name}/upgrade
%dir %{_localstatedir}/run/%{vdsm_name}
%dir %{_localstatedir}/run/%{vdsm_name}/sourceRoutes
%dir %{_localstatedir}/run/%{vdsm_name}/trackedInterfaces
%ghost %dir %{_localstatedir}/run/%{vdsm_name}/payload
%dir %{_localstatedir}/run/%{vdsm_name}/v2v
%dir %{_localstatedir}/log/%{vdsm_name}
%dir %{_localstatedir}/log/%{vdsm_name}/backup
%dir %{_localstatedir}/log/%{vdsm_name}/import
%defattr(644, %{vdsm_user}, %{vdsm_group}, -)
%{_datadir}/%{vdsm_name}/lvmlocal.conf

%files python
%{_mandir}/man1/vdsm-tool.1*
%{_bindir}/vdsm-tool
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/common
%dir %{python_sitelib}/%{vdsm_name}/common/network
%dir %{python_sitelib}/%{vdsm_name}/gluster
%dir %{python_sitelib}/%{vdsm_name}/host
%dir %{python_sitelib}/%{vdsm_name}/network
%dir %{python_sitelib}/%{vdsm_name}/network/configurators
%dir %{python_sitelib}/%{vdsm_name}/network/ip
%dir %{python_sitelib}/%{vdsm_name}/network/link
%dir %{python_sitelib}/%{vdsm_name}/network/link/bond
%dir %{python_sitelib}/%{vdsm_name}/network/lldp
%dir %{python_sitelib}/%{vdsm_name}/network/lldpad
%dir %{python_sitelib}/%{vdsm_name}/network/netinfo
%dir %{python_sitelib}/%{vdsm_name}/network/netlink
%dir %{python_sitelib}/%{vdsm_name}/network/nm
%dir %{python_sitelib}/%{vdsm_name}/network/nm/nmdbus
%dir %{python_sitelib}/%{vdsm_name}/network/ovs
%dir %{python_sitelib}/%{vdsm_name}/network/ovs/driver
%dir %{python_sitelib}/%{vdsm_name}/network/tc
%dir %{python_sitelib}/%{vdsm_name}/metrics
%dir %{python_sitelib}/%{vdsm_name}/tool
%dir %{python_sitelib}/%{vdsm_name}/tool/configurators
%dir %{python_sitelib}/%{vdsm_name}/profiling
%dir %{python_sitelib}/%{vdsm_name}/storage
%dir %{python_sitelib}/%{vdsm_name}/supervdsm_api
%dir %{python_sitelib}/%{vdsm_name}/virt
%{python_sitelib}/%{vdsm_name}/__init__.py*
%{python_sitelib}/%{vdsm_name}/client.py*
%{python_sitelib}/%{vdsm_name}/cmdutils.py*
%{python_sitelib}/%{vdsm_name}/compat.py*
%{python_sitelib}/%{vdsm_name}/commands.py*
%{python_sitelib}/%{vdsm_name}/common/*.py*
%{python_sitelib}/%{vdsm_name}/host/*.py*
%{python_sitelib}/%{vdsm_name}/common/network/*.py*
%{python_sitelib}/%{vdsm_name}/concurrent.py*
%{python_sitelib}/%{vdsm_name}/config.py*
%{python_sitelib}/%{vdsm_name}/constants.py*
%{python_sitelib}/%{vdsm_name}/containersconnection.py*
%{python_sitelib}/%{vdsm_name}/cpuarch.py*
%{python_sitelib}/%{vdsm_name}/cpuinfo.py*
%{python_sitelib}/%{vdsm_name}/dsaversion.py*
%{python_sitelib}/%{vdsm_name}/dmidecodeUtil.py*
%{python_sitelib}/%{vdsm_name}/executor.py*
# gluster.exception is used in many places like Bridge.py. So it is required
# even without vdsm-gluster package
%{python_sitelib}/%{vdsm_name}/gluster/__init__.py*
%{python_sitelib}/%{vdsm_name}/gluster/cli.py*
%{python_sitelib}/%{vdsm_name}/gluster/exception.py*
%{python_sitelib}/%{vdsm_name}/health.py*
%{python_sitelib}/%{vdsm_name}/hooks.py*
%{python_sitelib}/%{vdsm_name}/hostdev.py*
%{python_sitelib}/%{vdsm_name}/jobs.py*
%{python_sitelib}/%{vdsm_name}/jsonrpcvdscli.py*
%{python_sitelib}/%{vdsm_name}/kaxmlrpclib.py*
%{python_sitelib}/%{vdsm_name}/kvm2ovirt.py*
%{python_sitelib}/%{vdsm_name}/libvirtconnection.py*
%{python_sitelib}/%{vdsm_name}/logUtils.py*
%{python_sitelib}/%{vdsm_name}/m2cutils.py*
%{python_sitelib}/%{vdsm_name}/machinetype.py*
%{python_sitelib}/%{vdsm_name}/metrics/*.py*
%{python_sitelib}/%{vdsm_name}/moduleloader.py*
%{python_sitelib}/%{vdsm_name}/momIF.py*
%{python_sitelib}/%{vdsm_name}/mkimage.py*
%{python_sitelib}/%{vdsm_name}/network/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/api.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/ifcfg.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/ifcfg_acquire.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/iproute2.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/pyroute_two.py*
%{python_sitelib}/%{vdsm_name}/network/configurators/qos.py*
%{python_sitelib}/%{vdsm_name}/network/errors.py*
%{python_sitelib}/%{vdsm_name}/network/canonicalize.py*
%{python_sitelib}/%{vdsm_name}/network/connectivity.py*
%{python_sitelib}/%{vdsm_name}/network/driverloader.py*
%{python_sitelib}/%{vdsm_name}/network/ip/*.py*
%{python_sitelib}/%{vdsm_name}/network/ifacquire.py*
%{python_sitelib}/%{vdsm_name}/network/initializer.py*
%{python_sitelib}/%{vdsm_name}/network/ipwrapper.py*
%{python_sitelib}/%{vdsm_name}/network/link/*.py*
%{python_sitelib}/%{vdsm_name}/network/link/bond/*.py*
%{python_sitelib}/%{vdsm_name}/network/lldp/*.py*
%{python_sitelib}/%{vdsm_name}/network/lldpad/*.py*
%{python_sitelib}/%{vdsm_name}/network/kernelconfig.py*
%{python_sitelib}/%{vdsm_name}/network/legacy_switch.py*
%{python_sitelib}/%{vdsm_name}/network/libvirt.py*
%{python_sitelib}/%{vdsm_name}/network/netinfo/*.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/addr.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/link.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/monitor.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/route.py*
%{python_sitelib}/%{vdsm_name}/network/netlink/waitfor.py*
%{python_sitelib}/%{vdsm_name}/network/nm/*.py*
%{python_sitelib}/%{vdsm_name}/network/nm/nmdbus/*.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/info.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/switch.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/validator.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/driver/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/ovs/driver/vsctl.py*
%{python_sitelib}/%{vdsm_name}/network/models.py*
%{python_sitelib}/%{vdsm_name}/network/netconfpersistence.py*
%{python_sitelib}/%{vdsm_name}/network/netrestore.py*
%{python_sitelib}/%{vdsm_name}/network/netswitch.py*
%{python_sitelib}/%{vdsm_name}/network/sourceroute.py*
%{python_sitelib}/%{vdsm_name}/network/sourceroutethread.py*
%{python_sitelib}/%{vdsm_name}/network/tc/__init__.py*
%{python_sitelib}/%{vdsm_name}/network/tc/_parser.py*
%{python_sitelib}/%{vdsm_name}/network/tc/_wrapper.py*
%{python_sitelib}/%{vdsm_name}/network/tc/cls.py*
%{python_sitelib}/%{vdsm_name}/network/tc/filter.py*
%{python_sitelib}/%{vdsm_name}/network/tc/qdisc.py*
%{python_sitelib}/%{vdsm_name}/network/utils.py*
%{python_sitelib}/%{vdsm_name}/numa.py*
%{python_sitelib}/%{vdsm_name}/osinfo.py*
%{python_sitelib}/%{vdsm_name}/password.py*
%{python_sitelib}/%{vdsm_name}/panic.py*
%{python_sitelib}/%{vdsm_name}/ppc64HardwareInfo.py*
%{python_sitelib}/%{vdsm_name}/profiling/__init__.py*
%{python_sitelib}/%{vdsm_name}/profiling/cpu.py*
%{python_sitelib}/%{vdsm_name}/profiling/errors.py*
%{python_sitelib}/%{vdsm_name}/profiling/memory.py*
%{python_sitelib}/%{vdsm_name}/profiling/profile.py*
%{python_sitelib}/%{vdsm_name}/storage/__init__.py*
%{python_sitelib}/%{vdsm_name}/storage/asyncevent.py*
%{python_sitelib}/%{vdsm_name}/storage/asyncutils.py*
%{python_sitelib}/%{vdsm_name}/storage/blkdiscard.py*
%{python_sitelib}/%{vdsm_name}/storage/check.py*
%{python_sitelib}/%{vdsm_name}/storage/clusterlock.py*
%{python_sitelib}/%{vdsm_name}/storage/constants.py*
%{python_sitelib}/%{vdsm_name}/storage/curlImgWrap.py*
%{python_sitelib}/%{vdsm_name}/storage/devicemapper.py*
%{python_sitelib}/%{vdsm_name}/storage/directio.py*
%{python_sitelib}/%{vdsm_name}/storage/exception.py*
%{python_sitelib}/%{vdsm_name}/storage/fileUtils.py*
%{python_sitelib}/%{vdsm_name}/storage/fuser.py*
%{python_sitelib}/%{vdsm_name}/storage/guarded.py*
%{python_sitelib}/%{vdsm_name}/storage/hba.py*
%{python_sitelib}/%{vdsm_name}/storage/imageSharing.py*
%{python_sitelib}/%{vdsm_name}/storage/imagetickets.py*
%{python_sitelib}/%{vdsm_name}/storage/iscsi.py*
%{python_sitelib}/%{vdsm_name}/storage/iscsiadm.py*
%{python_sitelib}/%{vdsm_name}/storage/lvmconf.py*
%{python_sitelib}/%{vdsm_name}/storage/lvmfilter.py*
%{python_sitelib}/%{vdsm_name}/storage/misc.py*
%{python_sitelib}/%{vdsm_name}/storage/mount.py*
%{python_sitelib}/%{vdsm_name}/storage/outOfProcess.py*
%{python_sitelib}/%{vdsm_name}/storage/persistent.py*
%{python_sitelib}/%{vdsm_name}/storage/qcow2.py*
%{python_sitelib}/%{vdsm_name}/storage/rwlock.py*
%{python_sitelib}/%{vdsm_name}/storage/securable.py*
%{python_sitelib}/%{vdsm_name}/storage/threadPool.py*
%{python_sitelib}/%{vdsm_name}/storage/types.py*
%{python_sitelib}/%{vdsm_name}/storage/volumemetadata.py*
%{python_sitelib}/%{vdsm_name}/storage/workarounds.py*
%{python_sitelib}/%{vdsm_name}/storage/xlease.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/__init__.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/hwinfo.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/mkimage.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/ksm.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/network.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/systemd.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/test.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/udev.py*
%{python_sitelib}/%{vdsm_name}/supervdsm_api/virt.py*
%{python_sitelib}/%{vdsm_name}/properties.py*
%{python_sitelib}/%{vdsm_name}/protocoldetector.py*
%{python_sitelib}/%{vdsm_name}/pthread.py*
%{python_sitelib}/%{vdsm_name}/qemuimg.py*
%{python_sitelib}/%{vdsm_name}/schedule.py*
%{python_sitelib}/%{vdsm_name}/sslcompat.py*
%{python_sitelib}/%{vdsm_name}/sslutils.py*
%{python_sitelib}/%{vdsm_name}/supervdsm.py*
%{python_sitelib}/%{vdsm_name}/sysctl.py*
%{python_sitelib}/%{vdsm_name}/taskset.py*
%{python_sitelib}/%{vdsm_name}/throttledlog.py*
%{python_sitelib}/%{vdsm_name}/udevadm.py*
%{python_sitelib}/%{vdsm_name}/utils.py*
%{python_sitelib}/%{vdsm_name}/v2v.py*
%{python_sitelib}/%{vdsm_name}/vdscli.py*
%{python_sitelib}/%{vdsm_name}/virtsparsify.py*
%{python_sitelib}/%{vdsm_name}/virtsysprep.py*
%{python_sitelib}/%{vdsm_name}/xmlrpc.py*
%{python_sitelib}/%{vdsm_name}/tool/__init__.py*
%{python_sitelib}/%{vdsm_name}/tool/config_lvm_filter.py*
%{python_sitelib}/%{vdsm_name}/tool/configfile.py*
%{python_sitelib}/%{vdsm_name}/tool/confmeta.py*
%{python_sitelib}/%{vdsm_name}/tool/confutils.py*
%{python_sitelib}/%{vdsm_name}/tool/dummybr.py*
%{python_sitelib}/%{vdsm_name}/tool/dump_bonding_opts.py*
%{python_sitelib}/%{vdsm_name}/tool/nwfilter.py*
%{python_sitelib}/%{vdsm_name}/tool/configurator.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/__init__*
%{python_sitelib}/%{vdsm_name}/tool/configurators/abrt.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/certificates.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/libvirt.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/lvm.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/passwd.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/sanlock.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/sebool.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/multipath.py*
%{python_sitelib}/%{vdsm_name}/tool/configurators/bond_defaults.py*
%{python_sitelib}/%{vdsm_name}/tool/dump_volume_chains.py*
%{python_sitelib}/%{vdsm_name}/tool/network.py*
%{python_sitelib}/%{vdsm_name}/tool/register.py*
%{python_sitelib}/%{vdsm_name}/tool/restore_nets.py*
%{python_sitelib}/%{vdsm_name}/tool/service.py*
%{python_sitelib}/%{vdsm_name}/tool/transient.py*
%{python_sitelib}/%{vdsm_name}/tool/unified_persistence.py*
%{python_sitelib}/%{vdsm_name}/tool/upgrade.py*
%{python_sitelib}/%{vdsm_name}/tool/vdsm-id.py*
%{python_sitelib}/%{vdsm_name}/virt/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/guestagent.py*
%{python_sitelib}/%{vdsm_name}/virt/migration.py*
%{python_sitelib}/%{vdsm_name}/virt/periodic.py*
%{python_sitelib}/%{vdsm_name}/virt/sampling.py*
%{python_sitelib}/%{vdsm_name}/virt/secret.py*
%{python_sitelib}/%{vdsm_name}/virt/utils.py*
%{python_sitelib}/%{vdsm_name}/virt/virdomain.py*
%{python_sitelib}/%{vdsm_name}/virt/jobs/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/jobs/seal.py*
%{python_sitelib}/%{vdsm_name}/virt/vmchannels.py*
%{python_sitelib}/%{vdsm_name}/virt/vmexitreason.py*
%{python_sitelib}/%{vdsm_name}/virt/vmpowerdown.py*
%{python_sitelib}/%{vdsm_name}/virt/vmstats.py*
%{python_sitelib}/%{vdsm_name}/virt/vmstatus.py*
%{python_sitelib}/%{vdsm_name}/virt/xmlconstants.py*

%files tests
%doc %{_datadir}/%{vdsm_name}/tests/README
%dir %{_datadir}/%{vdsm_name}
%dir %{_datadir}/%{vdsm_name}/tests
%dir %{_datadir}/%{vdsm_name}/tests/common
%if 0%{?with_containers}
%dir %{_datadir}/%{vdsm_name}/tests/containers
%dir %{_datadir}/%{vdsm_name}/tests/containers/data
%dir %{_datadir}/%{vdsm_name}/tests/containers/fake
%dir %{_datadir}/%{vdsm_name}/tests/containers/fake/bin
%endif
%dir %{_datadir}/%{vdsm_name}/tests/cpuinfo
%dir %{_datadir}/%{vdsm_name}/tests/functional
%dir %{_datadir}/%{vdsm_name}/tests/devices
%dir %{_datadir}/%{vdsm_name}/tests/devices/data
%dir %{_datadir}/%{vdsm_name}/tests/devices/parsing
%dir %{_datadir}/%{vdsm_name}/tests/integration
%dir %{_datadir}/%{vdsm_name}/tests/network
%dir %{_datadir}/%{vdsm_name}/tests/network/static
%{_datadir}/%{vdsm_name}/tests/*.py*
%{_datadir}/%{vdsm_name}/tests/cpu_info.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E5649.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_amd_6274.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_ibm_S822L.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_ibm_S822L_le.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E31220.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E5606.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_i73770.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_i73770_nosnap.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_multiqemu.out
%{_datadir}/%{vdsm_name}/tests/caps_numactl_4_nodes.out
%{_datadir}/%{vdsm_name}/tests/common/*.py*
%if 0%{?with_containers}
%{_datadir}/%{vdsm_name}/tests/containers/*.py*
%{_datadir}/%{vdsm_name}/tests/containers/data/*.txt
%{_datadir}/%{vdsm_name}/tests/containers/data/*.xml
%{_datadir}/%{vdsm_name}/tests/containers/fake/bin/*
%{_datadir}/%{vdsm_name}/tests/containers/fake/cgroups.tgz
%endif
%{_datadir}/%{vdsm_name}/tests/cpuinfo/*.out
%{_datadir}/%{vdsm_name}/tests/fake-ssh-add
%{_datadir}/%{vdsm_name}/tests/fake-ssh-agent
%{_datadir}/%{vdsm_name}/tests/fake-virt-sysprep
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v.out
%{_datadir}/%{vdsm_name}/tests/fake-virt-v2v.err
%{_datadir}/%{vdsm_name}/tests/cpu_map.xml
%{_datadir}/%{vdsm_name}/tests/devices/*.py*
%{_datadir}/%{vdsm_name}/tests/devices/parsing/*.py*
%{_datadir}/%{vdsm_name}/tests/devices/data/*.xml
%{_datadir}/%{vdsm_name}/tests/iscsiadm_-m_iface.out
%{_datadir}/%{vdsm_name}/tests/lvs_3386c6f2-926f-42c4-839c-38287fac8998.out
%{_datadir}/%{vdsm_name}/tests/lvs_f9e55e18-67c4-4377-8e39-5833ca422bef.out
%{_datadir}/%{vdsm_name}/tests/mem_info.out
%{_datadir}/%{vdsm_name}/tests/network/*.py*
%{_datadir}/%{vdsm_name}/tests/network/ip_route_show_table_all.out
%{_datadir}/%{vdsm_name}/tests/network/netmaskconversions
%{_datadir}/%{vdsm_name}/tests/network/tc_filter_show.out
%{_datadir}/%{vdsm_name}/tests/network/static/*.json
%{_datadir}/%{vdsm_name}/tests/run_tests.sh
%{_datadir}/%{vdsm_name}/tests/toolTests_abrt-action-save-package-data.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_abrt.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_CCPP.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vmcore.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_empty.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_lconf_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_libvirtd.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_qemu_sanlock.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_qemu_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vdsm_no_ssl.conf
%{_datadir}/%{vdsm_name}/tests/toolTests_vdsm_ssl.conf
%{_datadir}/%{vdsm_name}/tests/glusterGeoRepStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeGeoRepConfigList.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotList.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotListEmpty.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfo.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotConfig.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfoNfs.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRebalanceStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRemoveBricksStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterSnapshotRestore.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeSnapshotList.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeSnapshotListEmpty.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeTasks.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeHealInfo.xml
%{_datadir}/%{vdsm_name}/tests/functional/*.py*
%{_datadir}/%{vdsm_name}/tests/functional/*.policy
%{_datadir}/%{vdsm_name}/tests/integration/*.py*

%files hook-openstacknet
%{_sysconfdir}/sudoers.d/50_vdsm_hook_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/openstacknet_utils.py*

%files hook-macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_macspoof

%if 0%{?with_vhostmd}
%files hook-vhostmd
%license COPYING
%{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%else
%exclude %{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%endif

%files hook-qemucmdline
%license COPYING
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_qemucmdline

%files hook-ethtool-options
%{_libexecdir}/%{vdsm_name}/hooks/after_network_setup/30_ethtool_options

%files hook-ipv6
%{_libexecdir}/%{vdsm_name}/hooks/before_network_setup/50_ipv6

%files hook-localdisk
%{_sysconfdir}/sudoers.d/50_vdsm_hook_localdisk
%{_libexecdir}/%{vdsm_name}/hooks/after_disk_prepare/localdisk
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/localdisk
%{_libexecdir}/%{vdsm_name}/localdisk-helper
%{_udevrulesdir}/12-vdsm-localdisk.rules

%files hook-vmfex-dev
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_vmfex

%files hook-vfio-mdev
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vfio_mdev
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vfio_mdev

%if 0%{?with_hooks}
%files hook-allocate_net
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/10_allocate_net

%files hook-checkimages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/60_checkimages

%files hook-fcoe
%{_presetdir}/85-vdsm-hook-fcoe.preset
%{_libexecdir}/%{vdsm_name}/hooks/before_network_setup/50_fcoe

%files hook-checkips
%{_libexecdir}/%{vdsm_name}/hooks/after_get_stats/10_checkips
%{_libexecdir}/%{vdsm_name}/hooks/checkipsd
%{_libexecdir}/%{vdsm_name}/hooks/after_get_stats/checkips_utils.py*
%{_unitdir}/vdsm-checkips.service

%files hook-extra-ipv4-addrs
%{_libexecdir}/%{vdsm_name}/hooks/after_network_setup/40_extra_ipv4_addrs

%files hook-diskunmap
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_diskunmap

%files hook-fakevmstats
%{_libexecdir}/%{vdsm_name}/hooks/after_get_all_vm_stats/10_fakevmstats

%files hook-fakesriov
%{_libexecdir}/%{vdsm_name}/hooks/after_hostdev_list_by_caps/10_fakesriov
%{_libexecdir}/%{vdsm_name}/hooks/after_get_caps/10_fakesriov

%files hook-fileinject
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_fileinject

%files hook-floppy
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_floppy
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_floppy

%files hook-hostusb
%{_sysconfdir}/sudoers.d/50_vdsm_hook_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_hostusb

%files hook-httpsisoboot
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_httpsisoboot

%files hook-hugepages
%{_sysconfdir}/sudoers.d/50_vdsm_hook_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_hugepages

%files hook-isolatedprivatevlan
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_isolatedprivatevlan
%config(noreplace) %{_sysconfdir}/libvirt/nwfilter/isolatedprivatevlan-vdsm.xml

%files hook-macbind
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_macbind

%files hook-noipspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_noipspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_noipspoof

%files hook-extnet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_extnet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_extnet

%files hook-nestedvt
%{_sysconfdir}/modprobe.d/vdsm-nestedvt.conf
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_nestedvt

%files hook-numa
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_numa

%files hook-pincpu
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_pincpu

%files hook-promisc
%{_sysconfdir}/sudoers.d/50_vdsm_hook_promisc
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/50_promisc
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy/50_promisc

%files hook-qos
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_qos

%files hook-scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_scratchpad

%files hook-smbios
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_smbios

%files hook-spiceoptions
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_spiceoptions

%files hook-vmdisk
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vmdisk

%files hook-vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vmfex
%endif

%files cli
%license COPYING
%{_bindir}/vdsClient
%dir %{_datadir}/%{vdsm_name}
%{_datadir}/%{vdsm_name}/vdsClient.py*
%{_datadir}/%{vdsm_name}/vdsClientGluster.py*
%{_sysconfdir}/bash_completion.d/vdsClient
%{_mandir}/man1/vdsClient.1*

%files xmlrpc
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/rpc/bindingxmlrpc.py*

%files client
%{_bindir}/vdsm-client
%dir %{python_sitelib}/vdsmclient
%{python_sitelib}/vdsmclient/__init__.py*
%{python_sitelib}/vdsmclient/client.py*
%{python_sitelib}/yajsonrpc/__init__.py*
%{_mandir}/man1/vdsm-client.1*

%files jsonrpc
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/rpc/__init__.py*
%{python_sitelib}/%{vdsm_name}/rpc/bindingjsonrpc.py*
%{python_sitelib}/%{vdsm_name}/rpc/Bridge.py*
%{python_sitelib}/yajsonrpc/__init__.py*

%files api
%doc lib/vdsm/api/vdsm-api.html
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/api
%dir %{python_sitelib}/%{vdsm_name}/rpc
%{python_sitelib}/%{vdsm_name}/api/*.py*
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-api.yml
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-events.yml
%if ! 0%{?with_gluster_mgmt}
%exclude %{python_sitelib}/%{vdsm_name}/rpc/vdsm-api-gluster.yml
%endif

%files yajsonrpc
%dir %{python_sitelib}/yajsonrpc
%{python_sitelib}/yajsonrpc/betterAsyncore.py*
%{python_sitelib}/yajsonrpc/stomp.py*
%{python_sitelib}/yajsonrpc/stompreactor.py*

%files hook-faqemu
%license COPYING
%{_libexecdir}/%{vdsm_name}/hooks/after_get_caps/10_faqemu
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/10_faqemu

%if 0%{?with_gluster_mgmt}
%files gluster
%license COPYING
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/rpc
%dir %{python_sitelib}/%{vdsm_name}/gluster
%{python_sitelib}/%{vdsm_name}/gluster/api.py*
%{python_sitelib}/%{vdsm_name}/gluster/apiwrapper.py*
%{python_sitelib}/%{vdsm_name}/gluster/fstab.py*
%{python_sitelib}/%{vdsm_name}/gluster/fence.py*
%{python_sitelib}/%{vdsm_name}/gluster/gfapi.py*
%{python_sitelib}/%{vdsm_name}/gluster/hooks.py*
%{python_sitelib}/%{vdsm_name}/gluster/services.py*
%{python_sitelib}/%{vdsm_name}/gluster/storagedev.py*
%{python_sitelib}/%{vdsm_name}/gluster/tasks.py*
%{python_sitelib}/%{vdsm_name}/rpc/vdsm-api-gluster.yml
%endif

%if 0%{?with_containers}
%files containers
%defattr(-, root, root, -)
%dir %{_datadir}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}
%dir %{python_sitelib}/%{vdsm_name}/virt/containers
%{python_sitelib}/%{vdsm_name}/supervdsm_api/containers.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/__init__.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/cgroups.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/command.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/connection.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/docker.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/domain.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/doms.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/errors.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/events.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/monitoring.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/runner.py*
%{python_sitelib}/%{vdsm_name}/virt/containers/xmlfile.py*
%endif


%changelog
* Wed Aug 03 2016 Yaniv Bronhaim <ybronhei@redhat.com> - 4.18.999
- Re-review of vdsm.spec to return it to fedora Bug #1361659

* Sun Oct 13 2013 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.0
- Removing vdsm-python-cpopen from the spec
- Adding dependency on formal cpopen package

* Sun Apr 07 2013 Yaniv Bronhaim <ybronhei@redhat.com> - 4.9.0-1
- Adding cpopen package

* Wed Oct 12 2011 Federico Simoncelli <fsimonce@redhat.com> - 4.9.0-0
- Initial upstream release

* Thu Nov 02 2006 Simon Grinberg <simong@qumranet.com> -  0.0-1
- Initial build
