#!/bin/sh

command -v getarg > /dev/null || . /lib/dracut-lib.sh

[ -z "$root" ] && root=$(getarg root=)

[ "${root%%:*}" = "nbd" ] || exit 0

GENERATOR_DIR="$2"
[ -z "$GENERATOR_DIR" ] && exit 1

[ -d "$GENERATOR_DIR" ] || mkdir -p "$GENERATOR_DIR"

ROOTFLAGS="$(getarg rootflags)"

nroot=${root#nbd:}
nbdserver=${nroot%%:*}
if [ "${nbdserver%"${nbdserver#?}"}" = "[" ]; then
    nbdserver=${nroot#[}
    nbdserver=${nbdserver%%]:*}\]
    nroot=${nroot#*]:}
else
    nroot=${nroot#*:}
fi
nbdport=${nroot%%:*}
nroot=${nroot#*:}
nbdfstype=${nroot%%:*}
nroot=${nroot#*:}
nbdflags=${nroot%%:*}

if [ "$nbdflags" = "$nbdfstype" ]; then
    unset nbdflags
fi
if [ "$nbdfstype" = "$nbdport" ]; then
    unset nbdfstype
fi

[ -n "$nbdflags" ] && ROOTFLAGS="$nbdflags"

if getarg "ro"; then
    if [ -n "$ROOTFLAGS" ]; then
        ROOTFLAGS="$ROOTFLAGS,ro"
    else
        ROOTFLAGS="ro"
    fi
fi

if [ -n "$nbdfstype" ]; then
    ROOTFSTYPE="$nbdfstype"
else
    ROOTFSTYPE=$(getarg rootfstype=) || unset ROOTFSTYPE
fi

{
    echo "[Unit]"
    echo "Before=initrd-root-fs.target"
    echo "[Mount]"
    echo "Where=/sysroot"
    echo "What=/dev/root"
    [ -n "$ROOTFSTYPE" ] && echo "Type=${ROOTFSTYPE}"
    [ -n "$ROOTFLAGS" ] && echo "Options=${ROOTFLAGS}"
} > "$GENERATOR_DIR"/sysroot.mount

exit 0
