\name{AcosImageFilter}
\alias{AcosImageFilter}
\title{AcosImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the inverse cosine of each pixel.
AcosImageFilter}
\details{
This filter is templated over the pixel type of the input image and
the pixel type of the output image.
The filter walks over all the pixels in the input image, and for each
pixel does do the following:
cast the pixel value to double ,
apply the std::acos() function to the double value
cast the double value resulting from std::acos() to the pixel type of
the output image
store the casted value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND).
See:
Acos for the procedural interface
itk::AcosImageFilter for the Doxygen on the original ITK class.
AcosImageFilter}
%C++ includes: sitkAcosImageFilter.h
\section{Methods}{
\describe{
\item{ AcosImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~AcosImageFilter():}{
Destructor
}
}
}
