/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import com.esotericsoftware.kryo.io.Input;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.serialize.ParallelStringDecoder;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.graph.StringDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u0017B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringDecoder;", "Lorg/gradle/internal/serialize/graph/StringDecoder;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "stream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "strings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "reader", "Ljava/lang/Thread;", "readNullableString", "", "decoder", "Lorg/gradle/internal/serialize/Decoder;", "readString", "doReadString", "id", "close", "", "FutureString", "configuration-cache"})
public final class ParallelStringDecoder
implements StringDecoder,
AutoCloseable {
    @NotNull
    private final ConcurrentHashMap<Integer, Object> strings;
    @NotNull
    private final Thread reader;

    public ParallelStringDecoder(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.strings = new ConcurrentHashMap();
        this.reader = ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, () -> ParallelStringDecoder.reader$lambda$0(stream, this), (int)29, null);
    }

    @Nullable
    public String readNullableString(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        int id2 = decoder.readSmallInt();
        return id2 == 0 ? null : this.doReadString(id2);
    }

    @NotNull
    public String readString(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return this.doReadString(decoder.readSmallInt());
    }

    private final String doReadString(int id2) {
        String string;
        if (id2 == 1) {
            string = "";
        } else {
            Object object = this.strings.computeIfAbsent(id2, doReadString.stringOrFutureString.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
            Object stringOrFutureString2 = object;
            if (stringOrFutureString2 instanceof String) {
                string = (String)stringOrFutureString2;
            } else if (stringOrFutureString2 instanceof FutureString) {
                string = ((FutureString)stringOrFutureString2).get();
            } else {
                throw new IllegalStateException((stringOrFutureString2 + " is unexpected").toString());
            }
        }
        return string;
    }

    @Override
    public void close() {
        this.reader.join(TimeUnit.MINUTES.toMillis(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit reader$lambda$0(InputStream $stream, ParallelStringDecoder this$0) {
        Closeable closeable = (Closeable)new Input($stream);
        Throwable throwable = null;
        try {
            Input input = (Input)closeable;
            boolean bl = false;
            int nextId = 2;
            while (true) {
                String string = input.readString();
                Intrinsics.checkNotNull((Object)string);
                if (((CharSequence)string).length() == 0) break;
                this$0.strings.compute(nextId++, new BiFunction(string){
                    final /* synthetic */ String $string;
                    {
                        this.$string = $string;
                    }

                    public final Object apply(Integer n, Object value) {
                        Intrinsics.checkNotNullParameter((Object)n, (String)"<unused var>");
                        if (value instanceof FutureString) {
                            FutureString futureString = (FutureString)value;
                            String string = this.$string;
                            Intrinsics.checkNotNull((Object)string);
                            futureString.complete(string);
                        } else if (!(value == null)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        return this.$string;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringDecoder$FutureString;", "", "<init>", "()V", "latch", "Ljava/util/concurrent/CountDownLatch;", "string", "", "complete", "", "s", "get", "configuration-cache"})
    private static final class FutureString {
        @NotNull
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private String string;

        public final void complete(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.string = s;
            this.latch.countDown();
        }

        @NotNull
        public final String get() {
            if (!this.latch.await(1L, TimeUnit.MINUTES)) {
                throw new TimeoutException("Timeout while waiting for string");
            }
            String string = this.string;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
    }
}

