/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.RankFeatureFunction;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RankFeatureFunctionSigmoid
extends RankFeatureFunction
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RankFeatureFunctionSigmoid> {
    private final float exponent;
    private final float pivot;
    public static final JsonpDeserializer<RankFeatureFunctionSigmoid> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureFunctionSigmoid::setupRankFeatureFunctionSigmoidDeserializer);

    private RankFeatureFunctionSigmoid(Builder builder) {
        super(builder);
        this.exponent = ApiTypeHelper.requireNonNull(builder.exponent, this, "exponent").floatValue();
        this.pivot = ApiTypeHelper.requireNonNull(builder.pivot, this, "pivot").floatValue();
    }

    public static RankFeatureFunctionSigmoid of(Function<Builder, ObjectBuilder<RankFeatureFunctionSigmoid>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final float exponent() {
        return this.exponent;
    }

    public final float pivot() {
        return this.pivot;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("exponent");
        generator.write((double)this.exponent);
        generator.writeKey("pivot");
        generator.write((double)this.pivot);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRankFeatureFunctionSigmoidDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::exponent, JsonpDeserializer.floatDeserializer(), "exponent");
        op.add(Builder::pivot, JsonpDeserializer.floatDeserializer(), "pivot");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Float.hashCode(this.exponent);
        result = 31 * result + Float.hashCode(this.pivot);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankFeatureFunctionSigmoid other = (RankFeatureFunctionSigmoid)o;
        return this.exponent == other.exponent && this.pivot == other.pivot;
    }

    public static class Builder
    extends RankFeatureFunction.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RankFeatureFunctionSigmoid> {
        private Float exponent;
        private Float pivot;

        public Builder() {
        }

        private Builder(RankFeatureFunctionSigmoid o) {
            super(o);
            this.exponent = Float.valueOf(o.exponent);
            this.pivot = Float.valueOf(o.pivot);
        }

        private Builder(Builder o) {
            super(o);
            this.exponent = o.exponent;
            this.pivot = o.pivot;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder exponent(float value) {
            this.exponent = Float.valueOf(value);
            return this;
        }

        @Nonnull
        public final Builder pivot(float value) {
            this.pivot = Float.valueOf(value);
            return this;
        }

        @Override
        @Nonnull
        public RankFeatureFunctionSigmoid build() {
            this._checkSingleUse();
            return new RankFeatureFunctionSigmoid(this);
        }
    }
}

