/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Scenario;
import java.util.Objects;
import java.util.Optional;

public final class RuleChild {
    private final Background background;
    private final Scenario scenario;

    public static RuleChild of(Background background) {
        return new RuleChild(Objects.requireNonNull(background, "RuleChild.background cannot be null"), null);
    }

    public static RuleChild of(Scenario scenario) {
        return new RuleChild(null, Objects.requireNonNull(scenario, "RuleChild.scenario cannot be null"));
    }

    public RuleChild(Background background, Scenario scenario) {
        this.background = background;
        this.scenario = scenario;
    }

    public Optional<Background> getBackground() {
        return Optional.ofNullable(this.background);
    }

    public Optional<Scenario> getScenario() {
        return Optional.ofNullable(this.scenario);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleChild that = (RuleChild)o;
        return Objects.equals(this.background, that.background) && Objects.equals(this.scenario, that.scenario);
    }

    public int hashCode() {
        return Objects.hash(this.background, this.scenario);
    }

    public String toString() {
        return "RuleChild{background=" + this.background + ", scenario=" + this.scenario + '}';
    }
}

