/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Unit;

public abstract class Distance {
    private static final double EARTH_RADIUS_M = 6372795.0;

    public static double convertRadiansToDistance(double d, Unit unit) {
        return d * 6372795.0 * unit.getMultFactorFromStd();
    }

    public static double convertDistanceToRadians(double d, Unit unit) {
        return d / 6372795.0 / unit.getMultFactorFromStd();
    }

    public static double convertBetweenUnits(double d, Unit unit, Unit unit2) {
        return d / unit.getMultFactorFromStd() * unit2.getMultFactorFromStd();
    }

    public static double calculateRadiansBetween(double d, double d2, double d3, double d4) {
        double d5 = d * (Math.PI / 180);
        double d6 = d3 * (Math.PI / 180);
        double d7 = d2 * (Math.PI / 180);
        double d8 = d4 * (Math.PI / 180);
        double d9 = Math.sin((d6 - d5) / 2.0);
        double d10 = Math.sin((d8 - d7) / 2.0);
        double d11 = Math.cos(d5) * Math.cos(d6) * d10 * d10;
        double d12 = 2.0 * Math.asin(Math.sqrt(d9 * d9 + d11));
        return d12;
    }
}

