/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.InjectionFactory;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Automating;
import org.picocontainer.behaviors.Behaviors;
import org.picocontainer.behaviors.Locking;
import org.picocontainer.behaviors.PropertyApplying;
import org.picocontainer.behaviors.Synchronizing;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.containers.TransientPicoContainer;
import org.picocontainer.injectors.CompositeInjection;
import org.picocontainer.injectors.Injectors;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.ConsoleComponentMonitor;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoBuilder {
    private PicoContainer parentContainer;
    private Class<? extends MutablePicoContainer> mpcClass = DefaultPicoContainer.class;
    private ComponentMonitor componentMonitor;
    private List<Object> containerComps = new ArrayList<Object>();
    private boolean addChildToParent;
    private LifecycleStrategy lifecycleStrategy;
    private final Stack<Object> behaviors = new Stack();
    private final List<InjectionFactory> injectors = new ArrayList<InjectionFactory>();
    private Class<? extends ComponentMonitor> componentMonitorClass = NullComponentMonitor.class;
    private Class<? extends LifecycleStrategy> lifecycleStrategyClass = NullLifecycleStrategy.class;

    public PicoBuilder(PicoContainer parentContainer, InjectionFactory injectionType) {
        this(parentContainer);
        this.addInjector(injectionType);
    }

    public PicoBuilder(PicoContainer parentContainer) {
        this.parentContainer = parentContainer != null ? parentContainer : new EmptyPicoContainer();
    }

    public PicoBuilder(InjectionFactory injectionType) {
        this(new EmptyPicoContainer(), injectionType);
    }

    public PicoBuilder() {
        this(new EmptyPicoContainer());
    }

    public PicoBuilder withLifecycle() {
        this.lifecycleStrategyClass = StartableLifecycleStrategy.class;
        this.lifecycleStrategy = null;
        return this;
    }

    public PicoBuilder withReflectionLifecycle() {
        this.lifecycleStrategyClass = ReflectionLifecycleStrategy.class;
        this.lifecycleStrategy = null;
        return this;
    }

    public PicoBuilder withLifecycle(Class<? extends LifecycleStrategy> specifiedLifecycleStrategyType) {
        this.lifecycleStrategyClass = specifiedLifecycleStrategyType;
        this.lifecycleStrategy = null;
        return this;
    }

    public PicoBuilder withJavaEE5Lifecycle() {
        this.lifecycleStrategyClass = JavaEE5LifecycleStrategy.class;
        this.lifecycleStrategy = null;
        return this;
    }

    public PicoBuilder withLifecycle(LifecycleStrategy specifiedLifecycleStrategy) {
        this.lifecycleStrategy = specifiedLifecycleStrategy;
        this.lifecycleStrategyClass = null;
        return this;
    }

    public PicoBuilder withConsoleMonitor() {
        this.componentMonitorClass = ConsoleComponentMonitor.class;
        return this;
    }

    public PicoBuilder withMonitor(Class<? extends ComponentMonitor> cmClass) {
        if (cmClass == null) {
            throw new NullPointerException("monitor class cannot be null");
        }
        if (!ComponentMonitor.class.isAssignableFrom(cmClass)) {
            throw new ClassCastException(cmClass.getName() + " is not a " + ComponentMonitor.class.getName());
        }
        this.componentMonitorClass = cmClass;
        this.componentMonitor = null;
        return this;
    }

    public MutablePicoContainer build() {
        TransientPicoContainer tempContainer = new TransientPicoContainer();
        tempContainer.addComponent(PicoContainer.class, this.parentContainer, new Parameter[0]);
        this.addContainerComponents(tempContainer);
        ComponentFactory componentFactory = this.injectors.size() == 1 ? (ComponentFactory)this.injectors.get(0) : (this.injectors.size() == 0 ? Injectors.adaptiveDI() : new CompositeInjection(this.injectors.toArray(new InjectionFactory[this.injectors.size()])));
        Stack clonedBehaviors = (Stack)this.behaviors.clone();
        while (!clonedBehaviors.empty()) {
            componentFactory = this.buildComponentFactory(tempContainer, componentFactory, clonedBehaviors);
        }
        tempContainer.addComponent(ComponentFactory.class, componentFactory, new Parameter[0]);
        this.buildComponentMonitor(tempContainer);
        if (this.lifecycleStrategy == null) {
            tempContainer.addComponent(LifecycleStrategy.class, this.lifecycleStrategyClass, new Parameter[0]);
        } else {
            tempContainer.addComponent(LifecycleStrategy.class, this.lifecycleStrategy, new Parameter[0]);
        }
        tempContainer.addComponent("mpc", this.mpcClass, new Parameter[0]);
        MutablePicoContainer newContainer = (MutablePicoContainer)tempContainer.getComponent("mpc");
        this.addChildToParent(newContainer);
        return newContainer;
    }

    private void buildComponentMonitor(DefaultPicoContainer tempContainer) {
        if (this.componentMonitorClass == null) {
            tempContainer.addComponent(ComponentMonitor.class, (Object)this.componentMonitor, new Parameter[0]);
        } else {
            tempContainer.addComponent(ComponentMonitor.class, this.componentMonitorClass, new Parameter[0]);
        }
    }

    private void addChildToParent(MutablePicoContainer newContainer) {
        if (this.addChildToParent) {
            if (this.parentContainer instanceof MutablePicoContainer) {
                ((MutablePicoContainer)this.parentContainer).addChildContainer(newContainer);
            } else {
                throw new PicoCompositionException("If using addChildContainer() the parent must be a MutablePicoContainer");
            }
        }
    }

    private void addContainerComponents(DefaultPicoContainer temp) {
        for (Object containerComp : this.containerComps) {
            temp.addComponent(containerComp);
        }
    }

    private ComponentFactory buildComponentFactory(DefaultPicoContainer container, ComponentFactory lastCaf, Stack<Object> clonedBehaviors) {
        ComponentFactory newlastCaf;
        Object componentFactory = clonedBehaviors.pop();
        TransientPicoContainer tmpContainer = new TransientPicoContainer(container);
        tmpContainer.addComponent("componentFactory", componentFactory, new Parameter[0]);
        if (lastCaf != null) {
            tmpContainer.addComponent(ComponentFactory.class, lastCaf, new Parameter[0]);
        }
        if ((newlastCaf = (ComponentFactory)tmpContainer.getComponent("componentFactory")) instanceof BehaviorFactory) {
            ((BehaviorFactory)newlastCaf).wrap(lastCaf);
        }
        return newlastCaf;
    }

    public PicoBuilder withHiddenImplementations() {
        this.behaviors.push(Behaviors.implementationHiding());
        return this;
    }

    public PicoBuilder withSetterInjection() {
        this.addInjector(Injectors.SDI());
        return this;
    }

    public PicoBuilder withAnnotatedMethodInjection(Class<? extends Annotation> injectionAnnotation) {
        this.addInjector(Injectors.annotatedMethodDI(injectionAnnotation));
        return this;
    }

    public PicoBuilder withAnnotatedMethodInjection() {
        this.addInjector(Injectors.annotatedMethodDI());
        return this;
    }

    public PicoBuilder withAnnotatedFieldInjection(Class<? extends Annotation> injectionAnnotation) {
        this.addInjector(Injectors.annotatedFieldDI(injectionAnnotation));
        return this;
    }

    public PicoBuilder withAnnotatedFieldInjection() {
        this.addInjector(Injectors.annotatedFieldDI());
        return this;
    }

    public PicoBuilder withTypedFieldInjection() {
        this.addInjector(Injectors.typedFieldDI());
        return this;
    }

    public PicoBuilder withConstructorInjection() {
        this.addInjector(Injectors.CDI());
        return this;
    }

    public PicoBuilder withNamedMethodInjection() {
        this.addInjector(Injectors.namedMethod());
        return this;
    }

    public PicoBuilder withNamedFieldInjection() {
        this.addInjector(Injectors.namedField());
        return this;
    }

    public PicoBuilder withCaching() {
        this.behaviors.push(Behaviors.caching());
        return this;
    }

    public PicoBuilder withComponentFactory(ComponentFactory componentFactory) {
        if (componentFactory == null) {
            throw new NullPointerException("CAF cannot be null");
        }
        this.behaviors.push(componentFactory);
        return this;
    }

    public PicoBuilder withSynchronizing() {
        this.behaviors.push(new Synchronizing());
        return this;
    }

    public PicoBuilder withLocking() {
        this.behaviors.push(new Locking());
        return this;
    }

    public PicoBuilder withBehaviors(BehaviorFactory ... factories) {
        for (BehaviorFactory componentFactory : factories) {
            this.behaviors.push(componentFactory);
        }
        return this;
    }

    public PicoBuilder implementedBy(Class<? extends MutablePicoContainer> containerClass) {
        this.mpcClass = containerClass;
        return this;
    }

    public PicoBuilder withMonitor(ComponentMonitor specifiedComponentMonitor) {
        this.componentMonitor = specifiedComponentMonitor;
        this.componentMonitorClass = null;
        return this;
    }

    public PicoBuilder withComponentFactory(Class<? extends ComponentFactory> componentFactoryClass) {
        this.behaviors.push(componentFactoryClass);
        return this;
    }

    public PicoBuilder withCustomContainerComponent(Object containerDependency) {
        this.containerComps.add(containerDependency);
        return this;
    }

    public PicoBuilder withPropertyApplier() {
        this.behaviors.push(new PropertyApplying());
        return this;
    }

    public PicoBuilder withAutomatic() {
        this.behaviors.push(new Automating());
        return this;
    }

    public PicoBuilder withMethodInjection() {
        this.addInjector(new MethodInjection());
        return this;
    }

    public PicoBuilder addChildToParent() {
        this.addChildToParent = true;
        return this;
    }

    protected void addInjector(InjectionFactory injectionType) {
        this.injectors.add(injectionType);
    }
}

