/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.CancellableSubscriber;
import io.smallrye.mutiny.subscription.ContextSupport;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;

public class Subscribers {
    public static final Consumer<? super Throwable> NO_ON_FAILURE = failure -> new Exception("Missing onFailure/onError handler in the subscriber", (Throwable)failure).printStackTrace();

    public static <T> CancellableSubscriber<T> from(Context context, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Flow.Subscription> onSubscription) {
        return new CallbackBasedSubscriber<T>(context, onItem, onFailure, onCompletion, onSubscription);
    }

    public static class CallbackBasedSubscriber<T>
    implements CancellableSubscriber<T>,
    Flow.Subscription,
    ContextSupport {
        private volatile Flow.Subscription subscription;
        private static final AtomicReferenceFieldUpdater<CallbackBasedSubscriber, Flow.Subscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CallbackBasedSubscriber.class, Flow.Subscription.class, "subscription");
        private final Context context;
        private final Consumer<? super T> onItem;
        private final Consumer<? super Throwable> onFailure;
        private final Runnable onCompletion;
        private final Consumer<? super Flow.Subscription> onSubscription;

        public CallbackBasedSubscriber(Context context, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Flow.Subscription> onSubscription) {
            this.context = context;
            this.onItem = ParameterValidation.nonNull(onItem, "onItem");
            this.onFailure = onFailure;
            this.onCompletion = onCompletion;
            this.onSubscription = ParameterValidation.nonNull(onSubscription, "onSubscription");
        }

        @Override
        public Context context() {
            return this.context;
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (SUBSCRIPTION_UPDATER.compareAndSet(this, null, s)) {
                try {
                    this.onSubscription.accept(this);
                }
                catch (Throwable ex) {
                    s.cancel();
                    Infrastructure.handleDroppedException(ex);
                }
            } else {
                s.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            Objects.requireNonNull(item);
            if (this.subscription != Subscriptions.CANCELLED) {
                try {
                    this.onItem.accept(item);
                }
                catch (Throwable e) {
                    SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED).cancel();
                    Infrastructure.handleDroppedException(e);
                }
            }
        }

        @Override
        public void onFailure(Throwable t) {
            Objects.requireNonNull(t);
            if (SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED) != Subscriptions.CANCELLED) {
                if (this.onFailure != null) {
                    try {
                        this.onFailure.accept(t);
                    }
                    catch (Throwable e) {
                        Infrastructure.handleDroppedException(new CompositeException(t, e));
                    }
                } else {
                    Infrastructure.handleDroppedException(t);
                }
            } else {
                Infrastructure.handleDroppedException(t);
            }
        }

        @Override
        public void onCompletion() {
            if (SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED) != Subscriptions.CANCELLED && this.onCompletion != null) {
                this.onCompletion.run();
            }
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            Flow.Subscription prev = SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED);
            if (prev != null && prev != Subscriptions.CANCELLED) {
                prev.cancel();
            }
        }
    }
}

