/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.logging.Logger;

public class HttpBinderConfiguration {
    private static final Logger log = Logger.getLogger(HttpBinderConfiguration.class);
    boolean serverEnabled = true;
    boolean clientEnabled = true;
    List<Pattern> serverIgnorePatterns = Collections.emptyList();
    Map<Pattern, String> serverMatchPatterns = Collections.emptyMap();
    List<Pattern> clientIgnorePatterns = Collections.emptyList();
    Map<Pattern, String> clientMatchPatterns = Collections.emptyMap();
    boolean serverSuppress4xxErrors = false;
    boolean clientSuppress4xxErrors = false;

    private HttpBinderConfiguration() {
    }

    public HttpBinderConfiguration(boolean httpServerMetrics, boolean httpClientMetrics, HttpServerConfig serverConfig, HttpClientConfig clientConfig, VertxConfig vertxConfig) {
        this.serverEnabled = httpServerMetrics;
        this.clientEnabled = httpClientMetrics;
        this.serverSuppress4xxErrors = serverConfig.suppress4xxErrors();
        this.clientSuppress4xxErrors = clientConfig.suppress4xxErrors();
        if (this.serverEnabled) {
            Pattern defaultIgnore = null;
            String defaultMatch = null;
            if (!MicrometerRecorder.httpRootUri.equals(MicrometerRecorder.nonApplicationUri) && serverConfig.suppressNonApplicationUris()) {
                defaultIgnore = Pattern.compile(MicrometerRecorder.nonApplicationUri + ".*");
            }
            if (defaultIgnore == null && LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                String devRoot = MicrometerRecorder.nonApplicationUri + "dev";
                defaultMatch = devRoot + "/.*=" + devRoot;
            }
            this.serverIgnorePatterns = this.getIgnorePatterns(serverConfig.ignorePatterns().isPresent() ? serverConfig.ignorePatterns() : vertxConfig.ignorePatterns(), defaultIgnore);
            this.serverMatchPatterns = this.getMatchPatterns(serverConfig.matchPatterns().isPresent() ? serverConfig.matchPatterns() : vertxConfig.matchPatterns(), defaultMatch);
        }
        if (this.clientEnabled) {
            this.clientIgnorePatterns = this.getIgnorePatterns(clientConfig.ignorePatterns(), null);
            this.clientMatchPatterns = this.getMatchPatterns(clientConfig.matchPatterns(), null);
        }
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public List<Pattern> getServerIgnorePatterns() {
        return this.serverIgnorePatterns;
    }

    public Map<Pattern, String> getServerMatchPatterns() {
        return this.serverMatchPatterns;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public List<Pattern> getClientIgnorePatterns() {
        return this.clientIgnorePatterns;
    }

    public Map<Pattern, String> getClientMatchPatterns() {
        return this.clientMatchPatterns;
    }

    public boolean isServerSuppress4xxErrors() {
        return this.serverSuppress4xxErrors;
    }

    public boolean isClientSuppress4xxErrors() {
        return this.clientSuppress4xxErrors;
    }

    List<Pattern> getIgnorePatterns(Optional<List<String>> configInput, Pattern defaultIgnore) {
        if (configInput.isPresent()) {
            List<String> input = configInput.get();
            ArrayList<Pattern> ignorePatterns = new ArrayList<Pattern>(input.size() + (defaultIgnore == null ? 0 : 1));
            for (String s : input) {
                ignorePatterns.add(Pattern.compile(s.trim()));
            }
            if (defaultIgnore != null) {
                ignorePatterns.add(defaultIgnore);
            }
            return Collections.unmodifiableList(ignorePatterns);
        }
        if (defaultIgnore != null) {
            return Collections.singletonList(defaultIgnore);
        }
        return Collections.emptyList();
    }

    Map<Pattern, String> getMatchPatterns(Optional<List<String>> configInput, String defaultMatch) {
        if (configInput.isPresent()) {
            List<String> input = configInput.get();
            LinkedHashMap<Pattern, String> matchPatterns = new LinkedHashMap<Pattern, String>(input.size() + (defaultMatch == null ? 0 : 1));
            for (String s : input) {
                this.parseMatchPattern(s, matchPatterns);
            }
            if (defaultMatch != null) {
                this.parseMatchPattern(defaultMatch, matchPatterns);
            }
            return Collections.unmodifiableMap(matchPatterns);
        }
        if (defaultMatch != null) {
            HashMap<Pattern, String> matchPatterns = new HashMap<Pattern, String>(1);
            this.parseMatchPattern(defaultMatch, matchPatterns);
            return Collections.unmodifiableMap(matchPatterns);
        }
        return Collections.emptyMap();
    }

    private void parseMatchPattern(String s, Map<Pattern, String> matchPatterns) {
        int pos = s.indexOf("=");
        if (pos > 0 && s.length() > 2) {
            String pattern = s.substring(0, pos).trim();
            String replacement = s.substring(pos + 1).trim();
            try {
                matchPatterns.put(Pattern.compile(pattern), replacement);
            }
            catch (PatternSyntaxException pse) {
                log.errorf("Invalid pattern in replacement string (%s=%s): %s", (Object)pattern, (Object)replacement, (Object)pse);
            }
        } else {
            log.errorf("Invalid pattern in replacement string (%s). Should be pattern=replacement", (Object)s);
        }
    }

    public String getHttpServerRequestsName() {
        return "http.server.requests";
    }

    public String getHttpServerActiveRequestsName() {
        return "http.server.active.requests";
    }

    public String getHttpServerPushName() {
        return "http.server.push";
    }

    public String getHttpServerWebSocketConnectionsName() {
        return "http.server.websocket.connections";
    }

    public String getHttpClientWebSocketConnectionsName() {
        return "http.client.websocket.connections";
    }

    public String getHttpClientRequestsName() {
        return "http.client.requests";
    }

    public HttpBinderConfiguration unwrap() {
        HttpBinderConfiguration result = new HttpBinderConfiguration();
        result.clientEnabled = this.clientEnabled;
        result.serverEnabled = this.serverEnabled;
        result.serverSuppress4xxErrors = this.serverSuppress4xxErrors;
        result.clientSuppress4xxErrors = this.clientSuppress4xxErrors;
        return result.update(this);
    }

    public HttpBinderConfiguration update(HttpBinderConfiguration httpConfig) {
        this.clientMatchPatterns = httpConfig.clientMatchPatterns;
        this.serverMatchPatterns = httpConfig.serverMatchPatterns;
        this.clientIgnorePatterns = httpConfig.clientIgnorePatterns;
        this.serverIgnorePatterns = httpConfig.serverIgnorePatterns;
        this.serverSuppress4xxErrors = httpConfig.serverSuppress4xxErrors;
        this.clientSuppress4xxErrors = httpConfig.clientSuppress4xxErrors;
        return this;
    }
}

