/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedAttributeNodeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedEntityGraphImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedSubgraphImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.NamedAttributeNodeJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedEntityGraphJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedEntityGraphsJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedSubgraphJpaAnnotation;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;

public class EntityGraphProcessing {
    public static void applyEntityGraphs(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbNamedEntityGraphImpl> jaxbEntityGraphs = jaxbEntity.getNamedEntityGraphs();
        if (CollectionHelper.isEmpty(jaxbEntityGraphs)) {
            return;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        NamedEntityGraphsJpaAnnotation entityGraphsUsage = (NamedEntityGraphsJpaAnnotation)classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_ENTITY_GRAPH, JpaAnnotations.NAMED_ENTITY_GRAPHS, modelBuildingContext);
        NamedEntityGraph[] graphs = new NamedEntityGraph[jaxbEntityGraphs.size()];
        entityGraphsUsage.value(graphs);
        for (int i = 0; i < jaxbEntityGraphs.size(); ++i) {
            graphs[i] = EntityGraphProcessing.extractGraph(jaxbEntityGraphs.get(i), (ClassDetails)classDetails, modelBuildingContext, xmlDocumentContext);
        }
    }

    private static NamedEntityGraph extractGraph(JaxbNamedEntityGraphImpl jaxbEntityGraph, ClassDetails classDetails, ModelsContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        NamedEntityGraphJpaAnnotation graphUsage = (NamedEntityGraphJpaAnnotation)((Object)JpaAnnotations.NAMED_ENTITY_GRAPH.createUsage(modelBuildingContext));
        if (StringHelper.isNotEmpty(jaxbEntityGraph.getName())) {
            graphUsage.name(jaxbEntityGraph.getName());
        }
        if (jaxbEntityGraph.isIncludeAllAttributes() != null) {
            graphUsage.includeAllAttributes(jaxbEntityGraph.isIncludeAllAttributes());
        }
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getNamedAttributeNode())) {
            graphUsage.attributeNodes(EntityGraphProcessing.extractAttributeNodes(jaxbEntityGraph.getNamedAttributeNode(), classDetails, modelBuildingContext, xmlDocumentContext));
        }
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getSubgraph())) {
            graphUsage.subgraphs(EntityGraphProcessing.extractSubgraphNodes(jaxbEntityGraph.getSubgraph(), classDetails, modelBuildingContext, xmlDocumentContext));
        }
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getSubclassSubgraph())) {
            graphUsage.subclassSubgraphs(EntityGraphProcessing.extractSubgraphNodes(jaxbEntityGraph.getSubclassSubgraph(), classDetails, modelBuildingContext, xmlDocumentContext));
        }
        return graphUsage;
    }

    private static NamedAttributeNode[] extractAttributeNodes(List<JaxbNamedAttributeNodeImpl> jaxbAttributeNodes, ClassDetails classDetails, ModelsContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbAttributeNodes));
        NamedAttributeNode[] attributeNodes = new NamedAttributeNode[jaxbAttributeNodes.size()];
        for (int i = 0; i < jaxbAttributeNodes.size(); ++i) {
            NamedAttributeNodeJpaAnnotation namedAttributeNodeAnn = (NamedAttributeNodeJpaAnnotation)((Object)JpaAnnotations.NAMED_ATTRIBUTE_NODE.createUsage(modelBuildingContext));
            attributeNodes[i] = namedAttributeNodeAnn;
            JaxbNamedAttributeNodeImpl jaxbAttributeNode = jaxbAttributeNodes.get(i);
            namedAttributeNodeAnn.value(jaxbAttributeNode.getName());
            if (StringHelper.isNotEmpty(jaxbAttributeNode.getSubgraph())) {
                namedAttributeNodeAnn.subgraph(jaxbAttributeNode.getSubgraph());
            }
            if (!StringHelper.isNotEmpty(jaxbAttributeNode.getKeySubgraph())) continue;
            namedAttributeNodeAnn.keySubgraph(jaxbAttributeNode.getKeySubgraph());
        }
        return attributeNodes;
    }

    private static NamedSubgraph[] extractSubgraphNodes(List<JaxbNamedSubgraphImpl> jaxbSubgraphs, ClassDetails classDetails, ModelsContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbSubgraphs));
        NamedSubgraph[] subgraphs = new NamedSubgraph[jaxbSubgraphs.size()];
        for (int i = 0; i < jaxbSubgraphs.size(); ++i) {
            Class type;
            NamedSubgraphJpaAnnotation namedSubGraphUsage = (NamedSubgraphJpaAnnotation)((Object)JpaAnnotations.NAMED_SUBGRAPH.createUsage(modelBuildingContext));
            subgraphs[i] = namedSubGraphUsage;
            JaxbNamedSubgraphImpl jaxbSubgraph = jaxbSubgraphs.get(i);
            namedSubGraphUsage.name(jaxbSubgraph.getName());
            if (jaxbSubgraph.getClazz() == null) {
                type = Void.TYPE;
            } else {
                MutableClassDetails typeDetails = xmlDocumentContext.resolveJavaType(jaxbSubgraph.getClazz());
                type = typeDetails.toJavaClass();
            }
            namedSubGraphUsage.type(type);
            if (!CollectionHelper.isNotEmpty(jaxbSubgraph.getNamedAttributeNode())) continue;
            namedSubGraphUsage.attributeNodes(EntityGraphProcessing.extractAttributeNodes(jaxbSubgraph.getNamedAttributeNode(), classDetails, modelBuildingContext, xmlDocumentContext));
        }
        return subgraphs;
    }
}

