/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.admin.fgap.FineGrainedAdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.GroupPermissions;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.ModelRecord;

class GroupPermissionsV2
extends GroupPermissions {
    private final FineGrainedAdminPermissionEvaluator eval;

    GroupPermissionsV2(KeycloakSession session, AuthorizationProvider authz, MgmtPermissions root) {
        super(authz, root);
        this.eval = new FineGrainedAdminPermissionEvaluator(session, root, this.resourceStore, this.policyStore);
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole("manage-users", "view-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(null), null, "view");
    }

    @Override
    public boolean canView(GroupModel group) {
        if (this.root.hasOneAdminRole("manage-users", "view-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(group), null, "view");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(null), null, "manage");
    }

    @Override
    public boolean canManage(GroupModel group) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(group), null, "manage");
    }

    @Override
    public boolean canViewMembers(GroupModel group) {
        if (this.root.hasOneAdminRole("view-users", "manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(group), null, "view-members");
    }

    @Override
    public boolean canManageMembers(GroupModel group) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(group), null, "manage-members");
    }

    @Override
    public boolean canManageMembership(GroupModel group) {
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.GroupModelRecord(group), null, "manage-membership");
    }

    @Override
    public Set<String> getGroupIdsWithViewPermission() {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isPermissionsEnabled(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(GroupModel group, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewMembersPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageMembersPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageMembershipPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

