/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.swing.IconUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignL;
import org.kordamp.ikonli.swing.FontIcon;

public class ToggleBlacklistAction
extends AbstractAction {
    private final FontIcon enabledIcon = IconUtils.windowBarSpecificToolbarIcon((Ikon)MaterialDesignL.LIST_STATUS);
    private final FontIcon disabledIcon = IconUtils.windowBarSpecificToolbarIcon((Ikon)MaterialDesignL.LIST_STATUS, Color.RED);
    private boolean blacklist_is_on = ApplicationConfiguration.getConfiguration().getBoolean("blacklist.is_on", false);

    public ToggleBlacklistAction() {
        this.setupState();
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.blacklist_is_on = ApplicationConfiguration.getConfiguration().getBoolean("blacklist.is_on", false);
            this.setupState();
        });
    }

    private void setupState() {
        if (this.blacklist_is_on) {
            this.putValue("Name", "Blacklist ausschalten");
            this.putValue("ShortDescription", "Blacklist ausschalten");
            this.putValue("SmallIcon", this.enabledIcon);
        } else {
            this.putValue("Name", "Blacklist einschalten");
            this.putValue("ShortDescription", "Blacklist einschalten");
            this.putValue("SmallIcon", this.disabledIcon);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.blacklist_is_on = !this.blacklist_is_on;
        ApplicationConfiguration.getConfiguration().setProperty("blacklist.is_on", (Object)this.blacklist_is_on);
        Daten.getInstance().getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync((Object)new BlacklistChangedEvent());
    }
}

