/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.JakartaGeneratorWrapper;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonArrayImpl;
import oracle.jdbc.driver.json.binary.OsonContext;

public class JakartaOsonArray
extends OsonAbstractArray
implements JsonArray,
Wrapper {
    public JakartaOsonArray(OsonContext ctx, int pos) {
        super(ctx, pos);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(new OsonArrayImpl(new OsonContext(this.ctx), this.pos));
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(OsonArrayImpl.class);
    }

    public JsonObject getJsonObject(int i) {
        return (JsonObject)this.getJsonObjectInternal(this.getOffsetWithError(i));
    }

    public JsonArray getJsonArray(int i) {
        return (JsonArray)this.getArrayInternal(this.getOffsetWithError(i));
    }

    public JsonNumber getJsonNumber(int i) {
        return (JsonNumber)this.getValueInternal(this.getOffsetWithError(i));
    }

    public JsonString getJsonString(int i) {
        return (JsonString)this.get(i);
    }

    @Override
    public String getString(int i) {
        return this.getJsonString(i).getString();
    }

    public String getString(int i, String defaultValue) {
        if (i < 0 || i >= this.size()) {
            return defaultValue;
        }
        JsonValue v = this.get(i);
        if (v.getValueType() != JsonValue.ValueType.STRING) {
            return defaultValue;
        }
        return ((JsonString)v).getString();
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> c) {
        return this;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    public Iterator<JsonValue> iterator() {
        return new OsonAbstractArray.ValueIter<JsonValue>(this);
    }

    public boolean add(JsonValue e) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends JsonValue> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection<? extends JsonValue> c) {
        throw new UnsupportedOperationException();
    }

    public JsonValue get(int i) {
        return (JsonValue)this.getInternal(i);
    }

    public JsonValue set(int index, JsonValue element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, JsonValue element) {
        throw new UnsupportedOperationException();
    }

    public JsonValue remove(int index) {
        throw new UnsupportedOperationException();
    }

    public ListIterator<JsonValue> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<JsonValue> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new OsonAbstractArray.ListIter<JsonValue>(this, index);
    }

    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return super.sublist(fromIndex, toIndex);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JakartaGeneratorWrapper ser = new JakartaGeneratorWrapper(new JsonSerializerImpl(writer));
        ser.write((JsonValue)this);
        ser.close();
        return writer.toString();
    }
}

