/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.HashSet;
import java.util.Set;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSConnection;

public class ONSNodeList {
    private ONSConfiguration.NodeList baseNodeList;

    ONSNodeList(ONSConfiguration.NodeList nodeList) {
        this.baseNodeList = nodeList;
    }

    public String getId() {
        return this.baseNodeList.publicId;
    }

    public boolean isActive() {
        return this.baseNodeList.active;
    }

    public int getConcurrency() {
        return this.baseNodeList.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ONSNodeList getFailOver() {
        NotificationNetwork notificationNetwork;
        ONSNodeList oNSNodeList = null;
        NotificationNetwork notificationNetwork2 = notificationNetwork = this.baseNodeList.config.getNetwork();
        synchronized (notificationNetwork2) {
            if (this.baseNodeList.failedTo != null) {
                oNSNodeList = new ONSNodeList(this.baseNodeList.failedTo);
            } else if (this.baseNodeList.failedFrom != null) {
                oNSNodeList = new ONSNodeList(this.baseNodeList.failedFrom);
            }
        }
        return oNSNodeList;
    }

    public Set<ONSConnection> getConnections() {
        NotificationNetwork notificationNetwork = this.baseNodeList.config.getNetwork();
        HashSet<ONSConnection> hashSet = new HashSet<ONSConnection>();
        HashSet<NodeAddress> hashSet2 = new HashSet<NodeAddress>();
        notificationNetwork.scanExpandNodeList(this.baseNodeList.addresses, hashSet2);
        for (NodeAddress nodeAddress : hashSet2) {
            hashSet.add(new ONSConnection(nodeAddress, this.baseNodeList));
        }
        return hashSet;
    }
}

