/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.IntrusiveCollection;

@InterfaceAudience.Private
public final class CacheDirective
implements IntrusiveCollection.Element {
    private final long id;
    private final String path;
    private final short replication;
    private CachePool pool;
    private final long expiryTime;
    private long bytesNeeded;
    private long bytesCached;
    private long filesNeeded;
    private long filesCached;
    private IntrusiveCollection.Element prev;
    private IntrusiveCollection.Element next;

    public CacheDirective(CacheDirectiveInfo info) {
        this(info.getId(), info.getPath().toUri().getPath(), info.getReplication(), info.getExpiration().getAbsoluteMillis());
    }

    public CacheDirective(long id, String path, short replication, long expiryTime) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        this.id = id;
        this.path = (String)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0);
        this.replication = replication;
        this.expiryTime = expiryTime;
    }

    public long getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public short getReplication() {
        return this.replication;
    }

    public CachePool getPool() {
        return this.pool;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public String getExpiryTimeString() {
        return DFSUtil.dateToIso8601String(new Date(this.expiryTime));
    }

    public CacheDirectiveInfo toInfo() {
        return new CacheDirectiveInfo.Builder().setId(Long.valueOf(this.id)).setPath(new Path(this.path)).setReplication(Short.valueOf(this.replication)).setPool(this.pool.getPoolName()).setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)this.expiryTime)).build();
    }

    public CacheDirectiveStats toStats() {
        return new CacheDirectiveStats.Builder().setBytesNeeded(this.bytesNeeded).setBytesCached(this.bytesCached).setFilesNeeded(this.filesNeeded).setFilesCached(this.filesCached).setHasExpired(new Date().getTime() > this.expiryTime).build();
    }

    public CacheDirectiveEntry toEntry() {
        return new CacheDirectiveEntry(this.toInfo(), this.toStats());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ id:").append(this.id).append(", path:").append(this.path).append(", replication:").append(this.replication).append(", pool:").append(this.pool).append(", expiryTime: ").append(this.getExpiryTimeString()).append(", bytesNeeded:").append(this.bytesNeeded).append(", bytesCached:").append(this.bytesCached).append(", filesNeeded:").append(this.filesNeeded).append(", filesCached:").append(this.filesCached).append(" }");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CacheDirective other = (CacheDirective)o;
        return this.id == other.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public void resetStatistics() {
        this.bytesNeeded = 0L;
        this.bytesCached = 0L;
        this.filesNeeded = 0L;
        this.filesCached = 0L;
    }

    public long getBytesNeeded() {
        return this.bytesNeeded;
    }

    public void addBytesNeeded(long bytes) {
        this.bytesNeeded += bytes;
        this.pool.addBytesNeeded(bytes);
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public void addBytesCached(long bytes) {
        this.bytesCached += bytes;
        this.pool.addBytesCached(bytes);
    }

    public long getFilesNeeded() {
        return this.filesNeeded;
    }

    public void addFilesNeeded(long files) {
        this.filesNeeded += files;
        this.pool.addFilesNeeded(files);
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    public void addFilesCached(long files) {
        this.filesCached += files;
        this.pool.addFilesCached(files);
    }

    public void insertInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev, IntrusiveCollection.Element next) {
        assert (this.pool == null);
        this.pool = ((CachePool.DirectiveList)list).getCachePool();
        this.prev = prev;
        this.next = next;
    }

    public void setPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev) {
        assert (list == this.pool.getDirectiveList());
        this.prev = prev;
    }

    public void setNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element next) {
        assert (list == this.pool.getDirectiveList());
        this.next = next;
    }

    public void removeInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        assert (list == this.pool.getDirectiveList());
        this.pool = null;
        this.prev = null;
        this.next = null;
    }

    public IntrusiveCollection.Element getPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        if (list != this.pool.getDirectiveList()) {
            return null;
        }
        return this.prev;
    }

    public IntrusiveCollection.Element getNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        if (list != this.pool.getDirectiveList()) {
            return null;
        }
        return this.next;
    }

    public boolean isInList(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        return this.pool == null ? false : list == this.pool.getDirectiveList();
    }
}

