/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.assertion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyMap;

@NotThreadSafe
public class ValidationContext {
    @Nonnull
    @NullableElements
    private Map<String, Object> staticParameters;
    @Nonnull
    @NullableElements
    private Map<String, Object> dynamicParameters;
    @Nonnull
    private final List<String> validationFailureMessages;

    public ValidationContext() {
        this(null);
    }

    public ValidationContext(@Nullable @NullableElements Map<String, Object> newStaticParameters) {
        this.staticParameters = newStaticParameters == null ? CollectionSupport.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(newStaticParameters));
        this.dynamicParameters = new LazyMap<String, Object>();
        this.validationFailureMessages = new ArrayList<String>();
    }

    @Nonnull
    @NullableElements
    @Unmodifiable
    @NotLive
    public Map<String, Object> getStaticParameters() {
        return this.staticParameters;
    }

    @Nonnull
    @NullableElements
    @Live
    public Map<String, Object> getDynamicParameters() {
        return this.dynamicParameters;
    }

    @Nonnull
    @Live
    public List<String> getValidationFailureMessages() {
        return this.validationFailureMessages;
    }
}

