let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac2"

# 13 "plugins/ltac2/g_ltac2.mlg"
 

open Pp
open Util
open Names
open Procq
open Procq.Prim
open Attributes
open Constrexpr
open Tac2expr
open Tac2qexpr

let lk_ident_or_anti =
  Procq.Lookahead.(lk_ident <+> (lk_kw "$" >> lk_ident >> check_no_space))

(* lookahead for (x:=t), (?x:=t) and (1:=t) *)
let test_lpar_idnum_coloneq =
  let open Procq.Lookahead in
  to_entry "test_lpar_idnum_coloneq" begin
    lk_kw "(" >> (lk_ident_or_anti <+> lk_nat) >> lk_kw ":="
  end

(* lookahead for (x:t), (?x:t) *)
let test_lpar_id_colon =
  let open Procq.Lookahead in
  to_entry "test_lpar_id_colon" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":"
  end

(* Hack to recognize "(x := t)" and "($x := t)" *)
let test_lpar_id_coloneq =
  let open Procq.Lookahead in
  to_entry "test_lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":="
  end

(* Hack to recognize "(x)" *)
let test_lpar_id_rpar =
  let open Procq.Lookahead in
  to_entry "test_lpar_id_rpar" begin
    lk_kw "(" >> lk_ident >> lk_kw ")"
  end

let test_ampersand_ident =
  let open Procq.Lookahead in
  to_entry "test_ampersand_ident" begin
    lk_kw "&" >> lk_ident >> check_no_space
  end

let test_dollar_ident =
  let open Procq.Lookahead in
  to_entry "test_dollar_ident" begin
    lk_kw "$" >> lk_ident >> check_no_space
  end

let test_dollar_ident_colon_ident =
  let open Procq.Lookahead in
  to_entry "test_dollar_ident_colon_ident" begin
    lk_kw "$" >> lk_ident >> lk_kw ":" >> lk_ident >> check_no_space
  end

let test_ltac1_env =
  let open Procq.Lookahead in
  to_entry "test_ltac1_env" begin
    lk_ident_list >> lk_kw "|-"
  end

let test_qualid_with_or_lpar_or_rbrac =
  let open Procq.Lookahead in
  to_entry "test_qualid_with_or_lpar_or_rbrac" begin
    (lk_qualid >> lk_kw "with") <+> lk_kw "(" <+> lk_kw "{"
  end

let test_array_opening =
  let open Procq.Lookahead in
  to_entry "test_array_opening" begin
    lk_kw "[" >> lk_kw "|" >> check_no_space
  end

let test_array_closing =
  let open Procq.Lookahead in
  to_entry "test_array_closing" begin
    lk_kw "|" >> lk_kw "]" >> check_no_space
  end

let test_leftsquarebracket_equal =
  let open Procq.Lookahead in
  to_entry "test_leftsquarebracket_equal" begin
    lk_kw "[" >> lk_kw "=" >> check_no_space
  end

let ltac2_expr = Tac2entries.Pltac.ltac2_expr
let _ltac2_expr = ltac2_expr
let ltac2_type = Entry.make "ltac2_type"
let tac2def_val = Entry.make "tac2def_val"
let tac2def_typ = Entry.make "tac2def_typ"
let tac2def_ext = Entry.make "tac2def_ext"
let tac2def_syn = Entry.make "tac2def_syn"
let tac2def_mut = Entry.make "tac2def_mut"
let tac2mode = Entry.make "ltac2_command"
let ltac2_atom = Entry.make "ltac2_atom"

let tac2expr_in_env = Tac2entries.Pltac.tac2expr_in_env

let quoted_attributes = G_vernac.quoted_attributes

let inj_wit wit loc x = CAst.make ~loc @@ CTacExt (wit, x)
let inj_open_constr loc c = inj_wit Tac2quote.wit_open_constr loc c
let inj_pattern loc c = inj_wit Tac2quote.wit_pattern loc c
let inj_reference loc c = inj_wit Tac2quote.wit_reference loc c

let pattern_of_qualid qid =
  if Tac2env.is_constructor qid then CAst.make ?loc:qid.CAst.loc @@ CPatRef (RelId qid, [])
  else
    let open Libnames in
    if qualid_is_ident qid then CAst.make ?loc:qid.CAst.loc @@ CPatVar (Name (qualid_basename qid))
    else
      CErrors.user_err ?loc:qid.CAst.loc (Pp.str "Syntax error")

let opt_fun ?loc args ty e =
  let e = match ty with
  | None -> e
  | Some ty -> CAst.make ?loc:e.CAst.loc (CTacCnv (e, ty))
  in
  match args with
  | [] -> e
  | _ :: _ -> CAst.make ?loc (CTacFun (args, e))


# 134 "plugins/ltac2/g_ltac2.ml"

let _ =
  let tac2pat = Procq.Entry.make "tac2pat"
  and atomic_tac2pat = Procq.Entry.make "atomic_tac2pat"
  and array_literal = Procq.Entry.make "array_literal"
  and list_literal = Procq.Entry.make "list_literal"
  and branches = Procq.Entry.make "branches"
  and branch = Procq.Entry.make "branch"
  and rec_flag = Procq.Entry.make "rec_flag"
  and mut_flag = Procq.Entry.make "mut_flag"
  and ltac2_typevar = Procq.Entry.make "ltac2_typevar"
  and type_cast = Procq.Entry.make "type_cast"
  and let_clause = Procq.Entry.make "let_clause"
  and let_binder = Procq.Entry.make "let_binder"
  and binder = Procq.Entry.make "binder"
  and input_fun = Procq.Entry.make "input_fun"
  and tac2def_body = Procq.Entry.make "tac2def_body"
  and tac2typ_knd = Procq.Entry.make "tac2typ_knd"
  and tac2alg_constructors = Procq.Entry.make "tac2alg_constructors"
  and tac2alg_constructor = Procq.Entry.make "tac2alg_constructor"
  and tac2rec_fields = Procq.Entry.make "tac2rec_fields"
  and tac2rec_field = Procq.Entry.make "tac2rec_field"
  and tac2rec_fieldexprs = Procq.Entry.make "tac2rec_fieldexprs"
  and tac2rec_fieldexpr = Procq.Entry.make "tac2rec_fieldexpr"
  and tac2rec_fieldpats = Procq.Entry.make "tac2rec_fieldpats"
  and tac2rec_fieldpat = Procq.Entry.make "tac2rec_fieldpat"
  and tac2typ_prm = Procq.Entry.make "tac2typ_prm"
  and tac2typ_def = Procq.Entry.make "tac2typ_def"
  and tac2type_body = Procq.Entry.make "tac2type_body"
  and syn_node = Procq.Entry.make "syn_node"
  and ltac2_syntax_class = Procq.Entry.make "ltac2_syntax_class"
  and syn_level = Procq.Entry.make "syn_level"
  and globref = Procq.Entry.make "globref"
  in
  let () = assert (Procq.Entry.is_empty tac2pat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:0")
  tac2pat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("1"), Some (Gramlib.Gramext.LeftA),
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm tac2pat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                             ((Procq.Symbol.nterm identref)))
                            (fun id _ p loc -> 
# 160 "plugins/ltac2/g_ltac2.mlg"
                                              CAst.make ~loc @@ CPatAs (p,id) 
# 185 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2pat)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm tac2pat)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun pl _ p loc -> 
# 158 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatOr pl 
# 198 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2pat)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("::")))))
                            ((Procq.Symbol.nterm tac2pat)))
                           (fun p2 _ p1 loc -> 
# 156 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [p1; p2])
# 210 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.qualid)))
                           (fun qid loc -> 
# 153 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
# 218 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.qualid)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterml tac2pat ("0"))))))
                           (fun pl qid loc -> 
# 148 "plugins/ltac2/g_ltac2.mlg"
                                                            
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CPatRef (RelId qid, pl)
        else
          CErrors.user_err ~loc (Pp.str "Syntax error") 
# 232 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list0sep ((Procq.Symbol.nterm tac2pat)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (";"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ pats _ loc -> 
# 171 "plugins/ltac2/g_ltac2.mlg"
         
          let nil = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_nil), []) in
          let cons hd tl = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [hd;tl]) in
          List.fold_right cons pats nil
        
# 249 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                            ((Procq.Symbol.nterm tac2rec_fieldpats)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                          (fun _ a _ loc -> 
# 169 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ CPatRecord a 
# 261 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            ((Procq.Symbol.nterm atomic_tac2pat)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ p _ loc -> 
# 168 "plugins/ltac2/g_ltac2.mlg"
                                          p 
# 273 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm Prim.qualid)))
                          (fun qid loc -> 
# 167 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
# 281 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm Prim.string)))
                          (fun s loc -> 
# 166 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CPatAtm (AtmStr s) 
# 289 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm Prim.integer)))
                          (fun n loc -> 
# 165 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CPatAtm (AtmInt n) 
# 297 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                          (fun _ loc -> 
# 164 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
# 305 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                          (fun _ loc -> 
# 163 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CPatVar Anonymous 
# 313 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty atomic_tac2pat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:1")
  atomic_tac2pat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm tac2pat)))
                            (fun p loc -> 
# 186 "plugins/ltac2/g_ltac2.mlg"
                         p 
# 327 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2pat)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                            ((Procq.Symbol.list0sep ((Procq.Symbol.nterm tac2pat)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun pl _ p loc -> 
# 184 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple (List.length pl)), pl) 
# 340 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2pat)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm ltac2_type)))
                           (fun t _ p loc -> 
# 182 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatCnv (p, t) 
# 352 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 180 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
# 358 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_expr) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:2")
  ltac2_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("6"), Some (Gramlib.Gramext.RightA),
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               (Procq.Symbol.self))
                              ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                             (Procq.Symbol.self))
                            (fun e2 _ e1 loc -> 
# 191 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTacSeq (e1, e2) 
# 376 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("5"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("if")))))
                                ((Procq.Symbol.nterml ltac2_expr ("5"))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("then")))))
                              ((Procq.Symbol.nterml ltac2_expr ("5"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("else")))))
                            ((Procq.Symbol.nterml ltac2_expr ("5"))))
                           (fun e2 _ e1 _ e _ loc -> 
# 202 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacIft (e, e1, e2) 
# 395 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("match")))))
                              ((Procq.Symbol.nterml ltac2_expr ("5"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm branches)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("end")))))
                          (fun _ bl _ e _ loc -> 
# 200 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCse (e, bl) 
# 411 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                              ((Procq.Symbol.nterm rec_flag)))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm let_clause)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                           ((Procq.Symbol.nterml ltac2_expr ("6"))))
                          (fun e _ lc isrec _ loc -> 
# 198 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacLet (isrec, lc, e) 
# 427 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("fun")))))
                              ((Procq.Symbol.list1 ((Procq.Symbol.nterm input_fun)))))
                             ((Procq.Symbol.nterm type_cast)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                           ((Procq.Symbol.nterml ltac2_expr ("6"))))
                          (fun body _ ty it _ loc -> 
# 194 "plugins/ltac2/g_ltac2.mlg"
          opt_fun ~loc it ty body 
# 443 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("4"), Some (Gramlib.Gramext.LeftA), []);
                          (Some ("3"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              (Procq.Symbol.self))
                             ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                            ((Procq.Symbol.list1sep (Procq.Symbol.next) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun el _ e0 loc -> 
# 206 "plugins/ltac2/g_ltac2.mlg"
          let el = e0 :: el in
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Tuple (List.length el))), el) 
# 458 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("2"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac2_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("::")))))
                            ((Procq.Symbol.nterm ltac2_expr)))
                           (fun e2 _ e1 loc -> 
# 210 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Other Tac2core.Core.c_cons)), [e1; e2]) 
# 471 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("1"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 (Procq.Symbol.self))
                                ((Procq.Symbol.token (Tok.PKEYWORD (".(")))))
                               ((Procq.Symbol.nterm Prim.qualid)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterml ltac2_expr ("5"))))
                           (fun r _ _ qid _ e loc -> 
# 218 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacSet (e, RelId qid, r) 
# 490 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              (Procq.Symbol.self))
                             ((Procq.Symbol.token (Tok.PKEYWORD (".(")))))
                            ((Procq.Symbol.nterm Prim.qualid)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ qid _ e loc -> 
# 216 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacPrj (e, RelId qid) 
# 504 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac2_expr)))
                           ((Procq.Symbol.list1 ((Procq.Symbol.nterml ltac2_expr ("0"))))))
                          (fun el e loc -> 
# 214 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (e, el) 
# 514 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac2_atom)))
                           (fun a loc -> 
# 233 "plugins/ltac2/g_ltac2.mlg"
                            a 
# 523 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                            ((Procq.Symbol.nterm tac2rec_fieldexprs)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                          (fun _ a _ loc -> 
# 232 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (None, a) 
# 535 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.nterm test_qualid_with_or_lpar_or_rbrac)))
                              ((Procq.Symbol.nterml ltac2_expr ("0"))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm tac2rec_fieldexprs)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                          (fun _ a _ e _ _ loc -> 
# 230 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (Some e, a) 
# 553 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm list_literal)))
                          (fun a loc -> 
# 228 "plugins/ltac2/g_ltac2.mlg"
                              a 
# 561 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm array_literal)))
                          (fun a loc -> 
# 227 "plugins/ltac2/g_ltac2.mlg"
                               a 
# 569 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ _ loc -> 
# 226 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
# 579 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                          (fun _ loc -> 
# 224 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
# 587 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              (Procq.Symbol.self))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm ltac2_type)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ t _ a _ loc -> 
# 222 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCnv (a, t) 
# 603 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            (Procq.Symbol.self))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ a _ loc -> 
# 220 "plugins/ltac2/g_ltac2.mlg"
                                a 
# 615 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty array_literal) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:3")
  array_literal
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.nterm test_array_opening)))
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                ((Procq.Symbol.list0sep ((Procq.Symbol.nterml ltac2_expr ("5"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (";"))])) false)))
                               ((Procq.Symbol.nterm test_array_closing)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ _ _ a _ _ _ loc -> 
# 238 "plugins/ltac2/g_ltac2.mlg"
        Tac2quote.array_literal ~loc a 
# 641 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty list_literal) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:4")
  list_literal
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.list0sep ((Procq.Symbol.nterml ltac2_expr ("5"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (";"))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ a _ loc -> 
# 242 "plugins/ltac2/g_ltac2.mlg"
         Tac2quote.of_list ~loc (fun x -> x) a 
# 659 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty branches) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:5")
  branches
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm branch)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun bl loc -> 
# 247 "plugins/ltac2/g_ltac2.mlg"
                                     bl 
# 673 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm branch)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun bl _ loc -> 
# 246 "plugins/ltac2/g_ltac2.mlg"
                                          bl 
# 683 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 245 "plugins/ltac2/g_ltac2.mlg"
           [] 
# 689 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty branch) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:6")
  branch
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm atomic_tac2pat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterml ltac2_expr ("6"))))
                            (fun e _ pat loc -> 
# 251 "plugins/ltac2/g_ltac2.mlg"
                                                                (pat, e) 
# 707 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rec_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:7")
  rec_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 255 "plugins/ltac2/g_ltac2.mlg"
             false 
# 719 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("rec"))))))
                           (fun _ loc -> 
# 254 "plugins/ltac2/g_ltac2.mlg"
                         true 
# 728 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty mut_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:8")
  mut_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 259 "plugins/ltac2/g_ltac2.mlg"
             false 
# 740 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("mutable"))))))
                           (fun _ loc -> 
# 258 "plugins/ltac2/g_ltac2.mlg"
                             true 
# 749 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_typevar) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:9")
  ltac2_typevar
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id _ loc -> 
# 262 "plugins/ltac2/g_ltac2.mlg"
                                  id 
# 765 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_atom) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:10")
  ltac2_atom
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("reference"))))))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm globref)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ c _ _ _ loc -> 
# 280 "plugins/ltac2/g_ltac2.mlg"
                                                           inj_reference loc c 
# 788 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("pat"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm Constr.cpattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ _ _ loc -> 
# 279 "plugins/ltac2/g_ltac2.mlg"
                                                             inj_pattern loc c 
# 805 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("ident"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ _ _ loc -> 
# 278 "plugins/ltac2/g_ltac2.mlg"
                                                        Tac2quote.of_ident c 
# 822 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("preterm"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ _ _ loc -> 
# 277 "plugins/ltac2/g_ltac2.mlg"
                                                                Tac2quote.of_preterm c 
# 839 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("open_constr"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ _ _ loc -> 
# 276 "plugins/ltac2/g_ltac2.mlg"
                                                                    Tac2quote.of_open_constr c 
# 856 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("constr"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ _ _ loc -> 
# 275 "plugins/ltac2/g_ltac2.mlg"
                                                               Tac2quote.of_constr c 
# 873 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("'")))))
                            ((Procq.Symbol.nterm Constr.constr)))
                           (fun c _ loc -> 
# 274 "plugins/ltac2/g_ltac2.mlg"
                                    inj_open_constr loc c 
# 883 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 273 "plugins/ltac2/g_ltac2.mlg"
                                Tac2quote.of_hyp ~loc id 
# 893 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                            ((Procq.Symbol.nterm Prim.ident)))
                           (fun id _ loc -> 
# 272 "plugins/ltac2/g_ltac2.mlg"
                                  Tac2quote.of_ident (CAst.make ~loc id) 
# 903 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.qualid)))
                           (fun qid loc -> 
# 268 "plugins/ltac2/g_ltac2.mlg"
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CTacCst (RelId qid)
        else
          CAst.make ~loc @@ CTacRef (RelId qid) 
# 914 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.string)))
                           (fun s loc -> 
# 266 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CTacAtm (AtmStr s) 
# 922 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.integer)))
                           (fun n loc -> 
# 265 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CTacAtm (AtmInt n) 
# 930 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2expr_in_env) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:11")
  tac2expr_in_env
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun tac loc -> 
# 292 "plugins/ltac2/g_ltac2.mlg"
                              [], tac 
# 944 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_ltac1_env)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm ltac2_expr)))
                           (fun e _ ids _ loc -> 
# 285 "plugins/ltac2/g_ltac2.mlg"
        let check { CAst.v = id; CAst.loc = loc } =
          if Tac2env.is_constructor (Libnames.qualid_of_ident ?loc id) then
            CErrors.user_err ?loc Pp.(str "Invalid bound Ltac2 identifier " ++ Id.print id)
        in
        let () = List.iter check ids in
        (ids, e)
      
# 964 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty type_cast) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:12")
  type_cast
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm ltac2_type)))
                            (fun ty _ loc -> 
# 297 "plugins/ltac2/g_ltac2.mlg"
                                  Some ty 
# 980 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 296 "plugins/ltac2/g_ltac2.mlg"
             None 
# 986 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty let_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:13")
  let_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm let_binder)))
                               ((Procq.Symbol.nterm type_cast)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun te _ ty binder loc -> 
# 302 "plugins/ltac2/g_ltac2.mlg"
        let (pat, fn) = binder in
        let te = opt_fun ~loc fn ty te in
        (pat, te) 
# 1008 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty let_binder) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:14")
  let_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm input_fun)))))
                            (fun pats loc -> 
# 309 "plugins/ltac2/g_ltac2.mlg"
        match pats with
        | [{CAst.v=CPatVar _} as pat] -> (pat, [])
        | ({CAst.v=CPatVar (Name id)} as pat) :: args -> (pat, args)
        | [pat] -> (pat, [])
        | _ -> CErrors.user_err ~loc (str "Invalid pattern") 
# 1026 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_type) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:15")
  ltac2_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("5"), Some (Gramlib.Gramext.RightA),
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm ltac2_type)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                             ((Procq.Symbol.nterm ltac2_type)))
                            (fun t2 _ t1 loc -> 
# 318 "plugins/ltac2/g_ltac2.mlg"
                                                    CAst.make ~loc @@ CTypArrow (t1, t2) 
# 1044 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("2"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac2_type)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterml ltac2_type ("1"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("*"))])) false)))
                           (fun tl _ t loc -> 
# 321 "plugins/ltac2/g_ltac2.mlg"
        let tl = t :: tl in
        CAst.make ~loc @@ CTypRef (AbsKn (Tuple (List.length tl)), tl) 
# 1058 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("1"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             (Procq.Symbol.self))
                            ((Procq.Symbol.nterm Prim.qualid)))
                           (fun qid t loc -> 
# 324 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTypRef (RelId qid, [t]) 
# 1069 "plugins/ltac2/g_ltac2.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.qualid)))
                           (fun qid loc -> 
# 334 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ CTypRef (RelId qid, []) 
# 1078 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                          (fun _ loc -> 
# 333 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CTypVar Anonymous 
# 1086 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm ltac2_typevar)))
                          (fun id loc -> 
# 332 "plugins/ltac2/g_ltac2.mlg"
                                CAst.make ~loc @@ CTypVar (Name id) 
# 1094 "plugins/ltac2/g_ltac2.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterml ltac2_type ("5"))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           ((Procq.Symbol.opt (Procq.Symbol.nterm Prim.qualid))))
                          (fun qid _ p _ loc -> 
# 327 "plugins/ltac2/g_ltac2.mlg"
          match p, qid with
          | [t], None -> t
          | _, None -> CErrors.user_err ~loc (Pp.str "Syntax error")
          | ts, Some qid -> CAst.make ~loc @@ CTypRef (RelId qid, p)
        
# 1112 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binder) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:16")
  binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun l loc -> 
# 339 "plugins/ltac2/g_ltac2.mlg"
                            CAst.make ~loc (Name l) 
# 1126 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 338 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc Anonymous 
# 1134 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty input_fun) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:17")
  input_fun
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterml tac2pat ("0"))))
                            (fun b loc -> 
# 342 "plugins/ltac2/g_ltac2.mlg"
                                   b 
# 1148 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_body) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:18")
  tac2def_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm binder)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm input_fun))))
                               ((Procq.Symbol.nterm type_cast)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun e _ ty it name loc -> 
# 346 "plugins/ltac2/g_ltac2.mlg"
        (name, opt_fun ~loc it ty e) 
# 1170 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_val) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:19")
  tac2def_val
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm mut_flag)))
                              ((Procq.Symbol.nterm rec_flag)))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm tac2def_body)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                            (fun l isrec mut loc -> 
# 351 "plugins/ltac2/g_ltac2.mlg"
          StrVal (mut, isrec, l) 
# 1188 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_mut) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:20")
  tac2def_mut
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                                ((Procq.Symbol.nterm Prim.qualid)))
                               ((Procq.Symbol.opt (Procq.Symbol.rules 
                               [Procq.Rules.make (Procq.Rule.next_norec
                                                  (Procq.Rule.next_norec
                                                   (Procq.Rule.stop)
                                                   ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                  ((Procq.Symbol.nterm identref)))
                                                 (fun id _ loc -> 
# 355 "plugins/ltac2/g_ltac2.mlg"
                                                                       id 
# 1213 "plugins/ltac2/g_ltac2.ml"
)]))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun e _ old qid _ loc -> 
# 355 "plugins/ltac2/g_ltac2.mlg"
                                                                                                         StrMut (qid, old, e) 
# 1220 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2typ_knd) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:21")
  tac2typ_knd
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.nterm tac2rec_fields)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ t _ loc -> 
# 361 "plugins/ltac2/g_ltac2.mlg"
                                         CTydRec t 
# 1238 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm tac2alg_constructors)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ t _ loc -> 
# 360 "plugins/ltac2/g_ltac2.mlg"
                                                CTydAlg t 
# 1250 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ _ _ loc -> 
# 359 "plugins/ltac2/g_ltac2.mlg"
                            CTydOpn 
# 1262 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac2_type)))
                           (fun t loc -> 
# 358 "plugins/ltac2/g_ltac2.mlg"
                            CTydDef (Some t) 
# 1270 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2alg_constructors) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:22")
  tac2alg_constructors
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0sep ((Procq.Symbol.nterm tac2alg_constructor)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun cs loc -> 
# 365 "plugins/ltac2/g_ltac2.mlg"
                                                    cs 
# 1284 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm tac2alg_constructor)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun cs _ loc -> 
# 364 "plugins/ltac2/g_ltac2.mlg"
                                                         cs 
# 1294 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2alg_constructor) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:23")
  tac2alg_constructor
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm quoted_attributes)))
                                ((Procq.Symbol.nterm Prim.ident)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list0sep ((Procq.Symbol.nterm ltac2_type)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ args _ c atts loc -> 
# 370 "plugins/ltac2/g_ltac2.mlg"
          (atts, c, args) 
# 1316 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm quoted_attributes)))
                            ((Procq.Symbol.nterm Prim.ident)))
                           (fun c atts loc -> 
# 368 "plugins/ltac2/g_ltac2.mlg"
                                                      (atts, c, []) 
# 1326 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_fields) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:24")
  tac2rec_fields
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 376 "plugins/ltac2/g_ltac2.mlg"
             [] 
# 1338 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm tac2rec_field)))
                           (fun f loc -> 
# 375 "plugins/ltac2/g_ltac2.mlg"
                               [f] 
# 1346 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm tac2rec_field)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                           (fun _ f loc -> 
# 374 "plugins/ltac2/g_ltac2.mlg"
                                    [f] 
# 1356 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2rec_field)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm tac2rec_fields)))
                           (fun l _ f loc -> 
# 373 "plugins/ltac2/g_ltac2.mlg"
                                                        f :: l 
# 1368 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_field) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:25")
  tac2rec_field
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm mut_flag)))
                               ((Procq.Symbol.nterm Prim.ident)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm ltac2_type)))
                            (fun t _ id mut loc -> 
# 379 "plugins/ltac2/g_ltac2.mlg"
                                                                  (id, mut, t) 
# 1388 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_fieldexprs) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:26")
  tac2rec_fieldexprs
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 385 "plugins/ltac2/g_ltac2.mlg"
             [] 
# 1400 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm tac2rec_fieldexpr)))
                           (fun f loc -> 
# 384 "plugins/ltac2/g_ltac2.mlg"
                                  [f] 
# 1408 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm tac2rec_fieldexpr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                           (fun _ f loc -> 
# 383 "plugins/ltac2/g_ltac2.mlg"
                                        [f] 
# 1418 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2rec_fieldexpr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm tac2rec_fieldexprs)))
                           (fun l _ f loc -> 
# 382 "plugins/ltac2/g_ltac2.mlg"
                                                                f :: l 
# 1430 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_fieldexpr) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:27")
  tac2rec_fieldexpr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm Prim.qualid)))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                    ((Procq.Symbol.nterml ltac2_expr ("1"))))
                                                                    (fun e _
                                                                    loc -> 
                                                                    
# 388 "plugins/ltac2/g_ltac2.mlg"
                                                                         e 
# 1455 "plugins/ltac2/g_ltac2.ml"
)]))))
                            (fun e qid loc -> 
# 389 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CTacRef (RelId (Libnames.qualid_of_ident ~loc id))
          in
          RelId qid, e 
# 1467 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_fieldpats) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:28")
  tac2rec_fieldpats
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 403 "plugins/ltac2/g_ltac2.mlg"
             [] 
# 1479 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm tac2rec_fieldpat)))
                           (fun f loc -> 
# 402 "plugins/ltac2/g_ltac2.mlg"
                                 [f] 
# 1487 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm tac2rec_fieldpat)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                           (fun _ f loc -> 
# 401 "plugins/ltac2/g_ltac2.mlg"
                                       [f] 
# 1497 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm tac2rec_fieldpat)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm tac2rec_fieldpats)))
                           (fun l _ f loc -> 
# 400 "plugins/ltac2/g_ltac2.mlg"
                                                              f :: l 
# 1509 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2rec_fieldpat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:29")
  tac2rec_fieldpat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm Prim.qualid)))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                    ((Procq.Symbol.nterml tac2pat ("1"))))
                                                                    (fun e _
                                                                    loc -> 
                                                                    
# 406 "plugins/ltac2/g_ltac2.mlg"
                                                                      e 
# 1534 "plugins/ltac2/g_ltac2.ml"
)]))))
                            (fun e qid loc -> 
# 407 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CPatVar (Name id)
          in
          RelId qid, e 
# 1546 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2typ_prm) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:30")
  tac2typ_prm
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.nterm ltac2_typevar)))
                                                (fun id loc -> 
# 420 "plugins/ltac2/g_ltac2.mlg"
                                                   CAst.make ~loc id 
# 1566 "plugins/ltac2/g_ltac2.ml"
)])) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ ids _ loc -> 
# 420 "plugins/ltac2/g_ltac2.mlg"
                                                                                           ids 
# 1572 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac2_typevar)))
                           (fun id loc -> 
# 419 "plugins/ltac2/g_ltac2.mlg"
                                [CAst.make ~loc id] 
# 1580 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 418 "plugins/ltac2/g_ltac2.mlg"
             [] 
# 1586 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2typ_def) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:31")
  tac2typ_def
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm tac2typ_prm)))
                              ((Procq.Symbol.nterm Prim.qualid)))
                             ((Procq.Symbol.nterm tac2type_body)))
                            (fun b id prm loc -> 
# 424 "plugins/ltac2/g_ltac2.mlg"
                                                                    let (r, e) = b in (id, r, (prm, e)) 
# 1604 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2type_body) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:32")
  tac2type_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("::=")))))
                             ((Procq.Symbol.nterm tac2typ_knd)))
                            (fun e _ loc -> 
# 429 "plugins/ltac2/g_ltac2.mlg"
                                    true, e 
# 1620 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm tac2typ_knd)))
                           (fun e _ loc -> 
# 428 "plugins/ltac2/g_ltac2.mlg"
                                   false, e 
# 1630 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 427 "plugins/ltac2/g_ltac2.mlg"
             false, CTydDef None 
# 1636 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_typ) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:33")
  tac2def_typ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                              ((Procq.Symbol.nterm rec_flag)))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm tac2typ_def)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                            (fun l isrec _ loc -> 
# 434 "plugins/ltac2/g_ltac2.mlg"
          StrTyp (isrec, l) 
# 1654 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_ext) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:34")
  tac2def_ext
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next
                                   (Procq.Rule.next (Procq.Rule.stop)
                                    ((Procq.Symbol.token (Tok.PKEYWORD ("@")))))
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("external"))))))
                                  ((Procq.Symbol.nterm identref)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                ((Procq.Symbol.nterml ltac2_type ("5"))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterm Prim.string)))
                             ((Procq.Symbol.nterm Prim.string)))
                            (fun name plugin _ t _ id _ _ loc -> 
# 440 "plugins/ltac2/g_ltac2.mlg"
        let ml = { mltac_plugin = plugin; mltac_tactic = name } in
        StrPrm (id, t, ml) 
# 1684 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty syn_node) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:35")
  syn_node
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id loc -> 
# 446 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc (Some id) 
# 1698 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 445 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc None 
# 1706 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_syntax_class) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:36")
  ltac2_syntax_class
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm syn_node)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm ltac2_syntax_class)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ tok _ id loc -> 
# 454 "plugins/ltac2/g_ltac2.mlg"
          SexprRec (loc, id, tok) 
# 1726 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm syn_node)))
                           (fun id loc -> 
# 452 "plugins/ltac2/g_ltac2.mlg"
                           SexprRec (loc, id, []) 
# 1734 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.integer)))
                           (fun n loc -> 
# 451 "plugins/ltac2/g_ltac2.mlg"
                              SexprInt (CAst.make ~loc n) 
# 1742 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.string)))
                           (fun s loc -> 
# 450 "plugins/ltac2/g_ltac2.mlg"
                             SexprStr (CAst.make ~loc s) 
# 1750 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty syn_level) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:37")
  syn_level
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm Prim.natural)))
                            (fun n _ loc -> 
# 459 "plugins/ltac2/g_ltac2.mlg"
                                   Some n 
# 1766 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 458 "plugins/ltac2/g_ltac2.mlg"
             None 
# 1772 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tac2def_syn) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:38")
  tac2def_syn
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.list1 ((Procq.Symbol.nterm ltac2_syntax_class)))))
                               ((Procq.Symbol.nterm syn_level)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun e _ n toks loc -> 
# 465 "plugins/ltac2/g_ltac2.mlg"
          (toks, n, e) 
# 1792 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty globref) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:39")
  globref
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.qualid)))
                            (fun qid loc -> 
# 470 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QReference qid 
# 1806 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                            ((Procq.Symbol.nterm Prim.ident)))
                           (fun id _ loc -> 
# 469 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc (QHypothesis id) 
# 1816 "plugins/ltac2/g_ltac2.ml"
)])]))
  in ()


# 477 "plugins/ltac2/g_ltac2.mlg"
 

open Tac2entries.Pltac


# 1827 "plugins/ltac2/g_ltac2.ml"

let _ =
  let anti = Procq.Entry.make "anti"
  and ident_or_anti = Procq.Entry.make "ident_or_anti"
  and lnatural = Procq.Entry.make "lnatural"
  and qhyp = Procq.Entry.make "qhyp"
  and simple_binding = Procq.Entry.make "simple_binding"
  and bindings = Procq.Entry.make "bindings"
  and intropatterns = Procq.Entry.make "intropatterns"
  and or_and_intropattern = Procq.Entry.make "or_and_intropattern"
  and equality_intropattern = Procq.Entry.make "equality_intropattern"
  and naming_intropattern = Procq.Entry.make "naming_intropattern"
  and nonsimple_intropattern = Procq.Entry.make "nonsimple_intropattern"
  and simple_intropattern = Procq.Entry.make "simple_intropattern"
  and simple_intropattern_closed =
    Procq.Entry.make "simple_intropattern_closed"
  and nat_or_anti = Procq.Entry.make "nat_or_anti"
  and eqn_ipat = Procq.Entry.make "eqn_ipat"
  and with_bindings = Procq.Entry.make "with_bindings"
  and constr_with_bindings = Procq.Entry.make "constr_with_bindings"
  and destruction_arg = Procq.Entry.make "destruction_arg"
  and as_or_and_ipat = Procq.Entry.make "as_or_and_ipat"
  and occs_nums = Procq.Entry.make "occs_nums"
  and occs = Procq.Entry.make "occs"
  and hypident = Procq.Entry.make "hypident"
  and hypident_occ = Procq.Entry.make "hypident_occ"
  and in_clause = Procq.Entry.make "in_clause"
  and clause = Procq.Entry.make "clause"
  and concl_occ = Procq.Entry.make "concl_occ"
  and induction_clause = Procq.Entry.make "induction_clause"
  and conversion = Procq.Entry.make "conversion"
  and rewriter = Procq.Entry.make "rewriter"
  and oriented_rewriter = Procq.Entry.make "oriented_rewriter"
  and tactic_then_last = Procq.Entry.make "tactic_then_last"
  and for_each_goal = Procq.Entry.make "for_each_goal"
  and ltac2_red_flag = Procq.Entry.make "ltac2_red_flag"
  and refglobal = Procq.Entry.make "refglobal"
  and refglobals = Procq.Entry.make "refglobals"
  and delta_flag = Procq.Entry.make "delta_flag"
  and strategy_flag = Procq.Entry.make "strategy_flag"
  and hintdb = Procq.Entry.make "hintdb"
  and match_pattern = Procq.Entry.make "match_pattern"
  and match_rule = Procq.Entry.make "match_rule"
  and match_list = Procq.Entry.make "match_list"
  and gmatch_hyp_pattern = Procq.Entry.make "gmatch_hyp_pattern"
  and gmatch_pattern = Procq.Entry.make "gmatch_pattern"
  and gmatch_rule = Procq.Entry.make "gmatch_rule"
  and goal_match_list = Procq.Entry.make "goal_match_list"
  and move_location = Procq.Entry.make "move_location"
  and as_name = Procq.Entry.make "as_name"
  and pose = Procq.Entry.make "pose"
  and as_ipat = Procq.Entry.make "as_ipat"
  and by_tactic = Procq.Entry.make "by_tactic"
  and assertion = Procq.Entry.make "assertion"
  in
  let () = assert (Procq.Entry.is_empty anti) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:40")
  anti
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("$")))))
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id _ loc -> 
# 489 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
# 1897 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ident_or_anti) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:41")
  ident_or_anti
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("$")))))
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id _ loc -> 
# 493 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
# 1913 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm identref)))
                           (fun id loc -> 
# 492 "plugins/ltac2/g_ltac2.mlg"
                           QExpr id 
# 1921 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty lnatural) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:42")
  lnatural
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Prim.natural)))
                            (fun n loc -> 
# 497 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc n 
# 1935 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_ident) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:43")
  q_ident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident_or_anti)))
                            (fun id loc -> 
# 500 "plugins/ltac2/g_ltac2.mlg"
                                id 
# 1949 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty qhyp) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:44")
  qhyp
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun id loc -> 
# 505 "plugins/ltac2/g_ltac2.mlg"
                           QExpr (CAst.make ~loc @@ QNamedHyp id) 
# 1963 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm lnatural)))
                           (fun n loc -> 
# 504 "plugins/ltac2/g_ltac2.mlg"
                          QExpr (CAst.make ~loc @@ QAnonHyp n) 
# 1971 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm anti)))
                           (fun x loc -> 
# 503 "plugins/ltac2/g_ltac2.mlg"
                      x 
# 1979 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_binding) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:45")
  simple_binding
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm qhyp)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterm Constr.lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ c _ h _ loc -> 
# 510 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (h, c) 
# 2001 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:46")
  bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm Constr.constr)))))
                            (fun bl loc -> 
# 517 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QImplicitBindings bl 
# 2015 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm test_lpar_idnum_coloneq)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm simple_binding)))))
                           (fun bl _ loc -> 
# 515 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QExplicitBindings bl 
# 2025 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:47")
  q_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm bindings)))
                            (fun bl loc -> 
# 521 "plugins/ltac2/g_ltac2.mlg"
                           bl 
# 2039 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_with_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:48")
  q_with_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm with_bindings)))
                            (fun bl loc -> 
# 524 "plugins/ltac2/g_ltac2.mlg"
                                bl 
# 2053 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty intropatterns) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:49")
  intropatterns
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm nonsimple_intropattern))))
                            (fun l loc -> 
# 527 "plugins/ltac2/g_ltac2.mlg"
                                              CAst.make ~loc l 
# 2067 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty or_and_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:50")
  or_and_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm simple_intropattern)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm simple_intropattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("&"))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ tc _ si _ loc -> 
# 542 "plugins/ltac2/g_ltac2.mlg"
          let rec pairify = function
            | ([]|[_]|[_;_]) as l -> CAst.make ~loc l
            | t::q ->
              let q =
                CAst.make ~loc @@
                  QIntroAction (CAst.make ~loc @@
                    QIntroOrAndPattern (CAst.make ~loc @@
                      QIntroAndPattern (pairify q)))
              in
              CAst.make ~loc [t; q]
          in CAst.make ~loc @@ QIntroAndPattern (pairify (si::tc)) 
# 2099 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm simple_intropattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm simple_intropattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ tc _ si _ loc -> 
# 538 "plugins/ltac2/g_ltac2.mlg"
               CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc (si::tc)) 
# 2115 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm simple_intropattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ si _ loc -> 
# 535 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc [si]) 
# 2127 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                           (fun _ loc -> 
# 534 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc []) 
# 2135 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm intropatterns)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ tc _ loc -> 
# 533 "plugins/ltac2/g_ltac2.mlg"
                                                        CAst.make ~loc @@ QIntroOrPattern tc 
# 2147 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty equality_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:51")
  equality_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_leftsquarebracket_equal)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                              ((Procq.Symbol.nterm intropatterns)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ tc _ _ _ loc -> 
# 557 "plugins/ltac2/g_ltac2.mlg"
                                                                             CAst.make ~loc @@ QIntroInjection tc 
# 2169 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                           (fun _ loc -> 
# 556 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite false 
# 2177 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                           (fun _ loc -> 
# 555 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite true 
# 2185 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty naming_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:52")
  naming_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident_or_anti)))
                            (fun id loc -> 
# 567 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroIdentifier id 
# 2199 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                           (fun _ loc -> 
# 565 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAnonymous 
# 2207 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("?$")))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 563 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QAnti id) 
# 2217 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 561 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QExpr id) 
# 2227 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty nonsimple_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:53")
  nonsimple_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("**")))))
                            (fun _ loc -> 
# 573 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming false 
# 2241 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ loc -> 
# 572 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming true 
# 2249 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm simple_intropattern)))
                           (fun l loc -> 
# 571 "plugins/ltac2/g_ltac2.mlg"
                                     l 
# 2257 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:54")
  simple_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm simple_intropattern_closed)))
                             ((Procq.Symbol.list0 (Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                                                ((Procq.Symbol.nterml Constr.term ("0"))))
                                               (fun c _ loc -> 
# 577 "plugins/ltac2/g_ltac2.mlg"
                                                        c 
# 2278 "plugins/ltac2/g_ltac2.ml"
)]))))
                            (fun l pat loc -> 
# 578 "plugins/ltac2/g_ltac2.mlg"
          let mk c pat =
            CAst.make ~loc @@ QIntroAction
              (CAst.make ~loc @@ QIntroApplyOn (c, pat))
          in
          List.fold_right mk l pat
        
# 2288 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_intropattern_closed)
  in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:55")
  simple_intropattern_closed
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm naming_intropattern)))
                            (fun pat loc -> 
# 594 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroNaming pat 
# 2303 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 592 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroWildcard) 
# 2311 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm equality_intropattern)))
                           (fun pat loc -> 
# 590 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction pat 
# 2319 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm or_and_intropattern)))
                           (fun pat loc -> 
# 588 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroOrAndPattern pat) 
# 2327 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_intropatterns) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:56")
  q_intropatterns
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm intropatterns)))
                            (fun ipat loc -> 
# 598 "plugins/ltac2/g_ltac2.mlg"
                                  ipat 
# 2341 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:57")
  q_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm simple_intropattern)))
                            (fun ipat loc -> 
# 601 "plugins/ltac2/g_ltac2.mlg"
                                        ipat 
# 2355 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty nat_or_anti) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:58")
  nat_or_anti
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("$")))))
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id _ loc -> 
# 605 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
# 2371 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm lnatural)))
                           (fun n loc -> 
# 604 "plugins/ltac2/g_ltac2.mlg"
                          QExpr n 
# 2379 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty eqn_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:59")
  eqn_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 610 "plugins/ltac2/g_ltac2.mlg"
             None 
# 2391 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eqn"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm naming_intropattern)))
                           (fun pat _ _ loc -> 
# 609 "plugins/ltac2/g_ltac2.mlg"
                                                         Some pat 
# 2404 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty with_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:60")
  with_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 614 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QNoBindings 
# 2416 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm bindings)))
                           (fun bl _ loc -> 
# 614 "plugins/ltac2/g_ltac2.mlg"
                                   bl 
# 2426 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr_with_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:61")
  constr_with_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm Constr.constr)))
                             ((Procq.Symbol.nterm with_bindings)))
                            (fun l c loc -> 
# 617 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ (c, l) 
# 2442 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty destruction_arg) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:62")
  destruction_arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_with_bindings)))
                            (fun c loc -> 
# 622 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc @@ QElimOnConstr c 
# 2456 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm identref)))
                           (fun id loc -> 
# 621 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QElimOnIdent id 
# 2464 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm lnatural)))
                           (fun n loc -> 
# 620 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QElimOnAnonHyp n 
# 2472 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_destruction_arg) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:63")
  q_destruction_arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm destruction_arg)))
                            (fun arg loc -> 
# 626 "plugins/ltac2/g_ltac2.mlg"
                                   arg 
# 2486 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_or_and_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:64")
  as_or_and_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 630 "plugins/ltac2/g_ltac2.mlg"
             None 
# 2498 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm or_and_intropattern)))
                           (fun ipat _ loc -> 
# 629 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
# 2508 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty occs_nums) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:65")
  occs_nums
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                              ((Procq.Symbol.nterm nat_or_anti)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm nat_or_anti))))
                            (fun nl n _ loc -> 
# 636 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QAllOccurrencesBut (n::nl) 
# 2526 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm nat_or_anti)))))
                           (fun nl loc -> 
# 634 "plugins/ltac2/g_ltac2.mlg"
                                    CAst.make ~loc @@ QOnlyOccurrences nl 
# 2534 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty occs) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:66")
  occs
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 640 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc QAllOccurrences 
# 2546 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.nterm occs_nums)))
                           (fun occs _ loc -> 
# 640 "plugins/ltac2/g_ltac2.mlg"
                                    occs 
# 2556 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hypident) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:67")
  hypident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("value"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("of"))))))
                              ((Procq.Symbol.nterm ident_or_anti)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ id _ _ _ loc -> 
# 648 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypValueOnly 
# 2580 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("type"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("of"))))))
                             ((Procq.Symbol.nterm ident_or_anti)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ id _ _ _ loc -> 
# 646 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypTypeOnly 
# 2598 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ident_or_anti)))
                           (fun id loc -> 
# 644 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHyp 
# 2606 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hypident_occ) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:68")
  hypident_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm hypident)))
                             ((Procq.Symbol.nterm occs)))
                            (fun occs h loc -> 
# 652 "plugins/ltac2/g_ltac2.mlg"
                                   let (id,l) = h in ((occs,id),l) 
# 2622 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty in_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:69")
  in_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0sep ((Procq.Symbol.nterm hypident_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            (fun hl loc -> 
# 662 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = CAst.make ~loc QNoOccurrences } 
# 2636 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.list0sep ((Procq.Symbol.nterm hypident_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm concl_occ)))
                           (fun occs _ hl loc -> 
# 660 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = occs } 
# 2648 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm concl_occ)))
                           (fun occs _ _ loc -> 
# 658 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
# 2660 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            ((Procq.Symbol.nterm occs)))
                           (fun occs _ loc -> 
# 656 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
# 2670 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:70")
  clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.nterm occs_nums)))
                            (fun occs _ loc -> 
# 668 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ { q_onhyps = Some []; q_concl_occs = occs } 
# 2686 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterm in_clause)))
                           (fun cl _ loc -> 
# 666 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ cl 
# 2696 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:71")
  q_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm clause)))
                            (fun cl loc -> 
# 672 "plugins/ltac2/g_ltac2.mlg"
                         cl 
# 2710 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty concl_occ) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:72")
  concl_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 676 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc QNoOccurrences 
# 2722 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            ((Procq.Symbol.nterm occs)))
                           (fun occs _ loc -> 
# 675 "plugins/ltac2/g_ltac2.mlg"
                              occs 
# 2732 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty induction_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:73")
  induction_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm destruction_arg)))
                               ((Procq.Symbol.nterm as_or_and_ipat)))
                              ((Procq.Symbol.nterm eqn_ipat)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm clause))))
                            (fun cl eq pat c loc -> 
# 682 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc @@ {
          indcl_arg = c;
          indcl_eqn = eq;
          indcl_as = pat;
          indcl_in = cl;
        } 
# 2757 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_induction_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:74")
  q_induction_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm induction_clause)))
                            (fun cl loc -> 
# 691 "plugins/ltac2/g_ltac2.mlg"
                                   cl 
# 2771 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty conversion) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:75")
  conversion
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm Constr.constr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                             ((Procq.Symbol.nterm Constr.constr)))
                            (fun c2 _ c1 loc -> 
# 697 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvertWith (c1, c2) 
# 2789 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Constr.constr)))
                           (fun c loc -> 
# 695 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvert c 
# 2797 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_conversion) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:76")
  q_conversion
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm conversion)))
                            (fun c loc -> 
# 701 "plugins/ltac2/g_ltac2.mlg"
                            c 
# 2811 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_orient) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:77")
  q_orient
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 706 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc None 
# 2823 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                           (fun _ loc -> 
# 705 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some false) 
# 2831 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                           (fun _ loc -> 
# 704 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some true) 
# 2839 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rewriter) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:78")
  rewriter
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_with_bindings)))
                            (fun c loc -> 
# 721 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely (CAst.make 1), c) 
# 2853 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm lnatural)))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c n loc -> 
# 719 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
# 2863 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm lnatural)))
                             ((Procq.Symbol.rules [Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 716 "plugins/ltac2/g_ltac2.mlg"
                                                      () 
# 2879 "plugins/ltac2/g_ltac2.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 716 "plugins/ltac2/g_ltac2.mlg"
                                () 
# 2889 "plugins/ltac2/g_ltac2.ml"
)])))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c _ n loc -> 
# 717 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QUpTo n,c) 
# 2895 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm lnatural)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c _ n loc -> 
# 715 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
# 2907 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.rules [Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 712 "plugins/ltac2/g_ltac2.mlg"
                                         () 
# 2921 "plugins/ltac2/g_ltac2.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 712 "plugins/ltac2/g_ltac2.mlg"
                   () 
# 2931 "plugins/ltac2/g_ltac2.ml"
)])))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c _ loc -> 
# 713 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatStar,c) 
# 2937 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c _ loc -> 
# 711 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatPlus,c) 
# 2947 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty oriented_rewriter) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:79")
  oriented_rewriter
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm q_orient)))
                             ((Procq.Symbol.nterm rewriter)))
                            (fun r b loc -> 
# 726 "plugins/ltac2/g_ltac2.mlg"
        let (m, c) = r in
        CAst.make ~loc @@ {
        rew_orient = b;
        rew_repeat = m;
        rew_equatn = c;
      } 
# 2968 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_rewriting) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:80")
  q_rewriting
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm oriented_rewriter)))
                            (fun r loc -> 
# 735 "plugins/ltac2/g_ltac2.mlg"
                                   r 
# 2982 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_then_last) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:81")
  tactic_then_last
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 739 "plugins/ltac2/g_ltac2.mlg"
             [] 
# 2994 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list0sep ((Procq.Symbol.opt (Procq.Symbol.nterml ltac2_expr ("6")))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun lta _ loc -> 
# 738 "plugins/ltac2/g_ltac2.mlg"
                                                                 lta 
# 3004 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty for_each_goal) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:82")
  for_each_goal
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 748 "plugins/ltac2/g_ltac2.mlg"
             ([None], None) 
# 3016 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.nterm for_each_goal)))
                           (fun tg _ loc -> 
# 747 "plugins/ltac2/g_ltac2.mlg"
                                     let (first,last) = tg in (None :: first, last) 
# 3026 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac2_expr)))
                           (fun ta loc -> 
# 746 "plugins/ltac2/g_ltac2.mlg"
                             ([Some ta], None) 
# 3034 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.nterm tactic_then_last)))
                           (fun l _ loc -> 
# 745 "plugins/ltac2/g_ltac2.mlg"
                                        ([], Some (None, l)) 
# 3044 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac2_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.nterm tactic_then_last)))
                           (fun l _ ta loc -> 
# 744 "plugins/ltac2/g_ltac2.mlg"
                                                         ([], Some (Some ta, l)) 
# 3056 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac2_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.nterm for_each_goal)))
                           (fun tg _ ta loc -> 
# 743 "plugins/ltac2/g_ltac2.mlg"
                                                      let (first,last) = tg in (Some ta :: first, last) 
# 3068 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_dispatch) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:83")
  q_dispatch
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm for_each_goal)))
                            (fun d loc -> 
# 752 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc d 
# 3082 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_occurrences) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:84")
  q_occurrences
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm occs)))
                            (fun occs loc -> 
# 755 "plugins/ltac2/g_ltac2.mlg"
                         occs 
# 3096 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac2_red_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:85")
  ltac2_red_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("head"))))))
                            (fun _ loc -> 
# 765 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QHead 
# 3111 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("delta"))))))
                            ((Procq.Symbol.nterm delta_flag)))
                           (fun d _ loc -> 
# 764 "plugins/ltac2/g_ltac2.mlg"
                                           d 
# 3122 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("zeta"))))))
                           (fun _ loc -> 
# 763 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QZeta 
# 3131 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("cofix"))))))
                           (fun _ loc -> 
# 762 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QCofix 
# 3140 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("fix"))))))
                           (fun _ loc -> 
# 761 "plugins/ltac2/g_ltac2.mlg"
                         CAst.make ~loc @@ QFix 
# 3149 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("match"))))))
                           (fun _ loc -> 
# 760 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QMatch 
# 3158 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("iota"))))))
                           (fun _ loc -> 
# 759 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QIota 
# 3167 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("beta"))))))
                           (fun _ loc -> 
# 758 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QBeta 
# 3176 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty refglobal) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:86")
  refglobal
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("$")))))
                             ((Procq.Symbol.nterm Prim.ident)))
                            (fun id _ loc -> 
# 771 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
# 3192 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Prim.qualid)))
                           (fun qid loc -> 
# 770 "plugins/ltac2/g_ltac2.mlg"
                               QExpr (CAst.make ~loc @@ QReference qid) 
# 3200 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                            ((Procq.Symbol.nterm Prim.ident)))
                           (fun id _ loc -> 
# 769 "plugins/ltac2/g_ltac2.mlg"
                                  QExpr (CAst.make ~loc @@ QHypothesis id) 
# 3210 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_reference) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:87")
  q_reference
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm refglobal)))
                            (fun r loc -> 
# 775 "plugins/ltac2/g_ltac2.mlg"
                           r 
# 3224 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty refglobals) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:88")
  refglobals
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm refglobal)))))
                            (fun gl loc -> 
# 778 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc gl 
# 3238 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty delta_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:89")
  delta_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 783 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc @@ QDeltaBut (CAst.make ~loc []) 
# 3250 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm refglobals)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ idl _ loc -> 
# 782 "plugins/ltac2/g_ltac2.mlg"
                                        CAst.make ~loc @@ QConst idl 
# 3262 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm refglobals)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ idl _ _ loc -> 
# 781 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ QDeltaBut idl 
# 3276 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty strategy_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:90")
  strategy_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm delta_flag)))
                            (fun d loc -> 
# 789 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc
          [CAst.make ~loc QBeta; CAst.make ~loc QIota; CAst.make ~loc QZeta; d] 
# 3291 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm ltac2_red_flag)))))
                           (fun s loc -> 
# 787 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc s 
# 3299 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_strategy_flag) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:91")
  q_strategy_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm strategy_flag)))
                            (fun flag loc -> 
# 794 "plugins/ltac2/g_ltac2.mlg"
                                  flag 
# 3313 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hintdb) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:92")
  hintdb
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm ident_or_anti)))))
                            (fun l loc -> 
# 798 "plugins/ltac2/g_ltac2.mlg"
                                     CAst.make ~loc @@ QHintDbs l 
# 3327 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ loc -> 
# 797 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ QHintAll 
# 3335 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_hintdb) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:93")
  q_hintdb
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm hintdb)))
                            (fun db loc -> 
# 802 "plugins/ltac2/g_ltac2.mlg"
                         db 
# 3349 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_pattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:94")
  match_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Constr.cpattern)))
                            (fun pat loc -> 
# 807 "plugins/ltac2/g_ltac2.mlg"
                                   CAst.make ~loc @@ QConstrMatchPattern pat 
# 3363 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("context"))))))
                               ((Procq.Symbol.opt (Procq.Symbol.nterm Prim.ident))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm Constr.cpattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ pat _ id _ loc -> 
# 806 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QConstrMatchContext (id, pat) 
# 3380 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_rule) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:95")
  match_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm match_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun tac _ mp loc -> 
# 811 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
# 3398 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:96")
  match_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun mrl _ loc -> 
# 816 "plugins/ltac2/g_ltac2.mlg"
                                                 CAst.make ~loc @@ mrl 
# 3414 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun mrl loc -> 
# 815 "plugins/ltac2/g_ltac2.mlg"
                                            CAst.make ~loc @@ mrl 
# 3422 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_constr_matching) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:97")
  q_constr_matching
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm match_list)))
                            (fun m loc -> 
# 819 "plugins/ltac2/g_ltac2.mlg"
                            m 
# 3436 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty gmatch_hyp_pattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:98")
  gmatch_hyp_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm Prim.name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm match_pattern)))
                            (fun bod _ na loc -> 
# 826 "plugins/ltac2/g_ltac2.mlg"
          let bod, ty = match bod.CAst.v with
              | QConstrMatchPattern { CAst.v = CCast (t, Some DEFAULTcast, ty) } ->
                let t = CAst.make ?loc:t.loc @@ QConstrMatchPattern t in
                let ty = CAst.make ?loc:ty.loc @@ QConstrMatchPattern ty in
                t, ty
              | _ ->
                let ty = CAst.make @@ QConstrMatchPattern (CAst.make @@ CHole None) in
                bod, ty
          in
          (na, Some bod, ty) 
# 3463 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.nterm Prim.name)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.nterm match_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm match_pattern)))
                           (fun pat _ _ bod _ _ na loc -> 
# 824 "plugins/ltac2/g_ltac2.mlg"
          (na, Some bod, pat) 
# 3483 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm Prim.name)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm match_pattern)))
                           (fun pat _ na loc -> 
# 822 "plugins/ltac2/g_ltac2.mlg"
                                                      (na, None, pat) 
# 3495 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty gmatch_pattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:99")
  gmatch_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                ((Procq.Symbol.list0sep ((Procq.Symbol.nterm gmatch_hyp_pattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                              ((Procq.Symbol.nterm match_pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ p _ hl _ loc -> 
# 840 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ {
          q_goal_match_concl = p;
          q_goal_match_hyps = hl;
        } 
# 3520 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty gmatch_rule) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:100")
  gmatch_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm gmatch_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm ltac2_expr)))
                            (fun tac _ mp loc -> 
# 848 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
# 3538 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty goal_match_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:101")
  goal_match_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm gmatch_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun mrl _ loc -> 
# 853 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ mrl 
# 3554 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm gmatch_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun mrl loc -> 
# 852 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ mrl 
# 3562 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_goal_matching) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:102")
  q_goal_matching
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm goal_match_list)))
                            (fun m loc -> 
# 856 "plugins/ltac2/g_ltac2.mlg"
                                 m 
# 3576 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty move_location) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:103")
  move_location
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("before"))))))
                             ((Procq.Symbol.nterm ident_or_anti)))
                            (fun id _ loc -> 
# 862 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QMoveBefore id 
# 3593 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("after"))))))
                            ((Procq.Symbol.nterm ident_or_anti)))
                           (fun id _ loc -> 
# 861 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QMoveAfter id 
# 3604 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("bottom"))))))
                           (fun _ _ loc -> 
# 860 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ QMoveLast 
# 3615 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("top"))))))
                           (fun _ _ loc -> 
# 859 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QMoveFirst 
# 3626 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_move_location) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:104")
  q_move_location
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm move_location)))
                            (fun mv loc -> 
# 866 "plugins/ltac2/g_ltac2.mlg"
                                mv 
# 3640 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_name) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:105")
  as_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                             ((Procq.Symbol.nterm ident_or_anti)))
                            (fun id _ loc -> 
# 870 "plugins/ltac2/g_ltac2.mlg"
                                      Some id 
# 3656 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 869 "plugins/ltac2/g_ltac2.mlg"
             None 
# 3662 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty pose) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:106")
  pose
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm Constr.constr)))
                             ((Procq.Symbol.nterm as_name)))
                            (fun na c loc -> 
# 876 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc (na, c) 
# 3678 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm ident_or_anti)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ _ loc -> 
# 875 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (Some id, c) 
# 3696 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_pose) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:107")
  q_pose
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm pose)))
                            (fun p loc -> 
# 880 "plugins/ltac2/g_ltac2.mlg"
                      p 
# 3710 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:108")
  as_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 884 "plugins/ltac2/g_ltac2.mlg"
             None 
# 3722 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm simple_intropattern)))
                           (fun ipat _ loc -> 
# 883 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
# 3732 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty by_tactic) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:109")
  by_tactic
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 889 "plugins/ltac2/g_ltac2.mlg"
             None 
# 3744 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("by")))))
                            ((Procq.Symbol.nterml ltac2_expr ("5"))))
                           (fun tac _ loc -> 
# 888 "plugins/ltac2/g_ltac2.mlg"
                                              Some tac 
# 3754 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assertion) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:110")
  assertion
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm Constr.constr)))
                              ((Procq.Symbol.nterm as_ipat)))
                             ((Procq.Symbol.nterm by_tactic)))
                            (fun tac ipat c loc -> 
# 899 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertType (ipat, c, tac)) 
# 3772 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.nterm test_lpar_id_colon)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm ident_or_anti)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm Constr.lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac _ c _ id _ _ loc -> 
# 896 "plugins/ltac2/g_ltac2.mlg"
        let ipat = CAst.make ~loc @@ QIntroNaming (CAst.make ~loc @@ QIntroIdentifier id) in
        CAst.make ~loc (QAssertType (Some ipat, c, tac)) 
# 3793 "plugins/ltac2/g_ltac2.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm ident_or_anti)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ _ loc -> 
# 894 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertValue (id, c)) 
# 3811 "plugins/ltac2/g_ltac2.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty q_assert) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:111")
  q_assert
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm assertion)))
                            (fun a loc -> 
# 903 "plugins/ltac2/g_ltac2.mlg"
                           a 
# 3825 "plugins/ltac2/g_ltac2.ml"
)])]))
  in ()


# 927 "plugins/ltac2/g_ltac2.mlg"
 

let () =

let open Tok in
let (++) r s = Procq.Rule.next r s in
let rules = [
  Procq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident ++ Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let id = CAst.make ~loc id in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (None, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Procq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident_colon_ident ++
       Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.identref ++
       Symbol.token (PKEYWORD ":") ++ Symbol.nterm Prim.identref)
    begin fun id _ kind _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (Some kind, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Procq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_ampersand_ident ++ Symbol.token (PKEYWORD "&") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let tac = Tac2quote.of_exact_hyp ~loc (CAst.make ~loc id) in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Procq.(
    Production.make
      (Rule.stop ++ Symbol.token (PIDENT (Some "ltac2")) ++ Symbol.token (PKEYWORD ":") ++
       Symbol.token (PKEYWORD "(") ++ Symbol.nterm ltac2_expr ++ Symbol.token (PKEYWORD ")"))
    begin fun _ tac _ _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  )
] in

  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:adhoc1")
    Procq.Constr.term (Procq.Reuse (Some"0", rules))



# 3885 "plugins/ltac2/g_ltac2.ml"


# 982 "plugins/ltac2/g_ltac2.mlg"
 

let pr_ltac2entry = Tac2print.pr_strexpr
let pr_ltac2expr e = Tac2print.pr_rawexpr_gen E5 ~avoid:Id.Set.empty e
let pr_ltac2def_syn (a,b,c) = Tac2entries.pr_register_notation a b c


# 3896 "plugins/ltac2/g_ltac2.ml"

let (wit_ltac2_entry, ltac2_entry) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"ltac2_entry" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm tac2def_mut)))
       (fun e loc -> 
# 995 "plugins/ltac2/g_ltac2.mlg"
                          e 
# 3908 "plugins/ltac2/g_ltac2.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm tac2def_ext)))
      (fun e loc -> 
# 994 "plugins/ltac2/g_ltac2.mlg"
                          e 
# 3915 "plugins/ltac2/g_ltac2.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm tac2def_typ)))
      (fun t loc -> 
# 993 "plugins/ltac2/g_ltac2.mlg"
                          t 
# 3922 "plugins/ltac2/g_ltac2.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm tac2def_val)))
      (fun v loc -> 
# 992 "plugins/ltac2/g_ltac2.mlg"
                          v 
# 3929 "plugins/ltac2/g_ltac2.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 991 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2entry 
# 3934 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_ltac2_entry, ltac2_entry)

let (wit_ltac2def_syn, ltac2def_syn) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"ltac2def_syn" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (tac2def_syn);
    Vernacextend.arg_printer = fun env sigma -> 
# 999 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2def_syn 
# 3947 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_ltac2def_syn, ltac2def_syn)

let (wit_ltac2_expr, ltac2_expr) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"ltac2_expr" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (_ltac2_expr);
    Vernacextend.arg_printer = fun env sigma -> 
# 1004 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2expr 
# 3960 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_ltac2_expr, ltac2_expr)


# 1008 "plugins/ltac2/g_ltac2.mlg"
 

let names_of_strexpr = function
| StrVal(_, _, l) ->
  List.concat_map (fun (na, _) -> match na.CAst.v with Anonymous -> [] | Name id -> [id]) l
| StrTyp(_, l) ->
  List.map (fun (qid, _, _) -> Libnames.qualid_basename qid) l
| _ -> []


# 3977 "plugins/ltac2/g_ltac2.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~command:"VernacDeclareTactic2Definition"  ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac2",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_entry),
           Vernacextend.TyNil)),
          (let coqpp_body e raw_attributes =
            Vernactypes.vtdefault (fun () -> 
# 1022 "plugins/ltac2/g_ltac2.mlg"
        
    Tac2entries.register_struct raw_attributes e
  
# 3992 "plugins/ltac2/g_ltac2.ml"
) in fun e ?loc ~atts () ->
            coqpp_body e (Attributes.parse 
# 1020 "plugins/ltac2/g_ltac2.mlg"
      raw_attributes
# 3997 "plugins/ltac2/g_ltac2.ml"
 atts)),
          Some (fun e  ~atts -> 
# 1020 "plugins/ltac2/g_ltac2.mlg"
                                                     
    VtSideff (names_of_strexpr e, VtLater)
  
# 4004 "plugins/ltac2/g_ltac2.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac2",
           Vernacextend.TyTerminal
           ("Notation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2def_syn),
            Vernacextend.TyNil))),
          (let coqpp_body e raw_attributes =
            (let synterpv = 
# 1025 "plugins/ltac2/g_ltac2.mlg"
                                                                                                                             
    let (toks, n, body) = e in
    Tac2entries.register_notation raw_attributes toks n body
  
# 4021 "plugins/ltac2/g_ltac2.ml"
 in Vernactypes.vtdefault (fun () -> 
# 1029 "plugins/ltac2/g_ltac2.mlg"
   
    Tac2entries.register_notation_interpretation synterpv
  
# 4027 "plugins/ltac2/g_ltac2.ml"
)) in
            fun e ?loc ~atts () -> coqpp_body e (Attributes.parse 
# 1025 "plugins/ltac2/g_ltac2.mlg"
      raw_attributes
# 4032 "plugins/ltac2/g_ltac2.ml"
 atts)),
          Some (fun e  ~atts -> 
# 1025 "plugins/ltac2/g_ltac2.mlg"
                                                                  Vernacextend.(VtSideff ([], VtNow)) 
# 4037 "plugins/ltac2/g_ltac2.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac2",
           Vernacextend.TyTerminal
           ("Eval",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr),
            Vernacextend.TyNil))),
          (let coqpp_body e () =
            Vernactypes.vtreadproofopt (fun ~pstate -> (
# 1032 "plugins/ltac2/g_ltac2.mlg"
                                                                                                
  fun ~pstate -> Tac2entries.perform_eval ~pstate e
  
# 4053 "plugins/ltac2/g_ltac2.ml"
) ~pstate) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          Some (fun e  ~atts -> 
# 1032 "plugins/ltac2/g_ltac2.mlg"
                                                           Vernacextend.classify_as_query 
# 4060 "plugins/ltac2/g_ltac2.ml"
)))]


# 1037 "plugins/ltac2/g_ltac2.mlg"
 

let _ : Pvernac.proof_mode = Pvernac.register_proof_mode "Ltac2"
    (ProofMode {
        command_entry = tac2mode;
        wit_tactic_expr = Tac2env.wit_ltac2_tac;
        tactic_expr_entry = ltac2_expr;
      })

open Vernacextend

let toplevel_selector = G_vernac.toplevel_selector

let pr_ltac2_selector s = Pp.(Goal_select.pr_goal_selector s ++ str ":")

let pr_ltac2_use_default b =
  if b then (* Bug: a space is inserted before "..." *) str ".." else mt ()

let subprf = G_vernac.subprf
let subprf_with_selector = G_vernac.subprf_with_selector


# 4087 "plugins/ltac2/g_ltac2.ml"

let (wit_ltac2_selector, ltac2_selector) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"ltac2_selector" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (toplevel_selector);
    Vernacextend.arg_printer = fun env sigma -> 
# 1060 "plugins/ltac2/g_ltac2.mlg"
                                                   pr_ltac2_selector 
# 4097 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_ltac2_selector, ltac2_selector)

let (wit_ltac2_use_default, ltac2_use_default) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"ltac2_use_default" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "..."))))
       (fun _ loc -> 
# 1066 "plugins/ltac2/g_ltac2.mlg"
                 true 
# 4113 "plugins/ltac2/g_ltac2.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "."))))
      (fun _ loc -> 
# 1065 "plugins/ltac2/g_ltac2.mlg"
               false 
# 4121 "plugins/ltac2/g_ltac2.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 1064 "plugins/ltac2/g_ltac2.mlg"
                                                      pr_ltac2_use_default 
# 4126 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_ltac2_use_default, ltac2_use_default)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~command:"VernacLtac2"  ?entry:(Some ( tac2mode )) 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_selector)),
          Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr),
          Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_use_default),
          Vernacextend.TyNil))),
          (let coqpp_body g t with_end_tac () =
            Vernactypes.vtmodifyproof (fun ~pstate -> (
# 1071 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call ~pstate g ~with_end_tac t
  
# 4144 "plugins/ltac2/g_ltac2.ml"
) ~pstate) in
            fun g t with_end_tac ?loc ~atts () ->
            coqpp_body g t with_end_tac
              (Attributes.unsupported_attributes atts)),
          Some (fun g t with_end_tac  ~atts -> 
# 1071 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
# 4152 "plugins/ltac2/g_ltac2.ml"
)));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("par",
           Vernacextend.TyTerminal
           (":",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_use_default),
            Vernacextend.TyNil)))),
          (let coqpp_body t with_end_tac () =
            Vernactypes.vtmodifyproof (fun ~pstate -> (
# 1075 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call_par ~pstate ~with_end_tac t
  
# 4169 "plugins/ltac2/g_ltac2.ml"
) ~pstate) in
            fun t with_end_tac ?loc ~atts () ->
            coqpp_body t with_end_tac
              (Attributes.unsupported_attributes atts)),
          Some (fun t with_end_tac  ~atts -> 
# 1075 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
# 4177 "plugins/ltac2/g_ltac2.ml"
)))]

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac2", "g_ltac2.mlg:112")
  tac2mode
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.opt (Procq.Symbol.nterm toplevel_selector))))
                        ((Procq.Symbol.nterm subprf_with_selector)))
                       (fun p g loc -> 
# 1084 "plugins/ltac2/g_ltac2.mlg"
                                                                 Vernacexpr.VernacSynPure (p g) 
# 4191 "plugins/ltac2/g_ltac2.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.nterm subprf)))
                      (fun p loc -> 
# 1083 "plugins/ltac2/g_ltac2.mlg"
                        Vernacexpr.VernacSynPure p 
# 4199 "plugins/ltac2/g_ltac2.ml"
)]))
  in ()


# 1088 "plugins/ltac2/g_ltac2.mlg"
 

open Stdarg

let test_ltac2_ident_aux =
  let open Procq.Lookahead in
  to_entry "test_ltac2_ident" begin
    lk_kw "Ltac2" >> lk_ident
  end


# 4216 "plugins/ltac2/g_ltac2.ml"

let (wit_test_ltac2_ident, test_ltac2_ident) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~name:"test_ltac2_ident" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (test_ltac2_ident_aux);
    Vernacextend.arg_printer = fun env sigma -> 
# 1100 "plugins/ltac2/g_ltac2.mlg"
                                                     fun _ -> Pp.mt() 
# 4226 "plugins/ltac2/g_ltac2.ml"
;
    }
let _ = (wit_test_ltac2_ident, test_ltac2_ident)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac2") ~command:"Ltac2Printers" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_test_ltac2_ident),
           Vernacextend.TyTerminal
           ("Ltac2",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNil)))),
          (let coqpp_body _test tac () =
            Vernactypes.vtdefault (fun () -> 
# 1105 "plugins/ltac2/g_ltac2.mlg"
                                                                  Tac2entries.print_ltac2 tac 
# 4245 "plugins/ltac2/g_ltac2.ml"
) in
            fun _test tac ?loc ~atts () ->
            coqpp_body _test tac (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Ltac2",
            Vernacextend.TyTerminal
            ("Type",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
             Vernacextend.TyNil)))),
          (let coqpp_body tac () = Vernactypes.vtdefault (fun () -> 
# 1106 "plugins/ltac2/g_ltac2.mlg"
                                                 Tac2entries.print_ltac2_type tac 
# 4263 "plugins/ltac2/g_ltac2.ml"
) in
            fun tac ?loc ~atts () ->
            coqpp_body tac (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Locate",
           Vernacextend.TyTerminal
           ("Ltac2",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNil))),
          (let coqpp_body r () = Vernactypes.vtdefault (fun () -> 
# 1107 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.print_located_tactic r 
# 4279 "plugins/ltac2/g_ltac2.ml"
) in
            fun r ?loc ~atts () ->
            coqpp_body r (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Ltac2",
            Vernacextend.TyTerminal ("Signatures", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 1108 "plugins/ltac2/g_ltac2.mlg"
                                        Tac2entries.print_signatures () 
# 4294 "plugins/ltac2/g_ltac2.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac2",
           Vernacextend.TyTerminal
           ("Check",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr),
            Vernacextend.TyNil))),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 1109 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.typecheck_expr e 
# 4310 "plugins/ltac2/g_ltac2.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac2",
           Vernacextend.TyTerminal
           ("Globalize",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr),
            Vernacextend.TyNil))),
          (let coqpp_body e () = Vernactypes.vtdefault (fun () -> 
# 1110 "plugins/ltac2/g_ltac2.mlg"
                                             Tac2entries.globalize_expr e 
# 4326 "plugins/ltac2/g_ltac2.ml"
) in
            fun e ?loc ~atts () ->
            coqpp_body e (Attributes.unsupported_attributes atts)),
          None))]

