/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceRef;
import org.apache.naming.StringManager;
import org.apache.naming.factory.FactoryBase;

public class ResourceFactory
extends FactoryBase {
    private static final StringManager sm = StringManager.getManager(ResourceFactory.class);

    @Override
    protected boolean isReferenceTypeSupported(Object object) {
        return object instanceof ResourceRef;
    }

    @Override
    protected ObjectFactory getDefaultFactory(Reference reference) throws NamingException {
        ObjectFactory objectFactory = null;
        if (reference.getClassName().equals("javax.sql.DataSource")) {
            String string = System.getProperty("javax.sql.DataSource.Factory", "org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory");
            try {
                objectFactory = (ObjectFactory)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(sm.getString("resourceFactory.factoryCreationError"));
                namingException.initCause(exception);
                throw namingException;
            }
        }
        if (reference.getClassName().equals("jakarta.mail.Session")) {
            String string = System.getProperty("jakarta.mail.Session.Factory", "org.apache.naming.factory.MailSessionFactory");
            try {
                objectFactory = (ObjectFactory)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof VirtualMachineError) {
                    throw (VirtualMachineError)throwable;
                }
                NamingException namingException = new NamingException(sm.getString("resourceFactory.factoryCreationError"));
                namingException.initCause(throwable);
                throw namingException;
            }
        }
        return objectFactory;
    }

    @Override
    protected Object getLinked(Reference reference) {
        return null;
    }
}

