/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class AlertTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon LEAF_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document.png")));
    private static final ImageIcon FOLDER_OPEN_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open.png")));
    private static final ImageIcon FOLDER_CLOSED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal.png")));

    public AlertTreeCellRenderer() {
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof AlertNode) {
            AlertNode alertNode = (AlertNode)value;
            if (alertNode.isRoot()) {
                if (expanded) {
                    this.setIcon(FOLDER_OPEN_ICON);
                } else {
                    this.setIcon(FOLDER_CLOSED_ICON);
                }
            } else if (alertNode.getParent().isRoot()) {
                this.setIcon(alertNode.getAlert().getIcon());
            } else {
                this.setIcon(LEAF_ICON);
            }
            if (alertNode.getChildCount() > 1) {
                if (alertNode.isSystemic()) {
                    this.setText(Constant.messages.getString("alert.label.namesystemic", alertNode));
                } else {
                    this.setText(Constant.messages.getString("alert.label.namecount", alertNode, alertNode.getChildCount()));
                }
            }
        }
        return this;
    }
}

