/// AUTO GENERATED BY build.rs

use std::collections::HashMap;

use webrender_build::shader::ShaderVersion;

pub struct SourceWithDigest {
    pub source: &'static str,
    pub digest: &'static str,
}

pub struct OptimizedSourceWithDigest {
    pub vert_source: &'static str,
    pub frag_source: &'static str,
    pub digest: &'static str,
}

lazy_static! {
  pub static ref UNOPTIMIZED_SHADERS: HashMap<&'static str, SourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert("base", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/base.glsl"), digest: "d5ae695bab268b7d"});
    shaders.insert("blend", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/blend.glsl"), digest: "c24d37103d7732b9"});
    shaders.insert("brush", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush.glsl"), digest: "58bce78ff7dc5e41"});
    shaders.insert("brush_blend", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_blend.glsl"), digest: "8d15e4c39cebc5b8"});
    shaders.insert("brush_image", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_image.glsl"), digest: "a19dec3f8cf17ad3"});
    shaders.insert("brush_linear_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_linear_gradient.glsl"), digest: "9710fdb1cc4f986d"});
    shaders.insert("brush_mix_blend", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_mix_blend.glsl"), digest: "1ba02eabf2bb77ff"});
    shaders.insert("brush_opacity", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_opacity.glsl"), digest: "25abae646bbb15f4"});
    shaders.insert("brush_solid", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_solid.glsl"), digest: "9ea0809ef65a65cd"});
    shaders.insert("brush_yuv_image", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/brush_yuv_image.glsl"), digest: "a7521f1a305f8c49"});
    shaders.insert("clip_shared", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/clip_shared.glsl"), digest: "47253a642bd1ef3"});
    shaders.insert("composite", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/composite.glsl"), digest: "311fea5a9754be8a"});
    shaders.insert("cs_blur", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_blur.glsl"), digest: "3a52c16888d617"});
    shaders.insert("cs_border_segment", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_border_segment.glsl"), digest: "f932102f2f5290e3"});
    shaders.insert("cs_border_solid", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_border_solid.glsl"), digest: "d4b0ffe14c4ae963"});
    shaders.insert("cs_clip_box_shadow", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_clip_box_shadow.glsl"), digest: "2d11886d2461fbe6"});
    shaders.insert("cs_clip_rectangle", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_clip_rectangle.glsl"), digest: "62d4648f164609cd"});
    shaders.insert("cs_conic_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_conic_gradient.glsl"), digest: "646a432a2a0717f7"});
    shaders.insert("cs_fast_linear_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_fast_linear_gradient.glsl"), digest: "43c28ee12bf6332f"});
    shaders.insert("cs_line_decoration", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_line_decoration.glsl"), digest: "119284335ea1ca4a"});
    shaders.insert("cs_linear_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_linear_gradient.glsl"), digest: "7dabc4a61170d123"});
    shaders.insert("cs_radial_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_radial_gradient.glsl"), digest: "b0d151db5ba40246"});
    shaders.insert("cs_scale", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_scale.glsl"), digest: "ab94c8ebe3517df0"});
    shaders.insert("cs_svg_filter", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_svg_filter.glsl"), digest: "7b0a93d4b093ba5c"});
    shaders.insert("cs_svg_filter_node", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/cs_svg_filter_node.glsl"), digest: "fe8c4121e1d56431"});
    shaders.insert("debug_color", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/debug_color.glsl"), digest: "106571913dcb80b7"});
    shaders.insert("debug_font", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/debug_font.glsl"), digest: "e60d45220ba0a5a6"});
    shaders.insert("ellipse", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ellipse.glsl"), digest: "951dc637533b8416"});
    shaders.insert("gpu_buffer", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/gpu_buffer.glsl"), digest: "f52320b7c2b8b390"});
    shaders.insert("gpu_cache", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/gpu_cache.glsl"), digest: "e99b57d9cc26406a"});
    shaders.insert("gpu_cache_update", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/gpu_cache_update.glsl"), digest: "4ad2e4e46e03b7c2"});
    shaders.insert("gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/gradient.glsl"), digest: "99c5ea69716965f7"});
    shaders.insert("gradient_shared", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/gradient_shared.glsl"), digest: "66bd9658fc0d3e37"});
    shaders.insert("prim_shared", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/prim_shared.glsl"), digest: "6fd009edb6ed909c"});
    shaders.insert("ps_clear", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_clear.glsl"), digest: "f7c149e45c2a028c"});
    shaders.insert("ps_copy", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_copy.glsl"), digest: "f0e76514309bd9fa"});
    shaders.insert("ps_quad", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_quad.glsl"), digest: "46fca1a0e62b4d5a"});
    shaders.insert("ps_quad_conic_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_quad_conic_gradient.glsl"), digest: "a6a2fdb07fffc9f8"});
    shaders.insert("ps_quad_mask", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_quad_mask.glsl"), digest: "e677cbbd0a831292"});
    shaders.insert("ps_quad_radial_gradient", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_quad_radial_gradient.glsl"), digest: "6d64101b301fad0d"});
    shaders.insert("ps_quad_textured", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_quad_textured.glsl"), digest: "d73e383ce2d1798a"});
    shaders.insert("ps_split_composite", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_split_composite.glsl"), digest: "c1b8fc5a705127c7"});
    shaders.insert("ps_text_run", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/ps_text_run.glsl"), digest: "7031fc85e3bb4dbb"});
    shaders.insert("rect", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/rect.glsl"), digest: "fc8ccaeee104d458"});
    shaders.insert("render_task", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/render_task.glsl"), digest: "e63b52526d4047fd"});
    shaders.insert("sample_color0", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/sample_color0.glsl"), digest: "665e987cdc6ba1b4"});
    shaders.insert("shared", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/shared.glsl"), digest: "e4de7fd1d1626337"});
    shaders.insert("shared_other", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/shared_other.glsl"), digest: "9f6298a27dfe79c6"});
    shaders.insert("transform", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/transform.glsl"), digest: "19d18cb3634fb3d7"});
    shaders.insert("yuv", SourceWithDigest { source: include_str!("/build/iceweasel/src/firefox-144.0/gfx/wr/webrender/res/yuv.glsl"), digest: "383f9ac08235cb6e"});
    shaders
  };

  pub static ref OPTIMIZED_SHADERS: HashMap<(ShaderVersion, &'static str), OptimizedSourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert((ShaderVersion::Gl, "brush_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_Gl.frag"),
        digest: "b345368f881bd74",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_ALPHA_PASS_Gl.frag"),
        digest: "41070540e5dc3364",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "69c08c232544f0b4",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "dca06bd9303c74a5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "ec8c060bdb49c5f6",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "4c616597558833cd",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "a10e81683b4a5276",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "622c9040306225d",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "f79baad6ea650239",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "15b65307ff8d3e27",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "318a5cdf3bf27a79",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "cd198d6cbdaad76d",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.frag"),
        digest: "13bf50e5148b80a0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "bd010c4b3f7ace8a",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "bd39313faa294596",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "a6e51d82485fbdf7",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "beafa0b0e824bbbb",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "92517b0b263011b4",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "12f9fdca1c1364f1",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "64a7473aac72c8fe",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.frag"),
        digest: "92383606f09cb1af",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_TEXTURE_2D_Gl.frag"),
        digest: "afde7546fe07bcda",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_image_TEXTURE_RECT_Gl.frag"),
        digest: "2eed2aef3ab50914",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_Gl.frag"),
        digest: "4d23702269348d32",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_ALPHA_PASS_Gl.frag"),
        digest: "e5f08b12f64ceef3",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.frag"),
        digest: "5004b1540efe3fe9",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_Gl.frag"),
        digest: "cf44a7aabb071a64",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_ALPHA_PASS_Gl.frag"),
        digest: "46074fb69b8c0f9",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "898c2725b2375c55",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_Gl.frag"),
        digest: "788e620c5ff6bea0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ALPHA_PASS_Gl.frag"),
        digest: "188ffbff87e21358",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.frag"),
        digest: "e1efcf3aec569a49",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ANTIALIASING_Gl.frag"),
        digest: "507b85d10dab89fa",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.frag"),
        digest: "7357e65ab3740854",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_opacity_DEBUG_OVERDRAW_Gl.frag"),
        digest: "f2774686e78f3f30",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_Gl.frag"),
        digest: "b0497ce257b3a069",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_ALPHA_PASS_Gl.frag"),
        digest: "ddf425b0b2fe2991",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_solid_DEBUG_OVERDRAW_Gl.frag"),
        digest: "5908167cc8282afb",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.frag"),
        digest: "45f9cf3e757ccb7b",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "4a21655cd6dd88bf",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.frag"),
        digest: "e431e2ddcf78620f",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "d9d0a7b979b7e4f5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.frag"),
        digest: "cf698b6da9d553a0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "3a5954dac1176b97",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_2D_Gl.frag"),
        digest: "38337df702db9563",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.frag"),
        digest: "b110320ae45549f4",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_RECT_Gl.frag"),
        digest: "9b2aaced4f63da7a",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "59af6a9ec94e3c8",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_2D_Gl.frag"),
        digest: "b32d10135c3b408c",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_2D_YUV_Gl.frag"),
        digest: "f6074057f0d78cc0",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_RECT_Gl.frag"),
        digest: "daedc68c52f634ec",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/composite_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "3343284f00e49354",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_ALPHA_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_blur_ALPHA_TARGET_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_blur_ALPHA_TARGET_Gl.frag"),
        digest: "1b00c373598eba4c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_COLOR_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_blur_COLOR_TARGET_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_blur_COLOR_TARGET_Gl.frag"),
        digest: "c15f1f64491e4156",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_segment"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_border_segment_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_border_segment_Gl.frag"),
        digest: "8495134f5ed37bf5",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_border_solid_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_border_solid_Gl.frag"),
        digest: "9fd688a8c266d2da",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_box_shadow_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_box_shadow_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_box_shadow_TEXTURE_2D_Gl.frag"),
        digest: "9f76c2a874c97310",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_rectangle_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_rectangle_Gl.frag"),
        digest: "cabc2ef7edf7bd12",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_rectangle_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_clip_rectangle_FAST_PATH_Gl.frag"),
        digest: "34a6b9252197cd36",
    });
    shaders.insert((ShaderVersion::Gl, "cs_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_conic_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_conic_gradient_Gl.frag"),
        digest: "62367e600dc704f2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_fast_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_fast_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_fast_linear_gradient_Gl.frag"),
        digest: "3d4ec20a2b40f905",
    });
    shaders.insert((ShaderVersion::Gl, "cs_line_decoration"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_line_decoration_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_line_decoration_Gl.frag"),
        digest: "7943c68da0973c69",
    });
    shaders.insert((ShaderVersion::Gl, "cs_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_linear_gradient_Gl.frag"),
        digest: "efc10ff6f6cc1952",
    });
    shaders.insert((ShaderVersion::Gl, "cs_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_radial_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_radial_gradient_Gl.frag"),
        digest: "7336dc777aa9329c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_scale_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_scale_TEXTURE_2D_Gl.frag"),
        digest: "287afd7873f6d6b2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_scale_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_scale_TEXTURE_RECT_Gl.frag"),
        digest: "4fbbb7c5d7cb368e",
    });
    shaders.insert((ShaderVersion::Gl, "cs_svg_filter"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_svg_filter_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_svg_filter_Gl.frag"),
        digest: "aca9420acaec4776",
    });
    shaders.insert((ShaderVersion::Gl, "cs_svg_filter_node"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_svg_filter_node_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/cs_svg_filter_node_Gl.frag"),
        digest: "dc5839ff95325e4b",
    });
    shaders.insert((ShaderVersion::Gl, "debug_color"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/debug_color_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/debug_color_Gl.frag"),
        digest: "f458fe7ea40bd77e",
    });
    shaders.insert((ShaderVersion::Gl, "debug_font"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/debug_font_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/debug_font_Gl.frag"),
        digest: "503ec56c19b6bd2c",
    });
    shaders.insert((ShaderVersion::Gl, "ps_clear"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_clear_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_clear_Gl.frag"),
        digest: "9ef2acc3bbd621e8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_copy"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_copy_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_copy_Gl.frag"),
        digest: "514726576460ee72",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_conic_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_conic_gradient_Gl.frag"),
        digest: "16fe52a0742660e3",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_mask_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_mask_Gl.frag"),
        digest: "f70f706336a8d714",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_mask_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_mask_FAST_PATH_Gl.frag"),
        digest: "c28d927892f5ec21",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_radial_gradient_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_radial_gradient_Gl.frag"),
        digest: "35932314a096f9d7",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_textured"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_textured_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_quad_textured_Gl.frag"),
        digest: "f27716a324dc7e8d",
    });
    shaders.insert((ShaderVersion::Gl, "ps_split_composite"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_split_composite_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_split_composite_Gl.frag"),
        digest: "27bd711c7db419b7",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "eb5ca8b99ce6235b",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "d955a1edf5473a6c",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "b8f8566478811481",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "dc32699d7dc45ed8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "8a12662afced9b0f",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/iceweasel/src/firefox-144.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-fdf436b2dd98ad0e/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "5bc021f417f4e04a",
    });
    shaders
  };
}
