/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. SEE devtools/client/webconsole/test/README.md.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers.js");
const { prepareMessage } = require("resource://devtools/client/webconsole/utils/messages.js");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("resource://devtools/client/webconsole/types.js");

const rawPackets = new Map();
rawPackets.set(`ReferenceError: asdf is not defined`, {
  "pageError": {
    "errorMessage": "ReferenceError: asdf is not defined",
    "errorMessageName": "JSMSG_NOT_DEFINED",
    "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
    "sourceName": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source22",
    "lineNumber": 3,
    "columnNumber": 5,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 3,
        "columnNumber": 5,
        "functionName": "bar"
      },
      {
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 6,
        "columnNumber": 5,
        "functionName": "foo"
      },
      {
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source22",
        "lineNumber": 9,
        "columnNumber": 3,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 117 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 118,
        "columnNumber": 33,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 66,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn0.watcher2.process9//obj22",
        "class": "ReferenceError",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "ReferenceError",
          "message": "asdf is not defined",
          "stack": "bar@https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:3:5\nfoo@https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:6:5\n@https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:9:3\n",
          "fileName": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 3,
          "columnNumber": 5
        }
      },
      "actorID": "server0.conn0.watcher2.process9//obj22"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`TypeError longString message`, {
  "pageError": {
    "errorMessage": {
      "_grip": {
        "type": "longString",
        "actor": "server0.conn0.watcher2.process9//longstractor24",
        "length": 110007,
        "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
      },
      "actorID": "server0.conn0.watcher2.process9//longstractor24"
    },
    "errorMessageName": "",
    "sourceName": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "sourceId": "server0.conn0.child1/source23",
    "lineNumber": 1,
    "columnNumber": 7,
    "category": "content javascript",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": false,
    "error": true,
    "info": false,
    "private": false,
    "stacktrace": [
      {
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "sourceId": "server0.conn0.child1/source23",
        "lineNumber": 1,
        "columnNumber": 7,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js line 117 > eval",
        "sourceId": null,
        "lineNumber": 6,
        "columnNumber": 29,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 118,
        "columnNumber": 33,
        "functionName": null
      },
      {
        "filename": "resource://testing-common/content-task.js",
        "sourceId": null,
        "lineNumber": 66,
        "columnNumber": 19,
        "functionName": null,
        "asyncCause": "MessageListener.receiveMessage"
      }
    ],
    "notes": null,
    "chromeContext": false,
    "isPromiseRejection": false,
    "isForwardedFromContentProcess": false,
    "exception": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn0.watcher2.process9//obj25",
        "class": "Error",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": {
            "_grip": {
              "type": "longString",
              "actor": "server0.conn0.watcher2.process9//longstractor26",
              "length": 110000,
              "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
            },
            "actorID": "server0.conn0.watcher2.process9//longstractor26"
          },
          "stack": "@https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html:1:7\n",
          "fileName": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
          "lineNumber": 1,
          "columnNumber": 7
        }
      },
      "actorID": "server0.conn0.watcher2.process9//obj25"
    },
    "hasException": true
  },
  "resourceType": "error-message",
  "isAlreadyExistingResource": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
