/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import viz.DensiTree;
import viz.Node;

public class TreeFileParser {
    static final float DEFAULT_LENGTH = 0.001f;
    int m_nOffset = 0;
    Vector<String> m_sLabels;
    Vector<Float> m_fLongitude;
    Vector<Float> m_fLatitude;
    float m_fMaxLong;
    float m_fMaxLat;
    float m_fMinLong;
    float m_fMinLat;
    int m_nNrOfLabels;
    int m_nBurnIn = 0;
    boolean m_bBurnInIsPercentage = true;
    boolean m_bSurpressMetadata = true;
    boolean m_bIsLabelledNewick = false;
    boolean m_bAllowSingleChild = false;
    char[] m_chars;
    int m_iTokenStart;
    int m_iTokenEnd;
    static final int COMMA = 1;
    static final int BRACE_OPEN = 3;
    static final int BRACE_CLOSE = 4;
    static final int COLON = 5;
    static final int SEMI_COLON = 8;
    static final int META_DATA = 6;
    static final int TEXT = 7;
    static final int UNKNOWN = 0;

    public TreeFileParser(DensiTree densiTree) {
        this.m_sLabels = densiTree.m_sLabels;
        this.m_fLongitude = densiTree.m_fLongitude;
        this.m_fLatitude = densiTree.m_fLatitude;
        this.m_nBurnIn = densiTree.m_nBurnIn;
        this.m_bBurnInIsPercentage = densiTree.m_bBurnInIsPercentage;
        this.m_fMinLat = 90.0f;
        this.m_fMinLong = 180.0f;
        this.m_fMaxLat = -90.0f;
        this.m_fMaxLong = -180.0f;
        this.m_bAllowSingleChild = densiTree.m_bAllowSingleChild;
    }

    public TreeFileParser(Vector<String> sLabels, Vector<Float> fLongitude, Vector<Float> fLatitude, int nBurnIn) {
        this.m_sLabels = sLabels;
        if (this.m_sLabels != null) {
            this.m_bIsLabelledNewick = true;
            this.m_nNrOfLabels = this.m_sLabels.size();
        }
        this.m_fLongitude = fLongitude;
        this.m_fLatitude = fLatitude;
        this.m_nBurnIn = nBurnIn;
        this.m_fMinLat = 90.0f;
        this.m_fMinLong = 180.0f;
        this.m_fMaxLat = -90.0f;
        this.m_fMaxLong = -180.0f;
    }

    public Node[] parseFile(String sFile) throws Exception {
        boolean bAddLabels;
        Vector<Node> trees = new Vector<Node>();
        this.m_nOffset = 0;
        File file = new File(sFile);
        long nFileSize = file.length();
        BufferedReader fin = new BufferedReader(new FileReader(sFile));
        String sStr = fin.readLine();
        nFileSize -= (long)sStr.length();
        while (fin.ready() && sStr.toLowerCase().indexOf("translate") < 0) {
            sStr = fin.readLine();
            nFileSize -= (long)sStr.length();
        }
        this.m_bIsLabelledNewick = false;
        this.m_nNrOfLabels = this.m_sLabels.size();
        boolean bl = bAddLabels = this.m_nNrOfLabels == 0;
        if (sStr.toLowerCase().indexOf("translate") < 0) {
            this.m_bIsLabelledNewick = true;
            fin.close();
            fin = new BufferedReader(new FileReader(sFile));
            int nBurnIn = this.m_nBurnIn;
            if (this.m_bBurnInIsPercentage) {
                nFileSize = file.length();
                nBurnIn = (int)((long)this.m_nBurnIn * nFileSize / 100L);
            }
            while (fin.ready() && this.m_nNrOfLabels == 0) {
                nFileSize = file.length();
                sStr = fin.readLine();
                nBurnIn = this.m_bBurnInIsPercentage ? (nBurnIn -= sStr.length()) : --nBurnIn;
                if (sStr.length() <= 2 || sStr.indexOf("(") < 0) continue;
                String sStr2 = sStr;
                sStr2 = sStr2.substring(sStr2.indexOf("("));
                while (sStr2.indexOf(91) >= 0) {
                    int i0 = sStr2.indexOf(91);
                    int i1 = sStr2.indexOf(93);
                    sStr2 = String.valueOf(sStr2.substring(0, i0)) + sStr2.substring(i1 + 1);
                }
                sStr2 = sStr2.replaceAll("[;\\(\\),]", " ");
                sStr2 = sStr2.replaceAll(":\\s*[0-9\\.Ee-]+", " ");
                String[] sLabels = sStr2.split("\\s+");
                if (bAddLabels) {
                    this.m_nNrOfLabels = 0;
                    int i = 0;
                    while (i < sLabels.length) {
                        if (sLabels[i].length() > 0) {
                            this.m_sLabels.add(sLabels[i]);
                            ++this.m_nNrOfLabels;
                        }
                        ++i;
                    }
                }
                if (nBurnIn >= 0) continue;
                Node tree = this.parseNewick(sStr);
                tree.sort();
                tree.labelInternalNodes(this.m_nNrOfLabels);
                trees.add(tree);
            }
            while (fin.ready()) {
                sStr = fin.readLine();
                if (sStr.length() <= 2 || sStr.indexOf("(") < 0) continue;
                Node tree = this.parseNewick(sStr);
                tree.sort();
                tree.labelInternalNodes(this.m_nNrOfLabels);
                trees.add(tree);
                if (trees.size() % 100 != 0 || this.m_nNrOfLabels < 100 && trees.size() % 1000 != 0) continue;
                System.err.print(String.valueOf(trees.size()) + " ");
            }
        } else {
            sStr = fin.readLine();
            nFileSize -= (long)sStr.length();
            boolean bLastLabel = false;
            while (fin.ready() && !bLastLabel) {
                if (sStr.indexOf(";") >= 0) {
                    sStr = sStr.replace(';', ' ');
                    if ((sStr = sStr.trim()).isEmpty()) break;
                    bLastLabel = true;
                }
                sStr = sStr.replaceAll(",", "");
                sStr = sStr.replaceAll("^\\s+", "");
                String[] sStrs = sStr.split("\\s+");
                int iLabel = new Integer(sStrs[0]);
                String sLabel = sStrs[1];
                if (this.m_sLabels.size() < iLabel) {
                    this.m_nOffset = 1;
                }
                if (sLabel.contains("(")) {
                    int iStr3;
                    int iStr = sLabel.indexOf(40);
                    int iStr2 = sLabel.indexOf(120, iStr);
                    if (iStr2 >= 0 && (iStr3 = sLabel.indexOf(41, iStr2)) >= 0) {
                        float fLat = Float.parseFloat(sLabel.substring(iStr + 1, iStr2));
                        float fLong = Float.parseFloat(sLabel.substring(iStr2 + 1, iStr3));
                        if (fLat != 0.0f || fLong != 0.0f) {
                            this.m_fMinLat = Math.min(this.m_fMinLat, fLat);
                            this.m_fMaxLat = Math.max(this.m_fMaxLat, fLat);
                            this.m_fMinLong = Math.min(this.m_fMinLong, fLong);
                            this.m_fMaxLong = Math.max(this.m_fMaxLong, fLong);
                        }
                        while (this.m_fLatitude.size() < this.m_sLabels.size()) {
                            this.m_fLatitude.add(Float.valueOf(0.0f));
                            this.m_fLongitude.add(Float.valueOf(0.0f));
                        }
                        this.m_fLatitude.add(Float.valueOf(fLat));
                        this.m_fLongitude.add(Float.valueOf(fLong));
                    }
                    sLabel = sLabel.substring(0, sLabel.indexOf("("));
                }
                if (bAddLabels) {
                    this.m_sLabels.add(sLabel);
                    ++this.m_nNrOfLabels;
                }
                if (bLastLabel) continue;
                sStr = fin.readLine();
                nFileSize -= (long)sStr.length();
            }
            int nBurnIn = this.m_nBurnIn;
            if (this.m_bBurnInIsPercentage) {
                nBurnIn = (int)((long)this.m_nBurnIn * nFileSize / 100L);
            }
            while (fin.ready()) {
                String sTree;
                sStr = fin.readLine();
                if (this.m_bBurnInIsPercentage) {
                    nBurnIn -= sStr.length();
                }
                if ((sStr = sStr.trim()).length() <= 5 || !(sTree = sStr.substring(0, 5)).toLowerCase().startsWith("tree ")) continue;
                if (nBurnIn <= 0) {
                    int i = sStr.indexOf(40);
                    if (i > 0) {
                        sStr = sStr.substring(i);
                    }
                    Node tree = this.parseNewick(sStr);
                    tree.sort();
                    tree.labelInternalNodes(this.m_nNrOfLabels);
                    trees.add(tree);
                    if (trees.size() % 100 != 0 || this.m_nNrOfLabels < 100 && trees.size() % 1000 != 0) continue;
                    System.err.print(String.valueOf(trees.size()) + " ");
                    continue;
                }
                if (this.m_bBurnInIsPercentage) continue;
                --nBurnIn;
            }
            fin.close();
            if (nBurnIn > 0) {
                System.err.println("WARNING: Burn-in too large, resetting burn-in to default");
                this.m_sLabels.clear();
                this.m_nBurnIn = this.m_bBurnInIsPercentage ? 10 : 0;
                return this.parseFile(sFile);
            }
        }
        System.err.println();
        System.err.println("Geo: " + this.m_fMinLong + "x" + this.m_fMinLat + " " + this.m_fMaxLong + "x" + this.m_fMaxLat);
        return trees.toArray(new Node[1]);
    }

    private int getLabelIndex(String sStr) throws Exception {
        if (!this.m_bIsLabelledNewick) {
            try {
                return Integer.parseInt(sStr) - this.m_nOffset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.m_nNrOfLabels) {
            if (sStr.equals(this.m_sLabels.elementAt(i))) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_nNrOfLabels) {
            String sLabel = this.m_sLabels.elementAt(i);
            if ((sLabel.startsWith("'") && sLabel.endsWith("'") || sLabel.startsWith("\"") && sLabel.endsWith("\"")) && sStr.equals(sLabel = sLabel.substring(1, sLabel.length() - 1))) {
                return i;
            }
            ++i;
        }
        if (sStr.startsWith("'") && sStr.endsWith("'") || sStr.startsWith("\"") && sStr.endsWith("\"")) {
            sStr = sStr.substring(1, sStr.length() - 1);
            return this.getLabelIndex(sStr);
        }
        throw new Exception("Label '" + sStr + "' in Newick tree could not be identified");
    }

    float height(Node node) {
        if (node.isLeaf()) {
            return node.m_fLength;
        }
        return node.m_fLength + Math.max(this.height(node.m_left), this.height(node.m_right));
    }

    /*
     * Unable to fully structure code
     */
    int nextToken() {
        block8: {
            this.m_iTokenStart = this.m_iTokenEnd;
            if (this.m_iTokenEnd >= this.m_chars.length) break block8;
            while (this.m_iTokenEnd < this.m_chars.length && (this.m_chars[this.m_iTokenEnd] == ' ' || this.m_chars[this.m_iTokenEnd] == '\t')) {
                ++this.m_iTokenStart;
                ++this.m_iTokenEnd;
            }
            if (this.m_chars[this.m_iTokenEnd] == '(') {
                ++this.m_iTokenEnd;
                return 3;
            }
            if (this.m_chars[this.m_iTokenEnd] == ':') {
                ++this.m_iTokenEnd;
                return 5;
            }
            if (this.m_chars[this.m_iTokenEnd] == ';') {
                ++this.m_iTokenEnd;
                return 8;
            }
            if (this.m_chars[this.m_iTokenEnd] == ')') {
                ++this.m_iTokenEnd;
                return 4;
            }
            if (this.m_chars[this.m_iTokenEnd] == ',') {
                ++this.m_iTokenEnd;
                return 1;
            }
            if (this.m_chars[this.m_iTokenEnd] != '[') ** GOTO lbl29
            ++this.m_iTokenEnd;
            while (this.m_iTokenEnd < this.m_chars.length && this.m_chars[this.m_iTokenEnd - 1] != ']') {
                ++this.m_iTokenEnd;
            }
            return 6;
lbl-1000:
            // 1 sources

            {
                ++this.m_iTokenEnd;
lbl29:
                // 2 sources

                ** while (this.m_iTokenEnd < this.m_chars.length && this.m_chars[this.m_iTokenEnd] != ' ' && this.m_chars[this.m_iTokenEnd] != '\t' && this.m_chars[this.m_iTokenEnd] != '(' && this.m_chars[this.m_iTokenEnd] != ')' && this.m_chars[this.m_iTokenEnd] != '[' && this.m_chars[this.m_iTokenEnd] != ':' && this.m_chars[this.m_iTokenEnd] != ',' && this.m_chars[this.m_iTokenEnd] != ';')
            }
lbl30:
            // 1 sources

            return 7;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parseNewick(String sStr) throws Exception {
        try {
            if (sStr == null || sStr.length() == 0) {
                return null;
            }
            this.m_chars = sStr.toCharArray();
            this.m_iTokenStart = sStr.indexOf(40);
            if (this.m_iTokenStart < 0) {
                return null;
            }
            this.m_iTokenEnd = this.m_iTokenStart;
            Vector<Node> stack = new Vector<Node>();
            Vector<Boolean> isFirstChild = new Vector<Boolean>();
            stack.add(new Node());
            isFirstChild.add(true);
            ((Node)stack.lastElement()).m_fLength = 0.001f;
            boolean bIsLabel = true;
            while (this.m_iTokenEnd < this.m_chars.length) {
                block1 : switch (this.nextToken()) {
                    case 3: {
                        Node node2 = new Node();
                        node2.m_fLength = 0.001f;
                        stack.add(node2);
                        isFirstChild.add(true);
                        bIsLabel = true;
                        break;
                    }
                    case 4: {
                        Node parent;
                        if (((Boolean)isFirstChild.lastElement()).booleanValue()) {
                            if (!this.m_bAllowSingleChild) {
                                throw new Exception("Node with single child found.");
                            }
                            Node left = (Node)stack.lastElement();
                            stack.remove(stack.size() - 1);
                            isFirstChild.remove(isFirstChild.size() - 1);
                            Node dummyparent = new Node();
                            dummyparent.m_fLength = 0.001f;
                            dummyparent.m_left = left;
                            left.m_Parent = dummyparent;
                            dummyparent.m_right = null;
                            parent = (Node)stack.lastElement();
                            parent.m_left = left;
                            left.m_Parent = parent;
                            break;
                        }
                        while (true) {
                            Node left;
                            Node right;
                            if (((Boolean)isFirstChild.elementAt(isFirstChild.size() - 2)).booleanValue()) {
                                right = (Node)stack.lastElement();
                                stack.remove(stack.size() - 1);
                                isFirstChild.remove(isFirstChild.size() - 1);
                                left = (Node)stack.lastElement();
                                stack.remove(stack.size() - 1);
                                isFirstChild.remove(isFirstChild.size() - 1);
                                parent = (Node)stack.lastElement();
                                parent.m_left = left;
                                left.m_Parent = parent;
                                parent.m_right = right;
                                right.m_Parent = parent;
                                break block1;
                            }
                            right = (Node)stack.lastElement();
                            stack.remove(stack.size() - 1);
                            isFirstChild.remove(isFirstChild.size() - 1);
                            left = (Node)stack.lastElement();
                            stack.remove(stack.size() - 1);
                            isFirstChild.remove(isFirstChild.size() - 1);
                            Node dummyparent = new Node();
                            dummyparent.m_fLength = 0.001f;
                            dummyparent.m_left = left;
                            left.m_Parent = dummyparent;
                            dummyparent.m_right = right;
                            right.m_Parent = dummyparent;
                            stack.add(dummyparent);
                            isFirstChild.add(false);
                        }
                    }
                    case 1: {
                        Node node2 = new Node();
                        node2.m_fLength = 0.001f;
                        stack.add(node2);
                        isFirstChild.add(false);
                        bIsLabel = true;
                        break;
                    }
                    case 5: {
                        bIsLabel = false;
                        break;
                    }
                    case 7: {
                        if (bIsLabel) {
                            String sLabel = sStr.substring(this.m_iTokenStart, this.m_iTokenEnd);
                            ((Node)stack.lastElement()).m_iLabel = this.getLabelIndex(sLabel);
                            break;
                        }
                        String sLength = sStr.substring(this.m_iTokenStart, this.m_iTokenEnd);
                        ((Node)stack.lastElement()).m_fLength = Float.parseFloat(sLength);
                        break;
                    }
                    case 6: {
                        if (((Node)stack.lastElement()).getMetaData() == null) {
                            ((Node)stack.lastElement()).setMetaData(sStr.substring(this.m_iTokenStart + 1, this.m_iTokenEnd - 1));
                            break;
                        }
                        ((Node)stack.lastElement()).setMetaData(String.valueOf(((Node)stack.lastElement()).getMetaData()) + "," + sStr.substring(this.m_iTokenStart + 1, this.m_iTokenEnd - 1));
                        break;
                    }
                    case 8: {
                        return (Node)stack.lastElement();
                    }
                    default: {
                        throw new Exception("parseNewick: unknown token");
                    }
                }
            }
            return (Node)stack.lastElement();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(e.getMessage()) + ": " + sStr.substring(Math.max(0, this.m_iTokenStart - 100), this.m_iTokenStart) + " >>>" + sStr.substring(this.m_iTokenStart, this.m_iTokenEnd) + " <<< ...");
            throw new Exception(String.valueOf(e.getMessage()) + ": " + sStr.substring(Math.max(0, this.m_iTokenStart - 100), this.m_iTokenStart) + " >>>" + sStr.substring(this.m_iTokenStart, this.m_iTokenEnd) + " <<< ...");
        }
    }
}

